/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.mobly;

import com.android.tradefed.testtype.mobly.IMoblyYamlResultHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultHandlerFactory;
import java.util.Map;

public class MoblyYamlResultControllerInfoHandler
implements IMoblyYamlResultHandler {
    private static final String TIME_STAMP = "Timestamp";

    @Override
    public ControllerInfo handle(Map<String, Object> docMap) {
        ControllerInfo.Builder builder = ControllerInfo.builder();
        builder.setTimestamp(String.valueOf(docMap.get(TIME_STAMP)));
        return builder.build();
    }

    public static class ControllerInfo
    implements IMoblyYamlResultHandler.ITestResult {
        private final long mTimestamp;

        private ControllerInfo(String timestamp) {
            this.mTimestamp = Math.round(Double.parseDouble(timestamp) * 1000.0);
        }

        @Override
        public MoblyYamlResultHandlerFactory.Type getType() {
            return MoblyYamlResultHandlerFactory.Type.CONTROLLER_INFO;
        }

        public long getTimeStamp() {
            return this.mTimestamp;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String mTimestamp;

            public Builder setTimestamp(String timestamp) {
                this.mTimestamp = timestamp;
                return this;
            }

            public ControllerInfo build() {
                return new ControllerInfo(this.mTimestamp);
            }
        }
    }
}

