/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util;

import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.error.HarnessException;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.SystemUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class DeviceActionUtil {
    private static final String BUNDLETOOL_FLAG = "--da_bundletool";
    private static final String CREDENTIAL_FLAG = "--da_cred_file";
    private static final String ADB_FLAG = "--adb";
    private static final String AAPT_FLAG = "--aapt";
    private static final String JAVA_BIN_FLAG = "--java_command_path";
    private static final String GEN_DIR_FLAG = "--da_gen_file_dir";
    private static final String TMP_DIR_FLAG = "--tmp_dir_root";
    private static final String GOOGLE_APPLICATION_CREDENTIALS = "GOOGLE_APPLICATION_CREDENTIALS";
    private static final String PATH = "PATH";
    private static final String HOST_LOG = "host_log_";
    private static final String DA_TMP_DIR = "da_tmp_dir";
    private static final String DA_GEN_DIR = "da_gen_dir";
    private static final String ANY_TXT_FILE_PATTERN = ".*\\.txt";
    private static final long EXECUTION_TIMEOUT = Duration.ofHours(1L).toMillis();
    private final File mDeviceActionMainJar;
    private final String[] mConfigFlags;
    private final IRunUtil mRunUtil;
    private final File mGenDir;

    @VisibleForTesting
    DeviceActionUtil(File deviceActionMainJar, String[] configFlags, IRunUtil runUtil, File genDir) {
        this.mDeviceActionMainJar = deviceActionMainJar;
        this.mConfigFlags = configFlags;
        this.mRunUtil = runUtil;
        this.mGenDir = genDir;
    }

    public static DeviceActionUtil create(File deviceActionMainJar, File bundletoolJar) throws DeviceActionConfigError {
        DeviceActionUtil.checkFile(deviceActionMainJar);
        DeviceActionUtil.checkFile(bundletoolJar);
        File genDir = DeviceActionUtil.createDir(DA_GEN_DIR);
        File tmpDir = DeviceActionUtil.createDir(DA_TMP_DIR);
        String[] flags = DeviceActionUtil.createConfigFlags(bundletoolJar, DeviceActionUtil.getCredential(), genDir, tmpDir, DeviceActionUtil.getAdb(), DeviceActionUtil.getAapt(), SystemUtil.getRunningJavaBinaryPath());
        return new DeviceActionUtil(deviceActionMainJar, flags, (IRunUtil)new RunUtil(), genDir);
    }

    public CommandResult execute(Command command, String deviceId, List<String> actionArgs) {
        return this.execute(command, DeviceActionUtil.createActionFlags(deviceId, actionArgs));
    }

    public void generateLogFile(CommandResult result) throws IOException {
        File logFile = FileUtil.createTempFile((String)HOST_LOG, (String)".txt", (File)this.mGenDir);
        FileUtil.writeToFile((String)result.getStdout(), (File)logFile);
        FileUtil.writeToFile((String)result.getStderr(), (File)logFile, (boolean)true);
    }

    public void saveToLogs(Command cmd, ITestLogger testLogger) throws IOException {
        for (String filePath : FileUtil.findFiles((File)this.mGenDir, (String)ANY_TXT_FILE_PATTERN)) {
            File file = new File(filePath);
            try (FileInputStreamSource inputStreamSource = new FileInputStreamSource(file);){
                String dataName = String.format("da_%s_%s", cmd.name(), file.getName().split("\\.", 2)[0]);
                testLogger.testLog(dataName, LogDataType.TEXT, (InputStreamSource)inputStreamSource);
            }
        }
    }

    private CommandResult execute(Command command, List<String> args) {
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(SystemUtil.getRunningJavaBinaryPath().getAbsolutePath(), "-Djava.util.logging.config.class=com.google.common.logging.GoogleConsoleLogConfig", "-Dgoogle.debug_log_levels=*=INFO", "-jar", this.mDeviceActionMainJar.getAbsolutePath(), command.cmdName));
        cmd.addAll(Arrays.asList(this.mConfigFlags));
        cmd.addAll(args);
        return this.mRunUtil.runTimedCmd(EXECUTION_TIMEOUT, cmd.toArray(new String[0]));
    }

    @VisibleForTesting
    static String[] createConfigFlags(File bundletoolJar, File credential, File genDir, File tmpDir, File adb, File aapt, File java) {
        return new String[]{BUNDLETOOL_FLAG, bundletoolJar.getAbsolutePath(), CREDENTIAL_FLAG, credential.getAbsolutePath(), GEN_DIR_FLAG, genDir.getAbsolutePath(), TMP_DIR_FLAG, tmpDir.getAbsolutePath(), ADB_FLAG, adb.getAbsolutePath(), AAPT_FLAG, aapt.getAbsolutePath(), JAVA_BIN_FLAG, java.getAbsolutePath()};
    }

    private static List<String> createActionFlags(String deviceId, List<String> args) {
        ArrayList<String> flags = new ArrayList<String>(Arrays.asList("--device1", "serial=" + deviceId));
        for (String arg : args) {
            flags.addAll(Arrays.asList("--action", arg));
        }
        return flags;
    }

    private static void checkFile(File file) throws DeviceActionConfigError {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new DeviceActionConfigError("Missing file " + file);
        }
    }

    private static File getAdb() throws DeviceActionConfigError {
        File adbFile = new File(GlobalConfiguration.getDeviceManagerInstance().getAdbPath());
        if (!adbFile.exists()) {
            adbFile = DeviceActionUtil.findExecutableOnPath("adb");
        }
        return adbFile;
    }

    private static File getAapt() throws DeviceActionConfigError {
        return DeviceActionUtil.findExecutableOnPath("aapt2");
    }

    private static File getCredential() throws DeviceActionConfigError {
        File credentialFile = new File(System.getenv(GOOGLE_APPLICATION_CREDENTIALS));
        return Optional.of(credentialFile).filter(File::exists).orElseThrow(() -> new DeviceActionConfigError("Missing GOOGLE_APPLICATION_CREDENTIALS"));
    }

    private static File createDir(String prefix) throws DeviceActionConfigError {
        try {
            return FileUtil.createTempDir((String)prefix);
        }
        catch (IOException e) {
            throw new DeviceActionConfigError("Failed to create " + prefix, e);
        }
    }

    private static File findExecutableOnPath(String name) throws DeviceActionConfigError {
        return Splitter.on(File.pathSeparator).splitToList(System.getenv(PATH)).stream().map(dir -> new File((String)dir, name)).filter(f -> f.isFile() && f.canExecute()).findFirst().orElseThrow(() -> new DeviceActionConfigError("Failed to find the executable " + name));
    }

    public static enum Command {
        INSTALL_MAINLINE("install_mainline"),
        RESET("reset");

        private final String cmdName;

        private Command(String cmdName) {
            this.cmdName = cmdName;
        }
    }

    public static class DeviceActionConfigError
    extends HarnessException {
        private static final long serialVersionUID = 2202987086655357212L;

        public DeviceActionConfigError(String message, @Nullable Throwable cause) {
            super(message, cause, (ErrorIdentifier)InfraErrorIdentifier.INTERNAL_CONFIG_ERROR);
        }

        public DeviceActionConfigError(String message) {
            super(message, (ErrorIdentifier)InfraErrorIdentifier.INTERNAL_CONFIG_ERROR);
        }
    }
}

