/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;

public final class TableSubject
extends Subject {
    private final Table<?, ?, ?> actual;

    TableSubject(FailureMetadata metadata, Table<?, ?, ?> table) {
        super(metadata, table);
        this.actual = table;
    }

    public void isEmpty() {
        if (!Preconditions.checkNotNull(this.actual).isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public void isNotEmpty() {
        if (Preconditions.checkNotNull(this.actual).isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0, "expectedSize(%s) must be >= 0", expectedSize);
        this.check("size()", new Object[0]).that(Preconditions.checkNotNull(this.actual).size()).isEqualTo(expectedSize);
    }

    public void contains(Object rowKey, Object columnKey) {
        if (!Preconditions.checkNotNull(this.actual).contains(rowKey, columnKey)) {
            this.failWithActual(Fact.simpleFact("expected to contain mapping for row-column key pair"), Fact.fact("row key", rowKey), Fact.fact("column key", columnKey));
        }
    }

    public void doesNotContain(Object rowKey, Object columnKey) {
        if (Preconditions.checkNotNull(this.actual).contains(rowKey, columnKey)) {
            this.failWithoutActual(Fact.simpleFact("expected not to contain mapping for row-column key pair"), Fact.fact("row key", rowKey), Fact.fact("column key", columnKey), Fact.fact("but contained value", this.actual.get(rowKey, columnKey)), Fact.fact("full contents", this.actual));
        }
    }

    public void containsCell(Object rowKey, Object colKey, Object value) {
        this.containsCell(Tables.immutableCell(rowKey, colKey, value));
    }

    public void containsCell(Table.Cell<?, ?, ?> cell) {
        Preconditions.checkNotNull(cell);
        this.checkNoNeedToDisplayBothValues("cellSet()", new Object[0]).that(Preconditions.checkNotNull(this.actual).cellSet()).contains(cell);
    }

    public void doesNotContainCell(Object rowKey, Object colKey, Object value) {
        this.doesNotContainCell(Tables.immutableCell(rowKey, colKey, value));
    }

    public void doesNotContainCell(Table.Cell<?, ?, ?> cell) {
        Preconditions.checkNotNull(cell);
        this.checkNoNeedToDisplayBothValues("cellSet()", new Object[0]).that(Preconditions.checkNotNull(this.actual).cellSet()).doesNotContain(cell);
    }

    public void containsRow(Object rowKey) {
        this.check("rowKeySet()", new Object[0]).that(Preconditions.checkNotNull(this.actual).rowKeySet()).contains(rowKey);
    }

    public void containsColumn(Object columnKey) {
        this.check("columnKeySet()", new Object[0]).that(Preconditions.checkNotNull(this.actual).columnKeySet()).contains(columnKey);
    }

    public void containsValue(Object value) {
        this.check("values()", new Object[0]).that(Preconditions.checkNotNull(this.actual).values()).contains(value);
    }
}

