/*
 * Decompiled with CFR 0.152.
 */
package com.android.catbox.result;

import com.android.catbox.util.TestMetricsUtil;
import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.util.CollectorUtil;
import com.android.compatibility.common.util.MetricsReportLog;
import com.android.compatibility.common.util.ResultType;
import com.android.compatibility.common.util.ResultUnit;
import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@OptionClass(alias="json-result-reporter")
public class JsonResultReporter
implements ITestInvocationListener {
    private CompatibilityBuildHelper mBuildHelper;
    private IInvocationContext mContext;
    private IInvocationContext mModuleContext;
    private IBuildInfo mBuildInfo;
    private TestMetricsUtil mTestMetricsUtil;
    @Option(name="dest-dir", description="The directory under the result to store the files. Default to 'report-log-files'.")
    private String mDestDir = "report-log-files";
    private String mTempReportFolder = "temp-report-logs";
    @Option(name="report-log-name", description="Name of the JSON report file.")
    private String mReportLogName = null;
    @Option(name="report-test-name-mapping", description="Mapping for test name to use in report.")
    private Map<String, String> mReportTestNameMap = new HashMap<String, String>();
    @Option(name="report-all-metrics", description="Report all the generated metrics. Default to 'true'.")
    private boolean mReportAllMetrics = true;
    @Option(name="report-metric-key-mapping", description="Mapping for Metric Keys to be reported. Only report the keys provided in the mapping.")
    private Map<String, String> mReportMetricKeyMap = new HashMap<String, String>();
    @Option(name="test-iteration-separator", description="Separator used in between the test class name and the iteration number. Default separator is '$'")
    private String mTestIterationSeparator = "$";
    @Option(name="aggregate-similar-tests", description="To aggregate the metrics from test cases which differ only by iteration number or having the same test name. Used only in context with the microbenchmark test runner. Set this flag to false to disable aggregating the metrics.")
    private boolean mAggregateSimilarTests = false;

    private IBuildInfo getPrimaryBuildInfo() {
        if (this.mContext == null) {
            return null;
        }
        return (IBuildInfo)this.mContext.getBuildInfos().get(0);
    }

    CompatibilityBuildHelper createBuildHelper() {
        return new CompatibilityBuildHelper(this.getPrimaryBuildInfo());
    }

    String getAbiInfo() {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Getting ABI Information.");
        if (this.mModuleContext == null) {
            return "";
        }
        List abis = this.mModuleContext.getAttributes().get((Object)"module-abi");
        if (abis == null || abis.isEmpty()) {
            return "";
        }
        if (abis.size() > 1) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)String.format("More than one ABI name specified (using first one): %s", abis.toString()));
        }
        return (String)abis.get(0);
    }

    TestMetricsUtil initializeTestMetricsUtil() {
        return new TestMetricsUtil();
    }

    private void initializeReporterConfig() {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Initializing Test Metrics Result Reporter Config.");
        this.mBuildInfo = this.getPrimaryBuildInfo();
        if (this.mBuildHelper == null) {
            this.mBuildHelper = this.createBuildHelper();
        }
        if (this.mReportLogName == null) {
            this.mReportLogName = this.mContext.getTestTag();
        }
        if (this.mTestMetricsUtil == null) {
            this.mTestMetricsUtil = this.initializeTestMetricsUtil();
        }
        this.mTestMetricsUtil.setIterationSeparator(this.mTestIterationSeparator);
    }

    private void reInitializeTestMetricsUtil() {
        this.mTestMetricsUtil = this.initializeTestMetricsUtil();
        this.mTestMetricsUtil.setIterationSeparator(this.mTestIterationSeparator);
    }

    private void writeTestMetrics(String classMethodName, Map<String, String> metrics) {
        String streamName = classMethodName;
        if (this.mReportTestNameMap != null && this.mReportTestNameMap.containsKey(classMethodName)) {
            streamName = this.mReportTestNameMap.get(classMethodName);
        }
        String abiName = this.getAbiInfo();
        MetricsReportLog reportLog = new MetricsReportLog(this.mBuildInfo, abiName, classMethodName, this.mReportLogName, streamName);
        if (this.mReportAllMetrics) {
            this.writeAllMetrics(reportLog, metrics);
        } else {
            this.writeMetricsForGivenKeys(reportLog, metrics);
        }
        reportLog.submit();
    }

    private void writeAllMetrics(MetricsReportLog reportLog, Map<String, String> metrics) {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Writing all the metrics to JSON report.");
        for (String key : metrics.keySet()) {
            try {
                double value = Double.parseDouble(metrics.get(key));
                reportLog.addValue(key, value, ResultType.NEUTRAL, ResultUnit.NONE);
            }
            catch (NumberFormatException exception) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to parse value '%s' for '%s' metric key.", metrics.get(key), key));
            }
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Successfully completed writing the metrics to JSON report.");
    }

    private void writeMetricsForGivenKeys(MetricsReportLog reportLog, Map<String, String> metrics) {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Writing given set of metrics to JSON report.");
        if (this.mReportMetricKeyMap == null || this.mReportMetricKeyMap.isEmpty()) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)"Skip reporting metrics. Metric keys are not provided.");
            return;
        }
        for (String key : this.mReportMetricKeyMap.keySet()) {
            if (!metrics.containsKey(key) || metrics.get(key) == null) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)String.format("%s metric key is missing.", key));
                continue;
            }
            try {
                double value = Double.parseDouble(metrics.get(key));
                reportLog.addValue(this.mReportMetricKeyMap.get(key), value, ResultType.NEUTRAL, ResultUnit.NONE);
            }
            catch (NumberFormatException exception) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to parse value '%s' for '%s' metric key.", metrics.get(key), key));
            }
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Successfully completed writing the metrics to JSON report.");
    }

    private void copyGeneratedReportToResultsDirectory() {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Copying the report log to results directory.");
        try {
            File resultDir = this.mBuildHelper.getResultDir();
            if (this.mDestDir != null) {
                resultDir = new File(resultDir, this.mDestDir);
            }
            if (!resultDir.exists()) {
                resultDir.mkdirs();
            }
            if (!resultDir.isDirectory()) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("%s is not a directory", resultDir.getAbsolutePath()));
                return;
            }
            File hostReportDir = FileUtil.createNamedTempDir((String)this.mTempReportFolder);
            if (!hostReportDir.isDirectory()) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("%s is not a directory", hostReportDir.getAbsolutePath()));
                return;
            }
            CollectorUtil.pullFromHost((File)hostReportDir, (File)resultDir);
            CollectorUtil.reformatRepeatedStreams((File)resultDir);
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Copying the report log completed successfully.");
        }
        catch (IOException exception) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)exception.getMessage());
        }
    }

    public void invocationStarted(IInvocationContext context) {
        this.mContext = context;
        this.initializeReporterConfig();
    }

    public void invocationEnded(long elapsedTime) {
        this.copyGeneratedReportToResultsDirectory();
    }

    public void testEnded(TestDescription testDescription, HashMap<String, MetricMeasurement.Metric> metrics) {
        if (metrics != null && !metrics.isEmpty() && this.mAggregateSimilarTests) {
            this.mTestMetricsUtil.storeTestMetrics(testDescription, metrics);
        }
    }

    public final void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        if (this.mAggregateSimilarTests) {
            Map<String, Map<String, String>> aggregatedMetrics = this.mTestMetricsUtil.getAggregatedStoredTestMetrics();
            for (String testName : aggregatedMetrics.keySet()) {
                this.writeTestMetrics(testName, aggregatedMetrics.get(testName));
            }
        }
        this.reInitializeTestMetricsUtil();
    }

    public void testModuleStarted(IInvocationContext moduleContext) {
        this.mModuleContext = moduleContext;
    }

    public void testModuleEnded() {
        this.mModuleContext = null;
    }
}

