/*
 * Decompiled with CFR 0.152.
 */
package android.host.test.composer;

import android.host.test.composer.IterateBase;
import java.util.Map;

public class Iterate<U>
extends IterateBase<Map<String, String>, U> {
    @Override
    protected int getIterationsArgument(Map<String, String> args) {
        if (args.containsKey(this.getOptionName())) {
            String iterations = args.get(this.getOptionName());
            try {
                return Integer.parseInt(iterations);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(String.format("Failed to parse iterations option: %s", iterations), e);
            }
        }
        return 1;
    }

    @Override
    protected IterateBase.OrderOptions getOrdersArgument(Map<String, String> args) {
        IterateBase.OrderOptions order = ORDER_DEFAULT_VALUE;
        if (args.containsKey("order")) {
            String orderStr = args.get("order");
            try {
                order = IterateBase.OrderOptions.valueOf(orderStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("The supplied order option \"%s\" is not supported.", orderStr), e);
            }
        }
        return order;
    }
}

