/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.FilePullerDeviceMetricCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.SimpleStats;
import com.android.tradefed.util.ZipUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@OptionClass(alias="atrace-metric")
public class AtraceRunMetricCollector
extends FilePullerDeviceMetricCollector {
    private static final String TRACE_SUMMARY = "Trace Summary:";
    private static final String LINE_SEPARATOR = "\\n";
    private static final String METRIC_SEPARATOR = ":";
    @Option(name="script-path", description="Path to the script files used to analyze the trace files.")
    private List<String> mScriptPaths = new ArrayList<String>();
    private ITestInvocationListener mListener = null;

    public void onTestEnd(DeviceMetricData testData, Map<String, MetricMeasurement.Metric> currentTestCaseMetrics) {
    }

    public void processMetricDirectory(String key, File metricDirectory, DeviceMetricData runData) {
        File[] testDirectories;
        this.mListener = this.getInvocationListener();
        if (metricDirectory == null) {
            LogUtil.CLog.w((String)"Metric directory is null.");
            return;
        }
        for (File testDirectory : testDirectories = metricDirectory.listFiles()) {
            this.uploadTraceFiles(testDirectory);
            if (this.mScriptPaths.isEmpty()) continue;
            for (String scriptPath : this.mScriptPaths) {
                if (this.processTraceFiles(testDirectory, scriptPath)) continue;
                LogUtil.CLog.e((String)("Unable to process the trace files in %s" + testDirectory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadTraceFiles(File testDirectory) {
        File atraceZip = null;
        try {
            atraceZip = ZipUtil.createZip((File)testDirectory);
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Unable to create trace zip file");
        }
        if (atraceZip != null) {
            try (FileInputStreamSource streamSource = new FileInputStreamSource(atraceZip);){
                this.mListener.testLog(String.format("atrace_%s", testDirectory.getName()), LogDataType.ZIP, (InputStreamSource)streamSource);
            }
            finally {
                FileUtil.deleteFile((File)atraceZip);
            }
        }
    }

    private boolean processTraceFiles(File testDirectory, String scriptPath) {
        File[] traceFiles = testDirectory.listFiles();
        ArrayList<String> output = new ArrayList<String>();
        for (File traceFile : traceFiles) {
            CommandResult cr = RunUtil.getDefault().runTimedCmd(30000L, new String[]{scriptPath, traceFile.getAbsolutePath()});
            if (!CommandStatus.SUCCESS.equals((Object)cr.getStatus())) {
                LogUtil.CLog.e((String)"Unable to parse the trace file %s due to %s - Status - %s ", (Object[])new Object[]{traceFile.getName(), cr.getStderr(), cr.getStatus()});
                return false;
            }
            LogUtil.CLog.i((String)cr.getStdout());
            output.add(cr.getStdout());
        }
        Map<String, String> finalResult = this.aggregateMetrics(output);
        String[] scriptArgs = scriptPath.split(" ");
        String[] scriptPathArgs = scriptArgs[0].split("/");
        String[] scriptName = scriptPathArgs[scriptPathArgs.length - 1].split("\\.");
        TestDescription testId = new TestDescription(scriptName[0], testDirectory.getName());
        this.mListener.testStarted(testId);
        this.mListener.testEnded(testId, TfMetricProtoUtil.upgradeConvert(finalResult));
        return true;
    }

    private Map<String, String> aggregateMetrics(List<String> cmdOutput) {
        LinkedHashMap<String, String> finalResultMap = new LinkedHashMap<String, String>();
        HashMap<String, SimpleStats> resultAggregatorMap = new HashMap<String, SimpleStats>();
        for (String string : cmdOutput) {
            String[] outputLines = string.split(LINE_SEPARATOR);
            boolean isTraceSummary = false;
            for (String line : outputLines) {
                if (line.contains(TRACE_SUMMARY)) {
                    isTraceSummary = true;
                    continue;
                }
                if (!isTraceSummary) continue;
                String[] metric = line.split(METRIC_SEPARATOR);
                if (!resultAggregatorMap.containsKey(metric[0].trim())) {
                    SimpleStats resultStats = new SimpleStats();
                    resultStats.add(Double.parseDouble(metric[1].trim()));
                    resultAggregatorMap.put(metric[0].trim(), resultStats);
                    continue;
                }
                ((SimpleStats)resultAggregatorMap.get(metric[0].trim())).add(Double.parseDouble(metric[1].trim()));
            }
        }
        for (Map.Entry entry : resultAggregatorMap.entrySet()) {
            finalResultMap.put((String)entry.getKey() + "_sum", Double.toString(((SimpleStats)entry.getValue()).mean() * (double)((SimpleStats)entry.getValue()).size()));
            finalResultMap.put((String)entry.getKey() + "_avg", Double.toString(((SimpleStats)entry.getValue()).mean()));
            finalResultMap.put((String)entry.getKey() + "_max", Double.toString(((SimpleStats)entry.getValue()).max()));
            finalResultMap.put((String)entry.getKey() + "_min", Double.toString(((SimpleStats)entry.getValue()).min()));
        }
        return finalResultMap;
    }

    public void processMetricFile(String key, File metricFile, DeviceMetricData runData) {
    }
}

