/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.postprocessor;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.internal.protobuf.Descriptors;
import com.android.tradefed.internal.protobuf.Message;
import com.android.tradefed.internal.protobuf.TextFormat;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.postprocessor.BasePostProcessor;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ZipUtil;
import com.android.tradefed.util.ZipUtil2;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipFile;
import perfetto.internal.protos.PerfettoMergedMetrics;

@OptionClass(alias="perfetto-generic-processor")
public class PerfettoGenericPostProcessor
extends BasePostProcessor {
    private static final String METRIC_SEP = "-";
    @VisibleForTesting
    static final String RUNTIME_METRIC_KEY = "perfetto_post_processor_runtime";
    @Option(name="perfetto-proto-file-prefix", description="Prefix for identifying a perfetto metric file name.")
    private Set<String> mPerfettoProtoMetricFilePrefix = new HashSet<String>();
    @Option(name="perfetto-indexed-list-field", description="List fields in perfetto proto metric file that has to be indexed.")
    private Set<String> mPerfettoIndexedListFields = new HashSet<String>();
    @Option(name="perfetto-prefix-key-field", description="String value field need to be prefixed with the all the othernumeric value field keys in the proto message.")
    private Set<String> mPerfettoPrefixKeyFields = new HashSet<String>();
    @Option(name="perfetto-prefix-inner-message-key-field", description="String value field need to be prefixed with the all the othernumeric value field keys outside of the current proto message.")
    private Set<String> mPerfettoPrefixInnerMessagePrefixFields = new HashSet<String>();
    @Option(name="perfetto-include-all-metrics", description="If this flag is turned on, all the metrics parsed from the perfetto file will be included in the final result map and ignores the regex passed in the filters.")
    private boolean mPerfettoIncludeAllMetrics = false;
    @Option(name="perfetto-metric-filter-regex", description="Regular expression that will be used for filtering the metrics parsed from the perfetto proto metric file.")
    private Set<String> mPerfettoMetricFilterRegEx = new HashSet<String>();
    @Option(name="trace-processor-output-format", description="Trace processor output format. One of [binary|text|json]")
    private METRIC_FILE_FORMAT mTraceProcessorOutputFormat = METRIC_FILE_FORMAT.text;
    @Option(name="decompress-perfetto-timeout", description="Timeout to decompress perfetto compressed file.", isTimeVal=true)
    private long mDecompressTimeoutMs = TimeUnit.MINUTES.toMillis(20L);
    @Deprecated
    @Option(name="processed-metric", description="True if the metric is final and shouldn't be processed any more, false if the metric can be handled by another post-processor.")
    private boolean mProcessedMetric = true;
    @Option(name="perfetto-metric-replace-prefix", description="Replace the prefix in metricsfrom the metric proto file. Key is the prefix to look for in the metrickeys parsed and value is be the replacement string.")
    private Map<String, String> mReplacePrefixMap = new LinkedHashMap<String, String>();
    @Option(name="perfetto-all-metric-prefix", description="Prefix to be used with the metrics collected from perfetto.This will be applied before any other prefixes to metrics.")
    private String mAllMetricPrefix = "perfetto";
    @Option(name="perfetto-alternative-parse-format", description="Parse the metrics as key/value pair or JSON when corresponding proto definition is not found. One of [json|none]")
    private AlternativeParseFormat mAlternativeParseFormat = AlternativeParseFormat.none;
    private Pattern mNumberWithExponentPattern = Pattern.compile("[-+]?[0-9]*[\\.]?[0-9]+([eE][-+]?[0-9]+)?");
    private Pattern mNumberPattern = Pattern.compile("[-+]?[0-9]*[\\.]?[0-9]+");
    private List<Pattern> mMetricPatterns = new ArrayList<Pattern>();
    private String mPrefixFromInnerMessage = "";

    public Map<String, MetricMeasurement.Metric.Builder> processTestMetricsAndLogs(TestDescription testDescription, HashMap<String, MetricMeasurement.Metric> testMetrics, Map<String, LogFile> testLogs) {
        this.buildMetricFilterPatterns();
        return this.processPerfettoMetrics(this.filterPerfeticMetricFiles(testLogs));
    }

    public Map<String, MetricMeasurement.Metric.Builder> processRunMetricsAndLogs(HashMap<String, MetricMeasurement.Metric> rawMetrics, Map<String, LogFile> runLogs) {
        this.buildMetricFilterPatterns();
        return this.processPerfettoMetrics(this.filterPerfeticMetricFiles(runLogs));
    }

    private List<File> filterPerfeticMetricFiles(Map<String, LogFile> logs) {
        ArrayList<File> perfettoMetricFiles = new ArrayList<File>();
        for (String key : logs.keySet()) {
            Optional<String> reportPrefix = this.mPerfettoProtoMetricFilePrefix.stream().filter(prefix -> key.startsWith((String)prefix)).findAny();
            if (!reportPrefix.isPresent()) continue;
            perfettoMetricFiles.add(new File(logs.get(key).getPath()));
        }
        return perfettoMetricFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Map<String, MetricMeasurement.Metric.Builder> processPerfettoMetrics(List<File> perfettoMetricFiles) {
        parsedMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        startTime = System.currentTimeMillis();
        uncompressedDir = null;
        for (File perfettoMetricFile : perfettoMetricFiles) {
            try {
                if (this.mTraceProcessorOutputFormat != METRIC_FILE_FORMAT.binary && ZipUtil.isZipFileValid((File)perfettoMetricFile, (boolean)true)) {
                    perfettoZippedFile = new ZipFile(perfettoMetricFile);
                    uncompressedDir = FileUtil.createTempDir((String)"uncompressed_perfetto_metric");
                    ZipUtil2.extractZip((ZipFile)perfettoZippedFile, (File)uncompressedDir);
                    perfettoMetricFile = uncompressedDir.listFiles()[0];
                    perfettoZippedFile.close();
                }
            }
            catch (IOException e) {
                LogUtil.CLog.e((String)("IOException happened when unzipping the perfetto metric proto file." + e.getMessage()));
            }
            try {
                bufferedReader = new BufferedReader(new FileReader(perfettoMetricFile));
                try {
                    switch (1.$SwitchMap$com$android$tradefed$postprocessor$PerfettoGenericPostProcessor$METRIC_FILE_FORMAT[this.mTraceProcessorOutputFormat.ordinal()]) {
                        case 1: {
                            builder = PerfettoMergedMetrics.TraceMetrics.newBuilder();
                            TextFormat.merge(bufferedReader, (Message.Builder)builder);
                            parsedMetrics.putAll(this.handlePrefixForProcessedMetrics(this.convertPerfettoProtoMessage(builder.build())));
                            ** break;
lbl24:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            metricProto = null;
                            metricProto = PerfettoMergedMetrics.TraceMetrics.parseFrom(new FileInputStream(perfettoMetricFile));
                            parsedMetrics.putAll(this.handlePrefixForProcessedMetrics(this.convertPerfettoProtoMessage(metricProto)));
                            ** break;
lbl30:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            LogUtil.CLog.w((String)"JSON perfetto metric file processing not supported.");
                            break;
                        }
                        ** default:
lbl35:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (TextFormat.ParseException e) {
                block23: {
                    if (AlternativeParseFormat.none == this.mAlternativeParseFormat) {
                        LogUtil.CLog.e((String)("Failed to merge the perfetto metric file. " + e.getMessage()));
                        break block23;
                    }
                    LogUtil.CLog.w((String)"Failed to merge the perfetto metric file, trying alternative");
                    parsedMetrics.putAll(this.handlePrefixForProcessedMetrics(this.processPerfettoMetricsWithAlternativeMethods(perfettoMetricFile)));
                }
                FileUtil.recursiveDelete((File)uncompressedDir);
                continue;
            }
            catch (IOException ioe) {
                LogUtil.CLog.e((String)("IOException happened when reading the perfetto metric file. " + ioe.getMessage()));
                {
                    catch (Throwable var11_15) {
                        FileUtil.recursiveDelete(uncompressedDir);
                        throw var11_15;
                    }
                }
                FileUtil.recursiveDelete((File)uncompressedDir);
                continue;
            }
            FileUtil.recursiveDelete((File)uncompressedDir);
        }
        if (parsedMetrics.size() > 0) {
            parsedMetrics.put("perfetto_post_processor_runtime", TfMetricProtoUtil.stringToMetric((String)Long.toString(System.currentTimeMillis() - startTime)).toBuilder());
        }
        return parsedMetrics;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, MetricMeasurement.Metric.Builder> processPerfettoMetricsWithAlternativeMethods(File perfettoMetricFile) {
        LogUtil.CLog.w((String)"Entering processPerfettoMetricsWithAlternativeMethods");
        HashMap<String, MetricMeasurement.Metric.Builder> result = new HashMap<String, MetricMeasurement.Metric.Builder>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(perfettoMetricFile));){
            if (AlternativeParseFormat.json != this.mAlternativeParseFormat) return result;
            JsonObject node = (JsonObject)new Gson().fromJson((Reader)bufferedReader, JsonObject.class);
            node.entrySet().forEach(nested -> this.flattenJson((Map<String, MetricMeasurement.Metric.Builder>)result, (Map.Entry<String, JsonElement>)nested, (List<String>)new ArrayList<String>()));
            HashMap<String, MetricMeasurement.Metric.Builder> hashMap = result;
            return hashMap;
        }
        catch (JsonSyntaxException jse) {
            LogUtil.CLog.e((String)("JsonSyntaxException happened when parsing perfetto metric file. " + jse.getMessage()));
            return result;
        }
        catch (IOException ioe) {
            LogUtil.CLog.e((String)("IOException happened when reading the perfetto metric file. " + ioe.getMessage()));
        }
        return result;
    }

    private Map<String, MetricMeasurement.Metric.Builder> flattenJson(Map<String, MetricMeasurement.Metric.Builder> result, Map.Entry<String, JsonElement> node, List<String> names) {
        names.add(node.getKey());
        if (node.getValue().isJsonObject()) {
            node.getValue().getAsJsonObject().entrySet().forEach(nested -> this.flattenJson(result, (Map.Entry<String, JsonElement>)nested, (List<String>)new ArrayList<String>(names)));
        } else {
            String name = names.stream().collect(Collectors.joining(METRIC_SEP));
            result.put(name, TfMetricProtoUtil.stringToMetric((String)node.getValue().getAsString()).toBuilder());
        }
        return result;
    }

    private Map<String, MetricMeasurement.Metric.Builder> handlePrefixForProcessedMetrics(Map<String, MetricMeasurement.Metric.Builder> processedMetrics) {
        HashMap<String, MetricMeasurement.Metric.Builder> result = new HashMap<String, MetricMeasurement.Metric.Builder>();
        result.putAll(this.filterMetrics(processedMetrics));
        this.replacePrefix(result);
        this.replaceAllMetricPrefix(result);
        return result;
    }

    private void replacePrefix(Map<String, MetricMeasurement.Metric.Builder> processPerfettoMetrics) {
        if (this.mReplacePrefixMap.isEmpty()) {
            return;
        }
        HashMap<String, MetricMeasurement.Metric.Builder> finalMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (Map.Entry<String, MetricMeasurement.Metric.Builder> metric : processPerfettoMetrics.entrySet()) {
            boolean isReplaced = false;
            for (Map.Entry<String, String> replaceEntry : this.mReplacePrefixMap.entrySet()) {
                if (!metric.getKey().startsWith(replaceEntry.getKey())) continue;
                String newKey = metric.getKey().replaceFirst(replaceEntry.getKey(), replaceEntry.getValue());
                finalMetrics.put(newKey, metric.getValue());
                isReplaced = true;
                break;
            }
            if (isReplaced) continue;
            finalMetrics.put(metric.getKey(), metric.getValue());
        }
        processPerfettoMetrics.clear();
        processPerfettoMetrics.putAll(finalMetrics);
    }

    private void replaceAllMetricPrefix(Map<String, MetricMeasurement.Metric.Builder> processPerfettoMetrics) {
        if (this.mAllMetricPrefix == null || this.mAllMetricPrefix.isEmpty()) {
            return;
        }
        HashMap<String, MetricMeasurement.Metric.Builder> finalMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (Map.Entry<String, MetricMeasurement.Metric.Builder> metric : processPerfettoMetrics.entrySet()) {
            String newKey = String.format("%s_%s", this.mAllMetricPrefix, metric.getKey());
            finalMetrics.put(newKey, metric.getValue());
            LogUtil.CLog.d((String)"Perfetto trace metric: key: %s value: %s", (Object[])new Object[]{newKey, metric.getValue()});
        }
        processPerfettoMetrics.clear();
        processPerfettoMetrics.putAll(finalMetrics);
    }

    private Map<String, MetricMeasurement.Metric.Builder> convertPerfettoProtoMessage(Message reportMessage) {
        Map<Descriptors.FieldDescriptor, Object> fields = reportMessage.getAllFields();
        HashMap<String, MetricMeasurement.Metric.Builder> convertedMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        ArrayList<String> keyPrefixes = new ArrayList<String>();
        String keyPrefixOtherFields = "";
        boolean prefixSetInCurrentMessage = false;
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fields.entrySet()) {
            if (entry.getValue() instanceof Message || entry.getValue() instanceof List) continue;
            if (this.isNumeric(entry.getValue().toString())) {
                if (this.mPerfettoPrefixKeyFields.contains(((Descriptors.FieldDescriptor)entry.getKey()).toString())) {
                    if (!keyPrefixOtherFields.isEmpty()) {
                        keyPrefixOtherFields = keyPrefixOtherFields.concat(METRIC_SEP);
                    }
                    keyPrefixOtherFields = keyPrefixOtherFields.concat(String.format("%s-%s", ((Descriptors.FieldDescriptor)entry.getKey()).getName().toString(), entry.getValue().toString()));
                    continue;
                }
                if (this.mPerfettoPrefixInnerMessagePrefixFields.contains(((Descriptors.FieldDescriptor)entry.getKey()).toString())) {
                    if (!this.mPrefixFromInnerMessage.isEmpty()) {
                        this.mPrefixFromInnerMessage = this.mPrefixFromInnerMessage.concat(METRIC_SEP);
                    }
                    this.mPrefixFromInnerMessage = this.mPrefixFromInnerMessage.concat(String.format("%s-%s", ((Descriptors.FieldDescriptor)entry.getKey()).getName().toString(), entry.getValue().toString()));
                    prefixSetInCurrentMessage = true;
                    continue;
                }
                if (this.mNumberPattern.matcher(entry.getValue().toString()).matches()) {
                    convertedMetrics.put(((Descriptors.FieldDescriptor)entry.getKey()).getName(), TfMetricProtoUtil.stringToMetric((String)entry.getValue().toString()).toBuilder());
                    continue;
                }
                convertedMetrics.put(((Descriptors.FieldDescriptor)entry.getKey()).getName(), TfMetricProtoUtil.stringToMetric((String)Long.toString(Double.valueOf(entry.getValue().toString()).longValue())).toBuilder());
                continue;
            }
            keyPrefixes.add(String.join((CharSequence)METRIC_SEP, ((Descriptors.FieldDescriptor)entry.getKey()).getName().toString(), entry.getValue().toString()));
            if (this.mPerfettoPrefixKeyFields.contains(((Descriptors.FieldDescriptor)entry.getKey()).toString())) {
                if (!keyPrefixOtherFields.isEmpty()) {
                    keyPrefixOtherFields = keyPrefixOtherFields.concat(METRIC_SEP);
                }
                keyPrefixOtherFields = keyPrefixOtherFields.concat(String.format("%s-%s", ((Descriptors.FieldDescriptor)entry.getKey()).getName().toString(), entry.getValue().toString()));
            }
            if (!this.mPerfettoPrefixInnerMessagePrefixFields.contains(((Descriptors.FieldDescriptor)entry.getKey()).toString())) continue;
            if (!this.mPrefixFromInnerMessage.isEmpty()) {
                this.mPrefixFromInnerMessage = this.mPrefixFromInnerMessage.concat(METRIC_SEP);
            }
            this.mPrefixFromInnerMessage = this.mPrefixFromInnerMessage.concat(String.format("%s-%s", ((Descriptors.FieldDescriptor)entry.getKey()).getName().toString(), entry.getValue().toString()));
            prefixSetInCurrentMessage = true;
        }
        String innerMessagePrefix = "";
        for (Map.Entry entry : fields.entrySet()) {
            if (entry.getValue() instanceof Message) {
                Map<String, MetricMeasurement.Metric.Builder> map = this.convertPerfettoProtoMessage((Message)entry.getValue());
                if (!this.mPrefixFromInnerMessage.isEmpty()) {
                    innerMessagePrefix = this.mPrefixFromInnerMessage;
                }
                for (Map.Entry<String, MetricMeasurement.Metric.Builder> metricEntry : map.entrySet()) {
                    for (String prefix : keyPrefixes) {
                        convertedMetrics.put(String.join((CharSequence)METRIC_SEP, prefix, ((Descriptors.FieldDescriptor)entry.getKey()).getName(), metricEntry.getKey()), metricEntry.getValue());
                    }
                    if (!keyPrefixes.isEmpty()) continue;
                    convertedMetrics.put(String.join((CharSequence)METRIC_SEP, ((Descriptors.FieldDescriptor)entry.getKey()).getName(), metricEntry.getKey()), metricEntry.getValue());
                }
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            List list = (List)entry.getValue();
            for (int i = 0; i < list.size(); ++i) {
                String metricKeyRoot = this.mPerfettoIndexedListFields.contains(((Descriptors.FieldDescriptor)entry.getKey()).toString()) ? String.join((CharSequence)METRIC_SEP, ((Descriptors.FieldDescriptor)entry.getKey()).getName(), String.valueOf(i + 1)) : String.join((CharSequence)METRIC_SEP, ((Descriptors.FieldDescriptor)entry.getKey()).getName());
                if (list.get(i) instanceof Message) {
                    Map<String, MetricMeasurement.Metric.Builder> messageMetrics = this.convertPerfettoProtoMessage((Message)list.get(i));
                    if (!this.mPrefixFromInnerMessage.isEmpty()) {
                        innerMessagePrefix = this.mPrefixFromInnerMessage;
                    }
                    for (Map.Entry<String, MetricMeasurement.Metric.Builder> metricEntry : messageMetrics.entrySet()) {
                        for (String prefix : keyPrefixes) {
                            convertedMetrics.put(String.join((CharSequence)METRIC_SEP, prefix, metricKeyRoot, metricEntry.getKey()), metricEntry.getValue());
                        }
                        if (!keyPrefixes.isEmpty()) continue;
                        convertedMetrics.put(String.join((CharSequence)METRIC_SEP, metricKeyRoot, metricEntry.getKey()), metricEntry.getValue());
                    }
                    continue;
                }
                convertedMetrics.put(metricKeyRoot, TfMetricProtoUtil.stringToMetric((String)list.get(i).toString()).toBuilder());
            }
        }
        HashMap<String, MetricMeasurement.Metric.Builder> additionalConvertedMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        if (!keyPrefixOtherFields.isEmpty()) {
            for (Map.Entry entry : convertedMetrics.entrySet()) {
                additionalConvertedMetrics.put(String.format("%s-%s", keyPrefixOtherFields, entry.getKey()), (MetricMeasurement.Metric.Builder)entry.getValue());
            }
        }
        if (!this.mPrefixFromInnerMessage.isEmpty() || !innerMessagePrefix.isEmpty()) {
            String string = !this.mPrefixFromInnerMessage.isEmpty() ? this.mPrefixFromInnerMessage : innerMessagePrefix;
            for (Map.Entry currentMetric : convertedMetrics.entrySet()) {
                additionalConvertedMetrics.put(String.format("%s-%s", string, currentMetric.getKey()), (MetricMeasurement.Metric.Builder)currentMetric.getValue());
            }
        }
        if (!prefixSetInCurrentMessage) {
            this.mPrefixFromInnerMessage = "";
        }
        convertedMetrics.putAll(additionalConvertedMetrics);
        return convertedMetrics;
    }

    private boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        return this.mNumberWithExponentPattern.matcher(strNum).matches();
    }

    private void buildMetricFilterPatterns() {
        if (!this.mPerfettoMetricFilterRegEx.isEmpty() && this.mMetricPatterns.isEmpty()) {
            for (String regEx : this.mPerfettoMetricFilterRegEx) {
                this.mMetricPatterns.add(Pattern.compile(regEx));
            }
        }
    }

    private Map<String, MetricMeasurement.Metric.Builder> filterMetrics(Map<String, MetricMeasurement.Metric.Builder> parsedMetrics) {
        if (this.mPerfettoIncludeAllMetrics) {
            return parsedMetrics;
        }
        HashMap<String, MetricMeasurement.Metric.Builder> filteredMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        block0: for (Map.Entry<String, MetricMeasurement.Metric.Builder> metricEntry : parsedMetrics.entrySet()) {
            for (Pattern pattern : this.mMetricPatterns) {
                if (!pattern.matcher(metricEntry.getKey()).matches()) continue;
                filteredMetrics.put(metricEntry.getKey(), metricEntry.getValue());
                continue block0;
            }
        }
        return filteredMetrics;
    }

    protected MetricMeasurement.DataType getMetricType() {
        return MetricMeasurement.DataType.RAW;
    }

    public static enum METRIC_FILE_FORMAT {
        text,
        binary,
        json;

    }

    public static enum AlternativeParseFormat {
        json,
        none;

    }
}

