/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.postprocessor;

import com.android.os.AtomsProto;
import com.android.os.StatsLog;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.internal.protobuf.Descriptors;
import com.android.tradefed.internal.protobuf.Message;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.postprocessor.StatsdGenericPostProcessor;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.ProtoUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@OptionClass(alias="statsd-before-after-gauge-metric-processor")
public class StatsdBeforeAfterGaugeMetricPostProcessor
extends StatsdGenericPostProcessor {
    @Option(name="metric-formatter", description="A formatter to format a statsd atom into a key-value pair for a metric. Format: Atom name (snake case) as key and a 'metric_key=value' formatter as value. For the formatter, enclose atom field references in square brackets, which will be substituted with field values in the atom. Example: key: on_device_power_measurement, value: [subsystem_name]-[rail_name]=[energy_microwatt_secs].References to repeated fields should be avoided unless the user is confident that it will always contain only one value in practice. Field definitions can be found in the atoms.proto file under frameworks/proto_logging/stats in the source tree. The metric key can be empty if only one metric is coming out of a particular atom and the atom name is descriptive enough.")
    private MultiMap<String, String> mMetricFormatters = new MultiMap();
    @Option(name="also-report-before-after", description="Also report the before and after values for each metric. These will be prefixed with '[statsd report prefix]-gauge-[atom name]-before' and '[statsd report prefix]-gauge-[atom name]-after'.")
    private boolean mAlsoReportBeforeAfter = true;
    private static final Pattern FIELD_REF_PATTERN = Pattern.compile("\\[(?:[a-zA-Z_]+\\.)*(?:[a-zA-Z_]+)\\]");

    @Override
    protected Map<String, MetricMeasurement.Metric.Builder> parseMetricsFromReportList(StatsLog.ConfigMetricsReportList reportList) {
        Sets.SetView<String> atomsInAfterOnly;
        HashMap<String, MultiMap<String, String>> beforeMetrics = new HashMap<String, MultiMap<String, String>>();
        HashMap<String, MultiMap<String, String>> afterMetrics = new HashMap<String, MultiMap<String, String>>();
        HashMap<String, Map<String, Set<String>>> beforekeyToFormatterOutput = new HashMap<String, Map<String, Set<String>>>();
        HashMap<String, Map<String, Set<String>>> afterkeyToFormatterOutput = new HashMap<String, Map<String, Set<String>>>();
        for (StatsLog.ConfigMetricsReport report : reportList.getReportsList()) {
            for (StatsLog.StatsLogReport statsLogReport : report.getMetricsList()) {
                if (!statsLogReport.hasGaugeMetrics()) continue;
                List<StatsLog.GaugeMetricData> dataItems = statsLogReport.getGaugeMetrics().getDataList();
                for (StatsLog.GaugeMetricData data : dataItems) {
                    if (data.getBucketInfoList().size() != 2) {
                        this.logWarning("GaugeMetricData %s does not have two buckets and therefore does not contain both before and after snapshots. Skipping.", data);
                        continue;
                    }
                    this.parseMetricsByFormatters(data.getBucketInfo(0), beforeMetrics, beforekeyToFormatterOutput);
                    this.parseMetricsByFormatters(data.getBucketInfo(1), afterMetrics, afterkeyToFormatterOutput);
                }
            }
        }
        Sets.SetView<String> atomsInBeforeOnly = Sets.difference(beforeMetrics.keySet(), afterMetrics.keySet());
        if (atomsInBeforeOnly.size() > 0) {
            this.logWarning("The following atom(s) have a \"before\" snapshot but not an \"after\" snapshot: %s. Metrics:\n%s.", atomsInBeforeOnly, this.formatMetricsForLoggingByAtoms(beforeMetrics, atomsInBeforeOnly));
        }
        if ((atomsInAfterOnly = Sets.difference(afterMetrics.keySet(), beforeMetrics.keySet())).size() > 0) {
            this.logWarning("The following atom(s) have an \"after\" snapshot but not a \"before\" snapshot: %s. Metrics:\n%s", atomsInAfterOnly, this.formatMetricsForLoggingByAtoms(afterMetrics, atomsInAfterOnly));
        }
        HashMap<String, MultiMap<String, String>> deltaMetrics = new HashMap<String, MultiMap<String, String>>();
        for (String atomName : Sets.intersection(beforeMetrics.keySet(), afterMetrics.keySet())) {
            Sets.SetView<String> metricsKeysInAfterOnly;
            deltaMetrics.put(atomName, (MultiMap<String, String>)new MultiMap());
            MultiMap atomBeforeMetrics = (MultiMap)beforeMetrics.get(atomName);
            MultiMap atomAfterMetrics = (MultiMap)afterMetrics.get(atomName);
            Sets.SetView<String> metricsKeysInBeforeOnly = Sets.difference(atomBeforeMetrics.keySet(), atomAfterMetrics.keySet());
            if (metricsKeysInBeforeOnly.size() > 0) {
                this.logWarning("For atom %s, the following metric(s) have a \"before\" value but not an \"after\" value:\n%s", atomName, this.formatAtomMetricsForLoggingByMetricKeys((MultiMap<String, String>)atomBeforeMetrics, metricsKeysInBeforeOnly, 1));
            }
            if ((metricsKeysInAfterOnly = Sets.difference(atomAfterMetrics.keySet(), atomBeforeMetrics.keySet())).size() > 0) {
                this.logWarning("For atom %s, the following metric(s) have an \"after\" value but not a \"before\" value:\n%s", atomName, this.formatAtomMetricsForLoggingByMetricKeys((MultiMap<String, String>)atomAfterMetrics, metricsKeysInAfterOnly, 1));
            }
            for (String metricKey : Sets.intersection(atomBeforeMetrics.keySet(), atomAfterMetrics.keySet())) {
                List beforeValues = atomBeforeMetrics.get((Object)metricKey);
                List afterValues = atomAfterMetrics.get((Object)metricKey);
                if (beforeValues.size() > 1) {
                    this.logWarning("Metric %s (from formatter(s) %s) of atom %s has multiple values %s in the \"before\" snapshot, which will result in meaningless delta values. Delta calculation for this metric will be skipped. Please double check your metric formatters if this is unexpected. The value(s) from the \"after\" snapshot are %s.", metricKey, ((Map)beforekeyToFormatterOutput.get(atomName)).get(metricKey), atomName, beforeValues, afterValues);
                    continue;
                }
                if (afterValues.size() > 1) {
                    this.logWarning("Metric %s (from formatter(s) %s) of atom %s has multiple values %s in the \"after\" snapshot, which will result in meaningless delta values. Delta calculation for this metric will be skipped. Please double check your metric formatters if this is unexpected. The value(s) from the \"before\" snapshot are %s.", metricKey, ((Map)afterkeyToFormatterOutput.get(atomName)).get(metricKey), atomName, afterValues, beforeValues);
                    continue;
                }
                try {
                    ((MultiMap)deltaMetrics.get(atomName)).put((Object)metricKey, (Object)String.valueOf(Double.valueOf((String)afterValues.get(0)) - Double.valueOf((String)beforeValues.get(0))));
                }
                catch (NumberFormatException e) {
                    this.logWarning("Metric %s of atom %s (from formatter(s) %s) has non-numeric before and/or after values %s, %s, skipping delta calculation.", metricKey, atomName, ((Map)beforekeyToFormatterOutput.get(atomName)).get(metricKey), beforeValues.get(0), afterValues.get(0));
                }
            }
        }
        HashMap<String, MetricMeasurement.Metric.Builder> hashMap = new HashMap<String, MetricMeasurement.Metric.Builder>();
        hashMap.putAll(this.finalizeMetrics(deltaMetrics, "delta"));
        if (this.mAlsoReportBeforeAfter) {
            hashMap.putAll(this.finalizeMetrics(beforeMetrics, "before"));
            hashMap.putAll(this.finalizeMetrics(afterMetrics, "after"));
        }
        return hashMap;
    }

    private void parseMetricsByFormatters(StatsLog.GaugeBucketInfo bucket, Map<String, MultiMap<String, String>> metricsOutput, Map<String, Map<String, Set<String>>> keyToFormatterOutput) {
        List<AtomsProto.Atom> atoms = bucket.getAtomList();
        if (atoms.isEmpty()) {
            atoms = new ArrayList<AtomsProto.Atom>();
            for (StatsLog.AggregatedAtomInfo info : bucket.getAggregatedAtomInfoList()) {
                atoms.add(info.getAtom());
            }
        }
        for (AtomsProto.Atom atom : atoms) {
            Map<Descriptors.FieldDescriptor, Object> atomFields = atom.getAllFields();
            for (Descriptors.FieldDescriptor fieldDescriptor : atomFields.keySet()) {
                if (!this.mMetricFormatters.containsKey((Object)fieldDescriptor.getName())) continue;
                String atomName = fieldDescriptor.getName();
                metricsOutput.computeIfAbsent(atomName, k -> new MultiMap());
                keyToFormatterOutput.computeIfAbsent(atomName, k -> new HashMap());
                Message atomContent = (Message)atom.getField(fieldDescriptor);
                List formatters = this.mMetricFormatters.get((Object)atomName);
                for (String formatter : formatters) {
                    String keyFormatter = formatter.split("=")[0];
                    String valueFormatter = formatter.split("=")[1];
                    List<String> parsedKeys = this.fillInPlaceholders(keyFormatter, atomContent);
                    List<String> parsedValues = this.fillInPlaceholders(valueFormatter, atomContent);
                    if (parsedKeys.size() > 1 && parsedValues.size() > 1) {
                        this.logWarning("Found repeated fields in both metric key and value in formatting pair %s: %s. This is unsupported as it presents ambiguity in pairing of repeated field values for a metric, and could result in meaningless data. Skipping.", atomName, formatter);
                        continue;
                    }
                    for (String key : parsedKeys) {
                        keyToFormatterOutput.get(atomName).computeIfAbsent(key, k -> new HashSet());
                        keyToFormatterOutput.get(atomName).get(key).add(formatter);
                        for (String value : parsedValues) {
                            metricsOutput.get(atomName).put((Object)key, (Object)value);
                        }
                    }
                }
            }
        }
    }

    private List<String> fillInPlaceholders(String formatter, Message atomContent) {
        Matcher matcher = FIELD_REF_PATTERN.matcher(formatter);
        List<String> results = Arrays.asList(formatter);
        while (matcher.find()) {
            String placeholder = matcher.group();
            String fieldReference = placeholder.substring(1, placeholder.length() - 1);
            List actual = ProtoUtil.getNestedFieldFromMessageAsStrings((Message)atomContent, Arrays.asList(fieldReference.split("\\.")));
            if (results.size() > 1 && actual.size() > 1) {
                this.logWarning("Found multiple repeated fields in formatter %s. This is unsupported as it presents ambiguity in pairing of repeated field values, and could result in meaningless data. Skipping reporting on this formatter.", formatter);
                return new ArrayList<String>();
            }
            List updatedResults = results.stream().flatMap(r -> actual.stream().map(a -> r.replace(placeholder, (CharSequence)a))).collect(Collectors.toList());
            results = updatedResults;
        }
        return results;
    }

    private Map<String, MetricMeasurement.Metric.Builder> finalizeMetrics(Map<String, MultiMap<String, String>> metrics, String type) {
        HashMap<String, MetricMeasurement.Metric.Builder> finalMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (String atomName : metrics.keySet()) {
            for (String metricKey : metrics.get(atomName).keySet()) {
                finalMetrics.put(String.format("gauge-%s-%s%s", atomName, type, metricKey.isEmpty() ? "" : "-" + metricKey), TfMetricProtoUtil.stringToMetric((String)String.join((CharSequence)",", metrics.get(atomName).get((Object)metricKey))).toBuilder());
            }
        }
        return finalMetrics;
    }

    private String formatAtomMetricsForLoggingByMetricKeys(MultiMap<String, String> metricsForAtom, Collection<String> keys, int indent) {
        return keys.stream().map(k -> String.join((CharSequence)"", Collections.nCopies(indent, "\t")) + (k.isEmpty() ? "<empty>" : k) + ": " + String.join((CharSequence)",", metricsForAtom.get(k))).collect(Collectors.joining("\n"));
    }

    private String formatMetricsForLoggingByAtoms(Map<String, MultiMap<String, String>> metricsByAtom, Collection<String> atomNames) {
        return atomNames.stream().map(a -> "\t" + a + ":\n" + this.formatAtomMetricsForLoggingByMetricKeys((MultiMap<String, String>)((MultiMap)metricsByAtom.get(a)), ((MultiMap)metricsByAtom.get(a)).keySet(), 2)).collect(Collectors.joining(","));
    }

    private void logWarning(String formatter, Object ... args) {
        String formatted = String.format(formatter, args);
        this.logFormattedWarning(formatted);
    }

    @VisibleForTesting
    protected void logFormattedWarning(String message) {
        LogUtil.CLog.w((String)message);
    }
}

