/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.helper.aoa.AoaDevice;
import com.android.helper.aoa.AoaKey;
import com.android.helper.aoa.UsbHelper;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.RegexTrie;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Point;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@OptionClass(alias="aoa-preparer")
public class AoaTargetPreparer
extends BaseTargetPreparer {
    private static final String POINT = "(\\d{1,3}) (\\d{1,3})";
    private static final Pattern KEY = Pattern.compile("\\s+(?:(\\d+)\\*)?([a-zA-Z0-9@\\-_+.]+)");
    private static final RegexTrie<Action> ACTIONS = new RegexTrie();
    @Option(name="device-timeout", description="Maximum time to wait for device")
    private Duration mDeviceTimeout = Duration.ofMinutes(1L);
    @Option(name="wait-for-device-online", description="Checks whether the device is online after preparation.")
    private boolean mWaitForDeviceOnline = true;
    @Option(name="action", description="AOAv2 action to perform. Can be repeated.")
    private List<String> mActions = new ArrayList<String>();
    private static final Map<String, AoaKey> KEYS;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mActions.isEmpty()) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        try {
            this.configure(device.getSerialNumber());
        }
        catch (RuntimeException e) {
            throw new TargetSetupError(e.getMessage(), (Throwable)e, device.getDeviceDescriptor());
        }
        if (this.mWaitForDeviceOnline) {
            LogUtil.CLog.i((String)"Checking that %s is online after preparation", (Object[])new Object[]{device.getSerialNumber()});
            device.waitForDeviceOnline();
        }
    }

    private void configure(String serialNumber) throws DeviceNotAvailableException {
        try (UsbHelper usb = this.getUsbHelper();
             AoaDevice device = usb.getAoaDevice(serialNumber, this.mDeviceTimeout);){
            if (device == null) {
                throw new DeviceNotAvailableException("AOAv2-compatible device not found", serialNumber);
            }
            LogUtil.CLog.i((String)"Executing %d actions on %s", (Object[])new Object[]{this.mActions.size(), serialNumber});
            this.mActions.forEach(action -> this.execute(device, (String)action));
        }
    }

    @VisibleForTesting
    UsbHelper getUsbHelper() {
        return new UsbHelper();
    }

    @VisibleForTesting
    void execute(AoaDevice device, String input) {
        LogUtil.CLog.d((String)"Executing '%s' on %s", (Object[])new Object[]{input, device.getSerialNumber()});
        ArrayList args = new ArrayList();
        Action action = (Action)ACTIONS.retrieve(args, new String[]{input});
        if (action == null) {
            throw new IllegalArgumentException(String.format("Invalid action %s", input));
        }
        action.accept(device, (List)args.get(0));
    }

    private static Point parsePoint(String x, String y) {
        return new Point(Integer.decode(x), Integer.decode(y));
    }

    private static Duration parseMillis(String millis) {
        return Duration.ofMillis(Long.parseLong(millis));
    }

    private static AoaKey parseKey(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (value.matches("\\s+")) {
            return new AoaKey(44, new AoaKey.Modifier[0]);
        }
        AoaKey key = KEYS.get(value);
        if (key == null) {
            key = KEYS.get(value.toLowerCase());
        }
        return key != null ? key : new AoaKey(Integer.decode(value).intValue(), new AoaKey.Modifier[0]);
    }

    static {
        ACTIONS.put((device, args) -> device.click(AoaTargetPreparer.parsePoint((String)args.get(0), (String)args.get(1))), new String[]{String.format("click %s", POINT)});
        ACTIONS.put((device, args) -> device.longClick(AoaTargetPreparer.parsePoint((String)args.get(0), (String)args.get(1))), new String[]{String.format("longClick %s", POINT)});
        ACTIONS.put((device, args) -> {
            Point from = AoaTargetPreparer.parsePoint((String)args.get(0), (String)args.get(1));
            Duration duration = AoaTargetPreparer.parseMillis((String)args.get(2));
            Point to = AoaTargetPreparer.parsePoint((String)args.get(3), (String)args.get(4));
            device.swipe(from, to, duration);
        }, new String[]{String.format("swipe %s (\\d+) %s", POINT, POINT)});
        ACTIONS.put((device, args) -> {
            List keys = Stream.of(((String)args.get(0)).split("")).map(AoaTargetPreparer::parseKey).collect(Collectors.toList());
            device.pressKeys(keys);
        }, new String[]{"write ([a-zA-Z0-9@\\-_+.\\s]+)"});
        ACTIONS.put((device, args) -> {
            ArrayList<AoaKey> keys = new ArrayList<AoaKey>();
            Matcher matcher = KEY.matcher((CharSequence)args.get(0));
            while (matcher.find()) {
                int count = matcher.group(1) == null ? 1 : Integer.decode(matcher.group(1));
                AoaKey key = AoaTargetPreparer.parseKey(matcher.group(2));
                keys.addAll(Collections.nCopies(count, key));
            }
            device.pressKeys(keys);
        }, new String[]{"key((?: (?:\\d+\\*)?[a-zA-Z0-9@\\-_+.]+)+)"});
        ACTIONS.put((device, args) -> device.wakeUp(), new String[]{"wake"});
        ACTIONS.put((device, args) -> device.goHome(), new String[]{"home"});
        ACTIONS.put((device, args) -> device.goBack(), new String[]{"back"});
        ACTIONS.put((device, args) -> {
            Duration duration = AoaTargetPreparer.parseMillis((String)args.get(0));
            device.sleep(duration);
        }, new String[]{"sleep (\\d+)"});
        KEYS = new HashMap<String, AoaKey>();
        int usage = 4;
        for (int letter = 97; letter <= 122; ++letter) {
            String lowerCase = Character.toString((char)letter);
            KEYS.put(lowerCase, new AoaKey(usage, new AoaKey.Modifier[0]));
            KEYS.put(lowerCase.toUpperCase(), new AoaKey(usage, new AoaKey.Modifier[]{AoaKey.Modifier.SHIFT}));
            ++usage;
        }
        KEYS.put("1", new AoaKey(30, new AoaKey.Modifier[0]));
        KEYS.put("2", new AoaKey(31, new AoaKey.Modifier[0]));
        KEYS.put("3", new AoaKey(32, new AoaKey.Modifier[0]));
        KEYS.put("4", new AoaKey(33, new AoaKey.Modifier[0]));
        KEYS.put("5", new AoaKey(34, new AoaKey.Modifier[0]));
        KEYS.put("6", new AoaKey(35, new AoaKey.Modifier[0]));
        KEYS.put("7", new AoaKey(36, new AoaKey.Modifier[0]));
        KEYS.put("8", new AoaKey(37, new AoaKey.Modifier[0]));
        KEYS.put("9", new AoaKey(38, new AoaKey.Modifier[0]));
        KEYS.put("0", new AoaKey(39, new AoaKey.Modifier[0]));
        KEYS.put("enter", new AoaKey(40, new AoaKey.Modifier[0]));
        KEYS.put("tab", new AoaKey(43, new AoaKey.Modifier[0]));
        KEYS.put("space", new AoaKey(44, new AoaKey.Modifier[0]));
        KEYS.put("right", new AoaKey(79, new AoaKey.Modifier[0]));
        KEYS.put("left", new AoaKey(80, new AoaKey.Modifier[0]));
        KEYS.put("down", new AoaKey(81, new AoaKey.Modifier[0]));
        KEYS.put("up", new AoaKey(82, new AoaKey.Modifier[0]));
        KEYS.put("@", new AoaKey(31, new AoaKey.Modifier[]{AoaKey.Modifier.SHIFT}));
        KEYS.put("-", new AoaKey(45, new AoaKey.Modifier[0]));
        KEYS.put("_", new AoaKey(45, new AoaKey.Modifier[]{AoaKey.Modifier.SHIFT}));
        KEYS.put("+", new AoaKey(46, new AoaKey.Modifier[]{AoaKey.Modifier.SHIFT}));
        KEYS.put(".", new AoaKey(55, new AoaKey.Modifier[0]));
    }

    @FunctionalInterface
    private static interface Action
    extends BiConsumer<AoaDevice, List<String>> {
    }
}

