/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

@OptionClass(alias="art-chroot-preparer")
public class ArtChrootPreparer
extends BaseTargetPreparer {
    public static final String CHROOT_PATH = "/data/local/tmp/art-test-chroot";
    private static final String[] MKDIRS = new String[]{"/", "/apex", "/data", "/data/dalvik-cache", "/data/local/tmp", "/tmp"};
    private static final String[] MOUNTS = new String[]{"/apex/com.android.conscrypt", "/apex/com.android.i18n", "/apex/com.android.os.statsd", "/apex/com.android.runtime", "/dev", "/dev/cpuset", "/etc", "/linkerconfig", "/proc", "/sys", "/system"};
    private List<String> mMountPoints = new ArrayList<String>();

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        File art_apex;
        ITestDevice device = testInfo.getDevice();
        this.cleanup(device);
        for (String dir : MKDIRS) {
            this.adbShell(device, "mkdir -p %s%s", CHROOT_PATH, dir);
        }
        for (String dir : MOUNTS) {
            this.adbShell(device, "mkdir -p %s%s", CHROOT_PATH, dir);
            this.adbShell(device, "mount --bind %s %s%s", dir, CHROOT_PATH, dir);
            this.mMountPoints.add(CHROOT_PATH + dir);
        }
        DeviceDescriptor deviceDesc = device.getDeviceDescriptor();
        File tempDir = null;
        try {
            art_apex = testInfo.getDependencyFile("com.android.art.testing.apex", true);
        }
        catch (FileNotFoundException e) {
            throw new TargetSetupError("ART testing apex not found", (Throwable)e, deviceDesc);
        }
        try {
            tempDir = FileUtil.createTempDir((String)"art-test-apex");
            this.activateApex(device, tempDir, art_apex);
        }
        catch (IOException e) {
            throw new TargetSetupError("Error when activating apex", (Throwable)e, deviceDesc);
        }
        finally {
            FileUtil.recursiveDelete((File)tempDir);
        }
    }

    private void activateApex(ITestDevice device, File tempDir, File apex) throws TargetSetupError, IOException, DeviceNotAvailableException {
        LogUtil.CLog.i((String)"Activate apex in ART chroot: %s", (Object[])new Object[]{apex.getName()});
        ZipFile apex_zip = new ZipFile(apex);
        ZipArchiveEntry apex_payload = apex_zip.getEntry("apex_payload.img");
        File temp = FileUtil.createTempFile((String)"payload-", (String)".img", (File)tempDir);
        FileUtil.writeToFile((InputStream)apex_zip.getInputStream(apex_payload), (File)temp);
        String deviceApexDir = String.format("%s/apex/%s", CHROOT_PATH, apex.getName());
        deviceApexDir = deviceApexDir.replace(".testing.apex", "").replace(".apex", "");
        String deviceApexImg = deviceApexDir + ".img";
        if (!device.pushFile(temp, deviceApexImg)) {
            throw new TargetSetupError(String.format("adb push failed for %s", apex.getName()), device.getDeviceDescriptor());
        }
        device.executeShellV2Command("losetup -f");
        String loopbackDevice = this.adbShell(device, "losetup -f -s %s", deviceApexImg);
        this.adbShell(device, "mkdir -p %s", deviceApexDir);
        this.adbShell(device, "mount -o loop,ro %s %s", loopbackDevice, deviceApexDir);
        this.mMountPoints.add(deviceApexDir);
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        try {
            this.cleanup(testInfo.getDevice());
        }
        catch (TargetSetupError ex) {
            LogUtil.CLog.e((String)"Tear-down failed: %s", (Object[])new Object[]{ex.toString()});
        }
    }

    private String adbShell(ITestDevice device, String format, Object ... args) throws TargetSetupError, DeviceNotAvailableException {
        String cmd = String.format(format, args);
        CommandResult result = device.executeShellV2Command(cmd);
        if (result.getStatus() != CommandStatus.SUCCESS) {
            throw new TargetSetupError(String.format("adb shell %s\n%s", cmd, result.toString()));
        }
        return result.getStdout();
    }

    private void cleanup(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        ListIterator<String> listIterator = this.mMountPoints.listIterator(this.mMountPoints.size());
        while (listIterator.hasPrevious()) {
            this.adbShell(device, "umount %s", listIterator.previous());
        }
        this.adbShell(device, "rm -rf %s", CHROOT_PATH);
    }
}

