/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.FastbootDeviceFlasher;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.ZipUtil2;
import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class CdmaDeviceFlasher
extends FastbootDeviceFlasher {
    private boolean mShouldFlashBaseband = false;
    protected static final int BASEBAND_FLASH_TIMEOUT = 600000;

    protected String getBootPartitionName() {
        return "bootloader";
    }

    public void flash(ITestDevice device, IDeviceBuildInfo deviceBuild) throws TargetSetupError, DeviceNotAvailableException {
        LogUtil.CLog.i((String)"Flashing device %s with build %s", (Object[])new Object[]{device.getSerialNumber(), deviceBuild.getBuildId()});
        String systemBuildId = device.getBuildId();
        String systemBuildFlavor = device.getBuildFlavor();
        device.rebootIntoBootloader();
        this.downloadFlashingResources(device, deviceBuild);
        this.checkAndFlashBootloader(device, deviceBuild);
        if (this.checkShouldFlashBaseband(device, deviceBuild)) {
            LogUtil.CLog.i((String)"Performing special CDMA baseband update flash procedure");
            this.flashUserData(device, deviceBuild);
            this.wipeCache(device);
            this.mShouldFlashBaseband = true;
            this.checkAndFlashBaseband(device, deviceBuild);
            this.checkAndFlashSystem(device, systemBuildId, systemBuildFlavor, deviceBuild);
            device.reboot();
        } else {
            this.flashUserData(device, deviceBuild);
            this.wipeCache(device);
            this.checkAndFlashSystem(device, systemBuildId, systemBuildFlavor, deviceBuild);
            device.reboot();
        }
    }

    protected void flashBaseband(ITestDevice device, File basebandImageFile) throws DeviceNotAvailableException, TargetSetupError {
        this.executeLongFastbootCmd(device, new String[]{"flash", "radio", basebandImageFile.getAbsolutePath()});
    }

    private void flashNamedPartition(ITestDevice device, File dir, String partition) throws DeviceNotAvailableException, TargetSetupError {
        File imgFile = new File(dir, partition + ".img");
        this.flashPartition(device, imgFile, partition);
    }

    protected File extractSystemZip(IDeviceBuildInfo deviceBuild) throws IOException {
        File updateDir = FileUtil.createTempDir((String)"CdmaDeviceFlasher");
        ZipFile updater = new ZipFile(deviceBuild.getDeviceImageFile().getAbsolutePath());
        ZipUtil2.extractZip((ZipFile)updater, (File)updateDir);
        return updateDir;
    }

    protected void flashSystem(ITestDevice device, IDeviceBuildInfo deviceBuild) throws DeviceNotAvailableException, TargetSetupError {
        if (this.mShouldFlashBaseband) {
            LogUtil.CLog.i((String)"MANUALLY flashing individual partitions on %s.", (Object[])new Object[]{device.getSerialNumber()});
            File updateDir = null;
            try {
                updateDir = this.extractSystemZip(deviceBuild);
                this.flashNamedPartition(device, updateDir, "boot");
                this.flashNamedPartition(device, updateDir, "recovery");
                this.flashNamedPartition(device, updateDir, "system");
            }
            catch (IOException e) {
                throw new TargetSetupError(String.format("Got IOException: %s", e.getMessage()), device.getDeviceDescriptor());
            }
            finally {
                if (updateDir != null) {
                    FileUtil.recursiveDelete((File)updateDir);
                    updateDir = null;
                }
            }
            device.executeFastbootCommand(new String[]{"reboot"});
            device.waitForDeviceOnline(600000L);
            device.waitForDeviceAvailable();
            this.getRunUtil().sleep(5000L);
            device.reboot();
            this.getRunUtil().sleep(5000L);
            device.rebootIntoBootloader();
        } else {
            super.flashSystem(device, deviceBuild);
            device.waitForDeviceOnline();
            device.rebootIntoBootloader();
        }
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }
}

