/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.google.common.annotations.VisibleForTesting;

@OptionClass(alias="device-owner")
public class DeviceOwnerTargetPreparer
extends BaseTargetPreparer
implements IConfigurationReceiver {
    @VisibleForTesting
    static final String DEVICE_OWNER_COMPONENT_NAME_OPTION = "device-owner-component-name";
    @VisibleForTesting
    static final String HEADLESS_SYSTEM_USER_PROPERTY = "ro.fw.mu.headless_system_user";
    private static final int USER_SYSTEM = 0;
    private IConfiguration mConfiguration;
    private ITestDevice mDevice;
    private int mDeviceOwnerUserId;
    @Option(name="device-owner-component-name", description="the component name that should be set as active admin, and its package as device owner. This must already be installed on the device.", importance=Option.Importance.IF_UNSET)
    private String mDeviceOwnerComponentName;

    public void setConfiguration(IConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration must not be null");
        }
        this.mConfiguration = configuration;
    }

    public void setUp(TestInformation testInfo) throws TargetSetupError, DeviceNotAvailableException {
        this.mDevice = testInfo.getDevice();
        this.mDeviceOwnerUserId = this.getDeviceOwnerUserId();
        this.mDevice.removeOwners();
        this.switchToDeviceOwnerUser();
        this.removeSecondaryUsers();
        this.setDeviceOwner();
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        this.removeDeviceOwner();
    }

    private void switchToDeviceOwnerUser() throws DeviceNotAvailableException {
        this.mDevice.switchUser(this.mDeviceOwnerUserId);
    }

    private boolean isHeadlessSystemUserMode() throws DeviceNotAvailableException {
        return this.mDevice.getBooleanProperty(HEADLESS_SYSTEM_USER_PROPERTY, false);
    }

    private int getDeviceOwnerUserId() throws DeviceNotAvailableException {
        if (this.isHeadlessSystemUserMode()) {
            return this.mDevice.getPrimaryUserId();
        }
        return 0;
    }

    private void removeSecondaryUsers() throws DeviceNotAvailableException {
        for (Integer id : this.mDevice.listUsers()) {
            if (id == 0 || id == this.mDeviceOwnerUserId || this.mDevice.removeUser(id.intValue())) continue;
            LogUtil.CLog.w((String)"Failed to remove user %d", (Object[])new Object[]{id});
        }
    }

    private void setDeviceOwner() throws DeviceNotAvailableException {
        this.mDevice.setDeviceOwner(this.mDeviceOwnerComponentName, this.mDeviceOwnerUserId);
    }

    private void removeDeviceOwner() throws DeviceNotAvailableException {
        this.mDevice.removeAdmin(this.mDeviceOwnerComponentName, this.mDeviceOwnerUserId);
    }
}

