/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;

@OptionClass(alias="disable-selinux-preparer")
public class DisableSELinuxTargetPreparer
extends BaseTargetPreparer {
    private boolean mWasRoot = false;
    private boolean mWasPermissive = false;
    private static final String PERMISSIVE = "Permissive";

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        CommandResult result = device.executeShellV2Command("getenforce");
        this.mWasPermissive = result.getStdout().contains(PERMISSIVE);
        if (this.mWasPermissive) {
            LogUtil.CLog.d((String)"SELinux was not enabled therefore DisableSELinuxTargetPreparer will do nothing. This is because enabling 'setenforce 1' blindly on tearDown can cause problems on devices that don't support it, i.e. on gce avds the GPU will crash.");
            return;
        }
        this.mWasRoot = device.isAdbRoot();
        if (!this.mWasRoot && !device.enableAdbRoot()) {
            throw new TargetSetupError("Failed to adb root device", device.getDeviceDescriptor());
        }
        LogUtil.CLog.d((String)"Disabling SELinux.");
        result = device.executeShellV2Command("setenforce 0");
        if (result.getStatus() != CommandStatus.SUCCESS) {
            throw new TargetSetupError("Disabling SELinux failed with status: " + result.getStatus(), device.getDeviceDescriptor());
        }
        if (!this.mWasRoot) {
            device.disableAdbRoot();
        }
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.mWasPermissive) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        if (!this.mWasRoot) {
            device.enableAdbRoot();
        }
        LogUtil.CLog.d((String)"Enabling SELinux.");
        device.executeShellV2Command("setenforce 1");
        if (!this.mWasRoot) {
            device.disableAdbRoot();
        }
    }
}

