/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import java.util.ArrayList;
import java.util.List;

@OptionClass(alias="fastboot-command-preparer")
public final class FastbootCommandPreparer
extends BaseTargetPreparer {
    @Option(name="fastboot-mode", description="True to boot the device into bootloader mode, false for fastbootd mode.")
    private FastbootMode mFastbootMode = FastbootMode.BOOTLOADER;
    @Option(name="stay-fastboot", description="True to keep the device in bootloader or fastbootd mode after the commands executed.")
    private boolean mStayFastboot = false;
    @Option(name="command", description="Fastboot commands to run in setup. Device will be rebooted after the commands executed.")
    private List<String> mFastbootCommands = new ArrayList<String>();
    @Option(name="teardown-command", description="Fastboot commands to run in teardown. Device will be rebooted after the commands executed.")
    private List<String> mFastbootTearDownCommands = new ArrayList<String>();

    public void setUp(TestInformation testInformation) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (!this.mFastbootCommands.isEmpty()) {
            ITestDevice device = testInformation.getDevice();
            this.enterFastboot(device);
            for (String cmd : this.mFastbootCommands) {
                CommandResult result = device.executeFastbootCommand(cmd.split("\\s+"));
                if (result.getExitCode() == 0) continue;
                throw new TargetSetupError(String.format("Command %s failed, stdout = [%s], stderr = [%s].", cmd, result.getStdout(), result.getStderr()), device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
            }
            this.exitFastboot(device);
        }
    }

    public void tearDown(TestInformation testInformation, Throwable e) throws DeviceNotAvailableException {
        if (!this.mFastbootTearDownCommands.isEmpty()) {
            ITestDevice device = testInformation.getDevice();
            this.enterFastboot(device);
            for (String cmd : this.mFastbootTearDownCommands) {
                device.executeFastbootCommand(cmd.split("\\s+"));
            }
            this.exitFastboot(device);
        }
    }

    private void enterFastboot(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mFastbootMode == FastbootMode.BOOTLOADER) {
            device.rebootIntoBootloader();
        } else {
            device.rebootIntoFastbootd();
        }
    }

    private void exitFastboot(ITestDevice device) throws DeviceNotAvailableException {
        if (!this.mStayFastboot) {
            device.reboot();
        }
    }

    private static enum FastbootMode {
        BOOTLOADER,
        FASTBOOTD;

    }
}

