/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FolderSaver
extends BaseTargetPreparer
implements ITestLoggerReceiver {
    @Option(name="device-path", description="Location of directory on device to be pulled and logged, may be repeated.")
    private List<String> mDevicePaths = new ArrayList<String>();
    @Option(name="include-empty", description="Upload empty folders if set; don't if not.")
    private Boolean mIncludeEmpty = false;
    private ITestLogger mTestLogger;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
    }

    public void setTestLogger(ITestLogger testLogger) {
        this.mTestLogger = testLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.i((String)"Device %s not available, skipping.", (Object[])new Object[]{testInfo.getDevice().getSerialNumber()});
            return;
        }
        if (this.mDevicePaths.isEmpty()) {
            LogUtil.CLog.i((String)"No device path provided, skipping.");
            return;
        }
        ITestDevice device = testInfo.getDevice();
        for (String path : this.mDevicePaths) {
            if (device.isStateBootloaderOrFastbootd()) {
                LogUtil.CLog.e((String)"Skip FolderSaver: %s is in state %s", (Object[])new Object[]{device.getSerialNumber(), device.getDeviceState()});
                continue;
            }
            if (!device.doesFileExist(path)) {
                LogUtil.CLog.w((String)"Directory, %s, does not exist.", (Object[])new Object[]{path});
                continue;
            }
            if (!device.isDirectory(path)) {
                LogUtil.CLog.w((String)"File, %s, is not a directory.", (Object[])new Object[]{path});
                continue;
            }
            if (!this.mIncludeEmpty.booleanValue() && device.getChildren(path).length == 0) {
                LogUtil.CLog.w((String)"Skipping empty directory, %s.", (Object[])new Object[]{path});
                continue;
            }
            File tempDir = null;
            try {
                tempDir = FileUtil.createTempDir((String)"tf-pulled-dir");
                if (!device.pullDir(path, tempDir)) {
                    LogUtil.CLog.w((String)"Failed to pull directory %s from device %s", (Object[])new Object[]{path, device.getSerialNumber()});
                    continue;
                }
                File zip = null;
                try {
                    zip = ZipUtil.createZip((File)tempDir);
                    FileInputStreamSource s = null;
                    try {
                        s = new FileInputStreamSource(zip);
                        this.mTestLogger.testLog(path, LogDataType.ZIP, (InputStreamSource)s);
                    }
                    catch (Throwable throwable) {
                        StreamUtil.cancel(s);
                        throw throwable;
                    }
                    StreamUtil.cancel((InputStreamSource)s);
                }
                finally {
                    FileUtil.deleteFile((File)zip);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("exception while saving device directory", ioe);
            }
            finally {
                FileUtil.recursiveDelete((File)tempDir);
            }
        }
    }
}

