/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.AaptParser;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ZipUtil2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipFile;

@OptionClass(alias="all-tests-zip-installer")
public class InstallAllTestZipAppsSetup
extends BaseTargetPreparer {
    @Option(name="install-arg", description="Additional arguments to be passed to install command, including leading dash, e.g. \"-d\"")
    private Collection<String> mInstallArgs = new ArrayList<String>();
    @Option(name="force-queryable", description="Whether apks should be installed as force queryable.")
    private Boolean mForceQueryable = null;
    @Option(name="cleanup-apks", description="Whether apks installed should be uninstalled after test. Note that the preparer does not verify if the apks are successfully removed.")
    private boolean mCleanup = true;
    @Option(name="stop-install-on-failure", description="Whether to stop the preparer by throwing an exception or only log the error on continue.")
    private boolean mStopInstallOnFailure = true;
    @Option(name="test-zip-name", description="File name for test zip containing APKs.")
    private String mTestZipName;
    List<String> mPackagesInstalled = new ArrayList<String>();

    public void setTestZipName(String testZipName) {
        this.mTestZipName = testZipName;
    }

    public void setStopInstallOnFailure(boolean stopInstallOnFailure) {
        this.mStopInstallOnFailure = stopInstallOnFailure;
    }

    public void setCleanup(boolean cleanup) {
        this.mCleanup = cleanup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException {
        File testsDir;
        if (this.isDisabled()) {
            LogUtil.CLog.d((String)"InstallAllTestZipAppsSetup disabled, skipping setUp");
            return;
        }
        File testsZip = this.getZipFile(device, buildInfo);
        if (testsZip == null) {
            throw new TargetSetupError("Failed to find a valid test zip directory.", device.getDeviceDescriptor());
        }
        try {
            testsDir = this.extractZip(testsZip);
        }
        catch (IOException e) {
            throw new TargetSetupError("Failed to extract test zip.", (Throwable)e, device.getDeviceDescriptor());
        }
        if (this.mForceQueryable == null) {
            this.mForceQueryable = !device.checkApiLevelAgainstNextRelease(34) || "TM".equals(device.getBuildAlias());
        }
        if (this.mForceQueryable.booleanValue() && device.isAppEnumerationSupported()) {
            this.mInstallArgs.add("--force-queryable");
        }
        try {
            this.installApksRecursively(testsDir, device);
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }

    File getZipFile(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError {
        if (this.mTestZipName == null) {
            throw new TargetSetupError("test-zip-name is null.", device.getDeviceDescriptor());
        }
        return buildInfo.getFile(this.mTestZipName);
    }

    void installApksRecursively(File directory, ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        File[] files;
        if (directory == null || !directory.isDirectory()) {
            throw new TargetSetupError("Invalid test directory!", device.getDeviceDescriptor());
        }
        LogUtil.CLog.d((String)"Installing all apks found in dir %s ...", (Object[])new Object[]{directory.getAbsolutePath()});
        for (File f : files = directory.listFiles()) {
            if (f.isDirectory()) {
                this.installApksRecursively(f, device);
                continue;
            }
            if (FileUtil.getExtension((String)f.getAbsolutePath()).toLowerCase().equals(".apk")) {
                this.installApk(f, device);
                continue;
            }
            LogUtil.CLog.d((String)"Skipping %s because it is not an apk", (Object[])new Object[]{f.getAbsolutePath()});
        }
    }

    File extractZip(File testsZip) throws IOException {
        File testsDir = null;
        try (ZipFile zip = new ZipFile(testsZip);){
            testsDir = FileUtil.createTempDir((String)"tests-zip_");
            ZipUtil2.extractZip((ZipFile)zip, (File)testsDir);
        }
        catch (IOException e) {
            FileUtil.recursiveDelete(testsDir);
            throw e;
        }
        return testsDir;
    }

    void installApk(File appFile, ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        LogUtil.CLog.d((String)"Installing apk from %s ...", (Object[])new Object[]{appFile.getAbsolutePath()});
        String result = device.installPackage(appFile, true, this.mInstallArgs.toArray(new String[0]));
        if (result == null) {
            if (this.mCleanup) {
                this.addApkToInstalledList(appFile, device);
            }
        } else {
            if (this.mStopInstallOnFailure) {
                throw new TargetSetupError(String.format("Failed to install %s on %s. Reason: '%s'", appFile, device.getSerialNumber(), result), device.getDeviceDescriptor());
            }
            LogUtil.CLog.e((String)"Failed to install %s on %s. Reason: '%s'", (Object[])new Object[]{appFile, device.getSerialNumber(), result});
        }
    }

    void addApkToInstalledList(File appFile, ITestDevice device) throws TargetSetupError {
        String packageName = this.getAppPackageName(appFile);
        if (packageName == null) {
            throw new TargetSetupError("apk installed but AaptParser failed", device.getDeviceDescriptor());
        }
        this.mPackagesInstalled.add(packageName);
    }

    String getAppPackageName(File appFile) {
        AaptParser parser = AaptParser.parse((File)appFile);
        if (parser == null) {
            return null;
        }
        return parser.getPackageName();
    }

    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.isDisabled()) {
            LogUtil.CLog.d((String)"InstallAllTestZipAppsSetup disabled, skipping tearDown");
            return;
        }
        if (this.mCleanup && !(e instanceof DeviceNotAvailableException)) {
            for (String packageName : this.mPackagesInstalled) {
                String msg = device.uninstallPackage(packageName);
                if (msg == null) continue;
                LogUtil.CLog.w((String)String.format("error uninstalling package '%s': %s", packageName, msg));
            }
        }
    }
}

