/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.util.RunUtil;
import java.util.HashMap;
import java.util.Map;

@OptionClass(alias="instrumentation-preparer")
public class InstrumentationPreparer
extends BaseTargetPreparer {
    @Option(name="package", shortName=112, description="The manifest package name of the Android test application to run.", importance=Option.Importance.IF_UNSET)
    private String mPackageName = null;
    @Option(name="runner", description="The instrumentation test runner class name to use.")
    private String mRunnerName = "android.test.InstrumentationTestRunner";
    @Option(name="class", shortName=99, description="The test class name to run.")
    private String mClassName = null;
    @Option(name="method", shortName=109, description="The test method name to run.")
    private String mMethodName = null;
    @Option(name="shell-timeout", description="The defined timeout (in milliseconds) is used as a maximum waiting time when expecting the command output from the device. At any time, if the shell command does not output anything for a period longer than defined timeout the TF run terminates. For no timeout, set to 0.", isTimeVal=true)
    private long mShellTimeout = 600000L;
    @Option(name="test-timeout", description="Sets timeout (in milliseconds) that will be applied to each test. In the event of a test timeout it will log the results and proceed with executing the next test. For no timeout, set to 0.", isTimeVal=true)
    private long mTestTimeout = 600000L;
    @Option(name="instrumentation-arg", description="Instrumentation arguments to provide.")
    private Map<String, String> mInstrArgMap = new HashMap<String, String>();
    @Option(name="attempts", description="The max number of attempts to make to run the instrumentation successfully.")
    private int mAttempts = 1;
    @Option(name="delay-before-retry", description="Time to delay before retrying another instrumentation attempt.", isTimeVal=true)
    private long mRetryDelayMs = 0L;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.isDisabled()) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        BuildError e = null;
        for (int i = 0; i < this.mAttempts; ++i) {
            try {
                this.runInstrumentation(testInfo);
                return;
            }
            catch (BuildError e1) {
                e = e1;
                LogUtil.CLog.d((String)"sleeping %d msecs on device %s before retrying instrumentation test run", (Object[])new Object[]{this.mRetryDelayMs, device.getSerialNumber()});
                RunUtil.getDefault().sleep(this.mRetryDelayMs);
                continue;
            }
        }
        throw e;
    }

    private void runInstrumentation(TestInformation testInfo) throws DeviceNotAvailableException, BuildError {
        ITestDevice device = testInfo.getDevice();
        InstrumentationTest test = this.createInstrumentationTest();
        test.setDevice(device);
        test.setPackageName(this.mPackageName);
        test.setRunnerName(this.mRunnerName);
        test.setClassName(this.mClassName);
        test.setMethodName(this.mMethodName);
        test.setShellTimeout(this.mShellTimeout);
        test.setTestTimeout(this.mTestTimeout);
        for (Map.Entry<String, String> entry : this.mInstrArgMap.entrySet()) {
            test.addInstrumentationArg(entry.getKey(), entry.getValue());
        }
        CollectingTestListener listener = new CollectingTestListener();
        test.run(testInfo, (ITestInvocationListener)listener);
        if (listener.hasFailedTests()) {
            String msg = String.format("Failed to run instrumentation %s on %s. failed tests = %s", this.mPackageName, device.getSerialNumber(), this.getFailedTestNames(listener));
            LogUtil.CLog.w((String)msg);
            throw new BuildError(msg, device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
    }

    private String getFailedTestNames(CollectingTestListener listener) {
        StringBuilder builder = new StringBuilder();
        for (TestRunResult result : listener.getMergedTestRunResults()) {
            if (!result.hasFailedTests()) continue;
            for (Map.Entry entry : result.getTestResults().entrySet()) {
                if (((TestResult)entry.getValue()).getStatus().equals((Object)TestResult.TestStatus.PASSED)) continue;
                if (0 < builder.length()) {
                    builder.append(",");
                }
                builder.append(entry.getKey());
            }
        }
        return builder.toString();
    }

    InstrumentationTest createInstrumentationTest() {
        return new InstrumentationTest();
    }

    void setPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    void setRunnerName(String runnerName) {
        this.mRunnerName = runnerName;
    }

    void setClassName(String className) {
        this.mClassName = className;
    }

    void setMethodName(String methodName) {
        this.mMethodName = methodName;
    }

    @Deprecated
    void setTimeout(int timeout) {
        this.setShellTimeout(timeout);
    }

    void setShellTimeout(long timeout) {
        this.mShellTimeout = timeout;
    }

    void setTestTimeout(int timeout) {
        this.mTestTimeout = timeout;
    }

    void setAttempts(int attempts) {
        this.mAttempts = attempts;
    }

    void setRetryDelay(int delayMs) {
        this.mRetryDelayMs = delayMs;
    }
}

