/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.PythonVirtualenvHelper;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@OptionClass(alias="python-venv")
public class PythonVirtualenvPreparer
extends BaseTargetPreparer {
    private static final String PIP = "pip3";
    protected static final String PYTHONPATH = "PYTHONPATH";
    private static final int BASE_TIMEOUT = 60000;
    @Option(name="venv-dir", description="path of an existing virtualenv to use")
    private File mVenvDir = null;
    @Option(name="requirements-file", description="pip-formatted requirements file")
    private File mRequirementsFile = null;
    @Option(name="dep-module", description="modules which need to be installed by pip")
    private List<String> mDepModules = new ArrayList<String>();
    IRunUtil mRunUtil = new RunUtil();
    String mPip = "pip3";
    private File mTmpVenvDir = null;

    public void setUp(TestInformation testInformation) throws TargetSetupError {
        if (this.isDisabled()) {
            LogUtil.CLog.i((String)"Skipping PythonVirtualenvPreparer");
            return;
        }
        this.startVirtualenv(testInformation.getBuildInfo(), testInformation.getDevice());
        this.installDeps(testInformation.getBuildInfo(), testInformation.getDevice());
    }

    protected void installDeps(IBuildInfo buildInfo, ITestDevice device) throws TargetSetupError {
        boolean hasDependencies = false;
        this.mPip = this.getPipPath();
        if (this.mRequirementsFile != null) {
            CommandResult c = this.mRunUtil.runTimedCmd(300000L, new String[]{this.mPip, "install", "-r", this.mRequirementsFile.getAbsolutePath()});
            if (c.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e((String)"Installing dependencies from %s failed", (Object[])new Object[]{this.mRequirementsFile.getAbsolutePath()});
                throw new TargetSetupError("Failed to install dependencies with pip", device.getDeviceDescriptor());
            }
            hasDependencies = true;
        }
        if (!this.mDepModules.isEmpty()) {
            for (String dep : this.mDepModules) {
                LogUtil.CLog.i((String)"Attempting installation of %s", (Object[])new Object[]{dep});
                CommandResult c = this.mRunUtil.runTimedCmd(300000L, new String[]{this.mPip, "install", dep});
                if (c.getStatus() != CommandStatus.SUCCESS) {
                    LogUtil.CLog.e((String)"Installing %s failed", (Object[])new Object[]{dep});
                    throw new TargetSetupError("Failed to install dependencies with pip", device.getDeviceDescriptor());
                }
                LogUtil.CLog.d((String)"Successfullly installed %s.", (Object[])new Object[]{dep});
                LogUtil.CLog.d((String)"Stdout: %s", (Object[])new Object[]{c.getStdout()});
                hasDependencies = true;
            }
        }
        if (!hasDependencies) {
            LogUtil.CLog.i((String)"No dependencies to install");
        } else {
            buildInfo.setFile(PYTHONPATH, new File(this.mTmpVenvDir, "local/lib/python3.8/site-packages"), buildInfo.getBuildId());
            buildInfo.setFile("VIRTUAL_ENV", this.mTmpVenvDir, buildInfo.getBuildId());
        }
    }

    protected void startVirtualenv(IBuildInfo buildInfo, ITestDevice device) throws TargetSetupError {
        FileUtil.recursiveDelete((File)this.mTmpVenvDir);
        this.mTmpVenvDir = null;
        if (this.mVenvDir != null) {
            this.mTmpVenvDir = FileUtil.getFileForPath((File)CurrentInvocation.getWorkFolder(), (String[])new String[]{buildInfo.getTestTag() + "-virtualenv"});
            try {
                FileUtil.symlinkFile((File)this.mVenvDir, (File)this.mTmpVenvDir);
            }
            catch (IOException e) {
                LogUtil.CLog.e((String)"Failed to create temp directory for virtualenv");
                throw new TargetSetupError("Error creating virtualenv", (Throwable)e, device.getDeviceDescriptor());
            }
            LogUtil.CLog.i((String)"Using existing virtualenv based at %s", (Object[])new Object[]{this.mVenvDir.getAbsolutePath()});
            PythonVirtualenvHelper.activate(this.mRunUtil, this.mTmpVenvDir);
            return;
        }
        this.checkVirtualenvVersion(device);
        try {
            this.mTmpVenvDir = FileUtil.createNamedTempDir((File)CurrentInvocation.getWorkFolder(), (String)(buildInfo.getTestTag() + "-virtualenv"));
            CommandResult c = this.mRunUtil.runTimedCmd(60000L, new String[]{"virtualenv", this.mTmpVenvDir.getAbsolutePath()});
            if (c.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e((String)"Creating virtual environment at %s failed.", (Object[])new Object[]{this.mTmpVenvDir.getAbsoluteFile()});
                LogUtil.CLog.e((String)"Status: %s\nStdout: %s\nStderr: %s", (Object[])new Object[]{c.getStatus(), c.getStdout(), c.getStderr()});
                throw new TargetSetupError(String.format("Failed to create virtual environment. Error:\n%s", c.getStderr()), device.getDeviceDescriptor());
            }
            LogUtil.CLog.i((String)"Created a virtualenv based at %s", (Object[])new Object[]{this.mTmpVenvDir.getAbsolutePath()});
            PythonVirtualenvHelper.activate(this.mRunUtil, this.mTmpVenvDir);
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Failed to create temp directory for virtualenv");
            throw new TargetSetupError("Error creating virtualenv", (Throwable)e, device.getDeviceDescriptor());
        }
    }

    protected void addDepModule(String module) {
        this.mDepModules.add(module);
    }

    protected void setRequirementsFile(File f) {
        this.mRequirementsFile = f;
    }

    private String getPipPath() {
        if (this.mTmpVenvDir == null || !this.mTmpVenvDir.exists()) {
            return null;
        }
        String virtualenvPath = this.mTmpVenvDir.getAbsolutePath();
        File pipFile = new File(PythonVirtualenvHelper.getPythonBinDir(virtualenvPath), PIP);
        pipFile.setExecutable(true);
        return pipFile.getAbsolutePath();
    }

    private void checkVirtualenvVersion(ITestDevice device) throws TargetSetupError {
        CommandResult result = this.mRunUtil.runTimedCmd(60000L, new String[]{"virtualenv", "--version"});
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            throw new TargetSetupError("Failed to run `virtualenv --version`. Reason:\n" + result.getStderr(), device.getDeviceDescriptor());
        }
        String stdout = result.getStdout();
        if (stdout.contains("command not found")) {
            throw new TargetSetupError("virtualenv is not installed.", device.getDeviceDescriptor());
        }
        LogUtil.CLog.d((String)"Output from virtualenv --version: %s", (Object[])new Object[]{stdout});
        String[] split = stdout.split(" ");
        if (split.length < 2) {
            throw new TargetSetupError(String.format("Something is wrong with your installed virtualenv version: %s", stdout), device.getDeviceDescriptor());
        }
        String version = split[1];
        int majorVersion = Integer.parseInt(version.split("\\.")[0]);
        if (majorVersion < 20) {
            throw new TargetSetupError("virtualenv is too old. Required: >=20.0.1, yours: " + version, device.getDeviceDescriptor());
        }
    }
}

