/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.ArrayList;
import java.util.List;

public class RemoveSystemAppPreparer
extends BaseTargetPreparer {
    @Option(name="uninstall-system-app", description="the name of the file to remove (extension included)")
    private List<String> mFiles = new ArrayList<String>();

    public void setUp(TestInformation testInformation) throws TargetSetupError, DeviceNotAvailableException {
        ITestDevice device = testInformation.getDevice();
        device.remountSystemWritable();
        for (String file : this.mFiles) {
            LogUtil.CLog.d((String)"Removing system app %s from /system/app", (Object[])new Object[]{file});
            device.executeShellCommand(String.format("rm /system/app/%s", file));
            LogUtil.CLog.d((String)"Removing system app %s from /system/priv-app", (Object[])new Object[]{file});
            device.executeShellCommand(String.format("rm /system/priv-app/%s", file));
        }
        device.reboot();
        device.waitForDeviceAvailable();
    }
}

