/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@OptionClass(alias="run-host-script")
public class RunHostScriptTargetPreparer
extends BaseTargetPreparer {
    private static final String DEVICE_SERIAL_PLACEHOLDER = "$SERIAL";
    @Option(name="script-file", description="Path to the script to execute. $SERIAL can be used as placeholder to be replaced with real device serial number at runtime.")
    private String mScriptPath = null;
    @Option(name="work-dir", description="Working directory to use when executing script. $SERIAL can be used as placeholder to be replaced with real device serial number at runtime.")
    private File mWorkDir = null;
    @Option(name="script-timeout", description="Script execution timeout.")
    private Duration mTimeout = Duration.ofMinutes(1L);
    @Option(name="use-flashing-permit", description="Acquire a flashing permit before executing the script.")
    private boolean mUseFlashingPermit = false;
    private IRunUtil mRunUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        File scriptFile;
        if (this.mScriptPath == null) {
            LogUtil.CLog.w((String)"No script to execute.");
            return;
        }
        ITestDevice device = testInfo.getDevice();
        this.mScriptPath = this.mScriptPath.replace(DEVICE_SERIAL_PLACEHOLDER, device.getSerialNumber());
        if (this.mWorkDir != null) {
            this.mWorkDir = new File(this.mWorkDir.toString().replace(DEVICE_SERIAL_PLACEHOLDER, device.getSerialNumber()));
        }
        if ((scriptFile = this.findScriptFile(testInfo)) == null || !scriptFile.isFile()) {
            throw new TargetSetupError(String.format("File %s not found.", this.mScriptPath), device.getDeviceDescriptor());
        }
        if (!scriptFile.canExecute()) {
            scriptFile.setExecutable(true);
        }
        this.getRunUtil().setWorkingDir(this.mWorkDir);
        this.getRunUtil().setEnvVariable("ANDROID_SERIAL", device.getSerialNumber());
        this.setPathVariable(testInfo);
        try {
            if (this.mUseFlashingPermit) {
                this.getHostOptions().takePermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
            }
            this.executeScript(scriptFile, device);
        }
        finally {
            if (this.mUseFlashingPermit) {
                this.getHostOptions().returnPermit(IHostOptions.PermitLimitType.CONCURRENT_FLASHER);
            }
        }
    }

    @VisibleForTesting
    IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = new RunUtil();
        }
        return this.mRunUtil;
    }

    @VisibleForTesting
    IDeviceManager getDeviceManager() {
        return GlobalConfiguration.getDeviceManagerInstance();
    }

    @VisibleForTesting
    IHostOptions getHostOptions() {
        return GlobalConfiguration.getInstance().getHostOptions();
    }

    @Nullable
    private File findScriptFile(TestInformation testInfo) {
        File scriptFile = new File(this.mScriptPath);
        if (scriptFile.isAbsolute()) {
            return scriptFile;
        }
        if (this.mWorkDir != null && (scriptFile = new File(this.mWorkDir, this.mScriptPath)).isFile()) {
            return scriptFile;
        }
        try {
            return testInfo.getDependencyFile(this.mScriptPath, false);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private void setPathVariable(TestInformation testInfo) {
        File fastbootBinary;
        String fastbootPath;
        String adbPath;
        ArrayList<String> paths = new ArrayList<String>();
        File adbBinary = testInfo.executionFiles().get(ExecutionFiles.FilesKey.ADB_BINARY);
        if (adbBinary == null && !(adbPath = this.getDeviceManager().getAdbPath()).equals("adb")) {
            adbBinary = new File(adbPath);
        }
        if (adbBinary != null && adbBinary.isFile()) {
            paths.add(adbBinary.getParentFile().getAbsolutePath());
        }
        if (!(fastbootPath = this.getDeviceManager().getFastbootPath()).equals("fastboot") && (fastbootBinary = new File(fastbootPath)).isFile()) {
            paths.add(fastbootBinary.getParentFile().getAbsolutePath());
        }
        if (!paths.isEmpty()) {
            String separator = System.getProperty("path.separator");
            paths.add(System.getenv("PATH"));
            String path = paths.stream().distinct().collect(Collectors.joining(separator));
            LogUtil.CLog.d((String)"Using updated $PATH: %s", (Object[])new Object[]{path});
            this.getRunUtil().setEnvVariable("PATH", path);
        }
    }

    private void executeScript(File scriptFile, ITestDevice device) throws TargetSetupError {
        CommandResult result = this.getRunUtil().runTimedCmd(this.mTimeout.toMillis(), new String[]{scriptFile.getAbsolutePath()});
        LogUtil.CLog.i((String)"Finished executing script '%s' (status=%s)", (Object[])new Object[]{scriptFile.getPath(), result.getStatus()});
        LogUtil.CLog.i((String)"Stdout: %s", (Object[])new Object[]{result.getStdout()});
        LogUtil.CLog.i((String)"Stderr: %s", (Object[])new Object[]{result.getStderr()});
        switch (result.getStatus()) {
            case FAILED: {
                throw new TargetSetupError("Script execution failed", device.getDeviceDescriptor());
            }
            case TIMED_OUT: {
                throw new TargetSetupError("Script execution timed out", device.getDeviceDescriptor());
            }
            case EXCEPTION: {
                throw new TargetSetupError("Exception during script execution", device.getDeviceDescriptor());
            }
        }
    }
}

