/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

@OptionClass(alias="tests-system-app")
public class TestSystemAppInstallSetup
extends BaseTargetPreparer {
    @Option(name="system-file-name", description="the name of a test zip file to install on device system partition. Can be repeated.", importance=Option.Importance.IF_UNSET)
    private Collection<String> mTestFileNames = new ArrayList<String>();

    public void addTestFileName(String fileName) {
        this.mTestFileNames.add(fileName);
    }

    public void setUp(TestInformation testInfo) throws TargetSetupError, DeviceNotAvailableException {
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        if (!(buildInfo instanceof IDeviceBuildInfo)) {
            throw new IllegalArgumentException(String.format("Provided buildInfo is not a %s", IDeviceBuildInfo.class.getCanonicalName()));
        }
        ITestDevice device = testInfo.getDevice();
        if (this.mTestFileNames.size() == 0) {
            LogUtil.CLog.i((String)"No test apps to install, skipping");
            return;
        }
        File testsDir = ((IDeviceBuildInfo)buildInfo).getTestsDir();
        if (testsDir == null || !testsDir.exists()) {
            throw new TargetSetupError("Provided buildInfo does not contain a valid tests directory", device.getDeviceDescriptor());
        }
        device.remountSystemWritable();
        device.setRecoveryMode(ITestDevice.RecoveryMode.ONLINE);
        device.executeShellCommand("stop");
        for (String testAppName : this.mTestFileNames) {
            File testAppFile = FileUtil.getFileForPath((File)testsDir, (String[])new String[]{"DATA", "app", testAppName});
            if (!testAppFile.exists()) {
                throw new TargetSetupError(String.format("Could not find test app %s directory in extracted tests.zip", testAppFile), device.getDeviceDescriptor());
            }
            device.pushFile(testAppFile, String.format("/system/app/%s", testAppName));
        }
        device.setRecoveryMode(ITestDevice.RecoveryMode.AVAILABLE);
        device.executeShellCommand("start");
        device.waitForDeviceAvailable();
    }
}

