/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.proto.TestRecordProto;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class GTestListener
extends ResultForwarder {
    private static final int MAX_PARTIAL_SET_SIZE = 20;
    private Set<TestDescription> mTests = new HashSet<TestDescription>();
    private Set<TestDescription> mDuplicateTests = new HashSet<TestDescription>();
    private boolean mPartialList = false;

    public GTestListener(ITestInvocationListener ... listeners) {
        super(listeners);
    }

    public void testStarted(TestDescription test, long startTime) {
        super.testStarted(test, startTime);
        if (this.mDuplicateTests.size() < 20) {
            if (!this.mTests.add(test)) {
                this.mDuplicateTests.add(test);
            }
        } else {
            this.mPartialList = true;
            this.mTests.clear();
        }
    }

    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        if (!this.mDuplicateTests.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(String.format("%s tests ran more than once.", this.mDuplicateTests.size()));
            if (this.mPartialList) {
                errorMessage.append(String.format(" Partial list: %s", this.mDuplicateTests));
            } else {
                errorMessage.append(String.format(" Full list: %s", this.mDuplicateTests));
            }
            FailureDescription error = FailureDescription.create((String)errorMessage.toString());
            error.setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE).setRetriable(false);
            super.testRunFailed(error);
        }
        super.testRunEnded(elapsedTime, runMetrics);
    }
}

