/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class MultimapSubject
extends Subject {
    private static final Ordered ALREADY_FAILED = () -> {};
    private final Multimap<?, ?> actual;

    protected MultimapSubject(FailureMetadata metadata, Multimap<?, ?> multimap) {
        this(metadata, multimap, null);
    }

    MultimapSubject(FailureMetadata metadata, Multimap<?, ?> multimap, String typeDescription) {
        super(metadata, multimap, typeDescription);
        this.actual = multimap;
    }

    public final void isEmpty() {
        if (!Preconditions.checkNotNull(this.actual).isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (Preconditions.checkNotNull(this.actual).isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0, "expectedSize(%s) must be >= 0", expectedSize);
        this.check("size()", new Object[0]).that(Preconditions.checkNotNull(this.actual).size()).isEqualTo(expectedSize);
    }

    public final void containsKey(Object key) {
        this.check("keySet()", new Object[0]).that(Preconditions.checkNotNull(this.actual).keySet()).contains(key);
    }

    public final void doesNotContainKey(Object key) {
        this.check("keySet()", new Object[0]).that(Preconditions.checkNotNull(this.actual).keySet()).doesNotContain(key);
    }

    public final void containsEntry(Object key, Object value) {
        Preconditions.checkNotNull(this.actual);
        if (!this.actual.containsEntry(key, value)) {
            Map.Entry<Object, Object> entry = Maps.immutableEntry(key, value);
            ImmutableList<Map.Entry<Object, Object>> entryList = ImmutableList.of(entry);
            if (SubjectUtils.hasMatchingToStringPair(this.actual.entries(), entryList)) {
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.fact("an instance of", SubjectUtils.objectToTypeName(entry)), Fact.simpleFact("but did not"), Fact.fact("though it did contain", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual.entries(), entryList))), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else if (this.actual.containsKey(key)) {
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.simpleFact("but did not"), Fact.fact("though it did contain values with that key", this.actual.asMap().get(key)), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else if (this.actual.containsValue(value)) {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry<?, ?> actualEntry : this.actual.entries()) {
                    if (!Objects.equal(actualEntry.getValue(), value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.simpleFact("but did not"), Fact.fact("though it did contain keys with that value", keys), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else {
                this.failWithActual("expected to contain entry", Maps.immutableEntry(key, value));
            }
        }
    }

    public final void doesNotContainEntry(Object key, Object value) {
        this.checkNoNeedToDisplayBothValues("entries()", new Object[0]).that(Preconditions.checkNotNull(this.actual).entries()).doesNotContain(Maps.immutableEntry(key, value));
    }

    public IterableSubject valuesForKey(Object key) {
        return this.check("valuesForKey(%s)", key).that(Preconditions.checkNotNull(this.actual).get(key));
    }

    @Override
    public final void isEqualTo(Object other) {
        boolean isEqual = Objects.equal(this.actual, other);
        if (isEqual) {
            return;
        }
        if (this.actual instanceof ListMultimap && other instanceof SetMultimap || this.actual instanceof SetMultimap && other instanceof ListMultimap) {
            String actualType = this.actual instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
            String otherType = other instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
            this.failWithoutActual(Fact.fact("expected", other), Fact.fact("an instance of", otherType), Fact.fact("but was", this.actualCustomStringRepresentationForPackageMembersToCall()), Fact.fact("an instance of", actualType), Fact.simpleFact(Strings.lenientFormat("a %s cannot equal a %s if either is non-empty", actualType, otherType)));
        } else if (this.actual instanceof ListMultimap) {
            this.containsExactlyEntriesIn((Multimap)Preconditions.checkNotNull(other)).inOrder();
        } else if (this.actual instanceof SetMultimap) {
            this.containsExactlyEntriesIn((Multimap)Preconditions.checkNotNull(other));
        } else {
            super.isEqualTo(other);
        }
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyEntriesIn(Multimap<?, ?> expectedMultimap) {
        Preconditions.checkNotNull(expectedMultimap, "expectedMultimap");
        Preconditions.checkNotNull(this.actual);
        ListMultimap<?, ?> missing = MultimapSubject.difference(expectedMultimap, this.actual);
        ListMultimap<?, ?> extra = MultimapSubject.difference(this.actual, expectedMultimap);
        if (!missing.isEmpty()) {
            if (!extra.isEmpty()) {
                boolean addTypeInfo = SubjectUtils.hasMatchingToStringPair(missing.entries(), extra.entries());
                String missingDisplay = addTypeInfo ? SubjectUtils.countDuplicatesAndAddTypeInfo(MultimapSubject.annotateEmptyStringsMultimap(missing).entries()) : MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing));
                String extraDisplay = addTypeInfo ? SubjectUtils.countDuplicatesAndAddTypeInfo(MultimapSubject.annotateEmptyStringsMultimap(extra).entries()) : MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(extra));
                this.failWithActual(Fact.fact("missing", missingDisplay), Fact.fact("unexpected", extraDisplay), Fact.simpleFact("---"), Fact.fact("expected", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
                return ALREADY_FAILED;
            }
            this.failWithActual(Fact.fact("missing", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing))), Fact.simpleFact("---"), Fact.fact("expected", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
            return ALREADY_FAILED;
        }
        if (!extra.isEmpty()) {
            this.failWithActual(Fact.fact("unexpected", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(extra))), Fact.simpleFact("---"), Fact.fact("expected", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
            return ALREADY_FAILED;
        }
        return new MultimapInOrder(false, expectedMultimap);
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeastEntriesIn(Multimap<?, ?> expectedMultimap) {
        Preconditions.checkNotNull(expectedMultimap, "expectedMultimap");
        Preconditions.checkNotNull(this.actual);
        ListMultimap<?, ?> missing = MultimapSubject.difference(expectedMultimap, this.actual);
        if (!missing.isEmpty()) {
            this.failWithActual(Fact.fact("missing", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing))), Fact.simpleFact("---"), Fact.fact("expected to contain at least", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap)));
            return ALREADY_FAILED;
        }
        return new MultimapInOrder(true, expectedMultimap);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly() {
        return this.check().about(this.iterableEntries()).that(Preconditions.checkNotNull(this.actual).entries()).containsExactly(new Object[0]);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly(Object k0, Object v0, Object ... rest) {
        return this.containsExactlyEntriesIn(MultimapSubject.accumulateMultimap(k0, v0, rest));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeast(Object k0, Object v0, Object ... rest) {
        return this.containsAtLeastEntriesIn(MultimapSubject.accumulateMultimap(k0, v0, rest));
    }

    private static ListMultimap<Object, Object> accumulateMultimap(Object k0, Object v0, Object ... rest) {
        Preconditions.checkArgument(rest.length % 2 == 0, "There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", rest.length + 2);
        LinkedListMultimap<Object, Object> expectedMultimap = LinkedListMultimap.create();
        expectedMultimap.put(k0, v0);
        for (int i = 0; i < rest.length; i += 2) {
            expectedMultimap.put(rest[i], rest[i + 1]);
        }
        return expectedMultimap;
    }

    private Subject.Factory<IterableSubject, Iterable<?>> iterableEntries() {
        return new Subject.Factory<IterableSubject, Iterable<?>>(){

            @Override
            public IterableSubject createSubject(FailureMetadata metadata, Iterable<?> actual) {
                return new IterableEntries(metadata, MultimapSubject.this, Preconditions.checkNotNull(actual));
            }
        };
    }

    private static boolean advanceToFind(Iterator<?> iterator, Object value) {
        while (iterator.hasNext()) {
            if (!Objects.equal(iterator.next(), value)) continue;
            return true;
        }
        return false;
    }

    private static <V> Collection<V> get(Multimap<?, V> multimap, Object key) {
        if (multimap.containsKey(key)) {
            return Preconditions.checkNotNull(multimap.asMap().get(key));
        }
        return Collections.emptyList();
    }

    private static ListMultimap<?, ?> difference(Multimap<?, ?> minuend, Multimap<?, ?> subtrahend) {
        LinkedListMultimap<?, ?> difference = LinkedListMultimap.create();
        for (Object key : minuend.keySet()) {
            List<?> valDifference = MultimapSubject.difference(Lists.newArrayList(MultimapSubject.get(minuend, key)), Lists.newArrayList(MultimapSubject.get(subtrahend, key)));
            difference.putAll(key, valDifference);
        }
        return difference;
    }

    private static List<?> difference(List<?> minuend, List<?> subtrahend) {
        LinkedHashMultiset<?> remaining = LinkedHashMultiset.create(subtrahend);
        ArrayList<?> difference = Lists.newArrayList();
        for (Object elem : minuend) {
            if (remaining.remove(elem)) continue;
            difference.add(elem);
        }
        return difference;
    }

    private static String countDuplicatesMultimap(Multimap<?, ?> multimap) {
        ArrayList<String> entries = new ArrayList<String>();
        for (Object key : multimap.keySet()) {
            entries.add(key + "=" + SubjectUtils.countDuplicates(MultimapSubject.get(multimap, key)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Joiner.on(", ").appendTo(sb, (Iterable<? extends Object>)entries);
        sb.append("}");
        return sb.toString();
    }

    private static Multimap<?, ?> annotateEmptyStringsMultimap(Multimap<?, ?> multimap) {
        if (multimap.containsKey("") || multimap.containsValue("")) {
            LinkedListMultimap<String, String> annotatedMultimap = LinkedListMultimap.create();
            for (Map.Entry<?, ?> entry : multimap.entries()) {
                String key = Objects.equal(entry.getKey(), "") ? "\"\" (empty String)" : entry.getKey();
                String value = Objects.equal(entry.getValue(), "") ? "\"\" (empty String)" : entry.getValue();
                annotatedMultimap.put(key, value);
            }
            return annotatedMultimap;
        }
        return multimap;
    }

    public <A, E> UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<? super A, ? super E> correspondence) {
        return new UsingCorrespondence<A, E>(correspondence);
    }

    private static <K, A, E> Correspondence<Map.Entry<K, A>, Map.Entry<K, E>> entryCorrespondence(Correspondence<? super A, ? super E> valueCorrespondence) {
        return Correspondence.from((actual, expected) -> Objects.equal(actual.getKey(), expected.getKey()) && valueCorrespondence.compare((Object)actual.getValue(), (Object)expected.getValue()), Strings.lenientFormat("has a key that is equal to and a value that %s the key and value of", valueCorrespondence));
    }

    private class MultimapInOrder
    implements Ordered {
        private final Multimap<?, ?> expectedMultimap;
        private final boolean allowUnexpected;

        MultimapInOrder(boolean allowUnexpected, Multimap<?, ?> expectedMultimap) {
            this.expectedMultimap = expectedMultimap;
            this.allowUnexpected = allowUnexpected;
        }

        @Override
        public void inOrder() {
            Preconditions.checkNotNull(MultimapSubject.this.actual);
            boolean keysInOrder = Lists.newArrayList(Sets.intersection(MultimapSubject.this.actual.keySet(), this.expectedMultimap.keySet())).equals(Lists.newArrayList(this.expectedMultimap.keySet()));
            LinkedHashSet<?> keysWithValuesOutOfOrder = Sets.newLinkedHashSet();
            block0: for (Object key : this.expectedMultimap.keySet()) {
                ArrayList<?> actualVals = Lists.newArrayList(MultimapSubject.get(MultimapSubject.this.actual, key));
                ArrayList expectedVals = Lists.newArrayList(MultimapSubject.get(this.expectedMultimap, key));
                Iterator actualIterator = actualVals.iterator();
                for (Object value : expectedVals) {
                    if (MultimapSubject.advanceToFind(actualIterator, value)) continue;
                    boolean unused = keysWithValuesOutOfOrder.add(key);
                    continue block0;
                }
            }
            if (!keysInOrder) {
                if (!keysWithValuesOutOfOrder.isEmpty()) {
                    MultimapSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.simpleFact("keys are not in order"), Fact.fact("keys with out-of-order values", keysWithValuesOutOfOrder), Fact.simpleFact("---"), Fact.fact(this.allowUnexpected ? "expected to contain at least" : "expected", this.expectedMultimap));
                } else {
                    MultimapSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.simpleFact("keys are not in order"), Fact.simpleFact("---"), Fact.fact(this.allowUnexpected ? "expected to contain at least" : "expected", this.expectedMultimap));
                }
            } else if (!keysWithValuesOutOfOrder.isEmpty()) {
                MultimapSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.fact("keys with out-of-order values", keysWithValuesOutOfOrder), Fact.simpleFact("---"), Fact.fact(this.allowUnexpected ? "expected to contain at least" : "expected", this.expectedMultimap));
            }
        }
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<? super A, ? super E> correspondence;

        private UsingCorrespondence(Correspondence<? super A, ? super E> correspondence) {
            this.correspondence = Preconditions.checkNotNull(correspondence);
        }

        public void containsEntry(Object expectedKey, E expectedValue) {
            if (Preconditions.checkNotNull(MultimapSubject.this.actual).containsKey(expectedKey)) {
                Collection<A> actualValues = Preconditions.checkNotNull(this.getCastActual().asMap().get(expectedKey));
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (A actualValue : actualValues) {
                    if (!this.correspondence.safeCompare(actualValue, expectedValue, exceptions)) continue;
                    if (exceptions.hasCompareException()) {
                        MultimapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(exceptions.describeAsMainCause())).add(Fact.fact("expected to contain entry", Maps.immutableEntry(expectedKey, expectedValue)))).addAll(this.correspondence.describeForMapValues())).add(Fact.fact("found match (but failing because of exception)", Maps.immutableEntry(expectedKey, actualValue)))).add(Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).build());
                    }
                    return;
                }
                MultimapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Fact.fact("expected to contain entry", Maps.immutableEntry(expectedKey, expectedValue)))).addAll(this.correspondence.describeForMapValues())).add(Fact.simpleFact("but did not"))).add(Fact.fact("though it did contain values for that key", actualValues))).add(Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).addAll(exceptions.describeAsAdditionalInfo())).build());
            } else {
                LinkedHashSet entries = new LinkedHashSet();
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (Map.Entry<?, A> actualEntry : this.getCastActual().entries()) {
                    if (!this.correspondence.safeCompare(actualEntry.getValue(), expectedValue, exceptions)) continue;
                    entries.add(actualEntry);
                }
                if (!entries.isEmpty()) {
                    MultimapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Fact.fact("expected to contain entry", Maps.immutableEntry(expectedKey, expectedValue)))).addAll(this.correspondence.describeForMapValues())).add(Fact.simpleFact("but did not"))).add(Fact.fact("though it did contain entries with matching values", entries))).add(Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).addAll(exceptions.describeAsAdditionalInfo())).build());
                } else {
                    MultimapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Fact.fact("expected to contain entry", Maps.immutableEntry(expectedKey, expectedValue)))).addAll(this.correspondence.describeForMapValues())).add(Fact.simpleFact("but did not"))).add(Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).addAll(exceptions.describeAsAdditionalInfo())).build());
                }
            }
        }

        public void doesNotContainEntry(Object excludedKey, E excludedValue) {
            if (Preconditions.checkNotNull(MultimapSubject.this.actual).containsKey(excludedKey)) {
                Collection<A> actualValues = Preconditions.checkNotNull(this.getCastActual().asMap().get(excludedKey));
                ArrayList<A> matchingValues = new ArrayList<A>();
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (A actualValue : actualValues) {
                    if (!this.correspondence.safeCompare(actualValue, excludedValue, exceptions)) continue;
                    matchingValues.add(actualValue);
                }
                if (!matchingValues.isEmpty()) {
                    MultimapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Fact.fact("expected not to contain entry", Maps.immutableEntry(excludedKey, excludedValue)))).addAll(this.correspondence.describeForMapValues())).add(Fact.fact("but contained that key with matching values", matchingValues))).add(Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).addAll(exceptions.describeAsAdditionalInfo())).build());
                } else if (exceptions.hasCompareException()) {
                    MultimapSubject.this.failWithoutActual(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(exceptions.describeAsMainCause())).add(Fact.fact("expected not to contain entry", Maps.immutableEntry(excludedKey, excludedValue)))).addAll(this.correspondence.describeForMapValues())).add(Fact.simpleFact("found no match (but failing because of exception)"))).add(Fact.fact("full contents", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()))).build());
                }
            }
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Multimap<?, ? extends E> expectedMultimap) {
            return this.internalContainsExactlyEntriesIn(expectedMultimap);
        }

        private <K, V extends E> Ordered internalContainsExactlyEntriesIn(Multimap<K, V> expectedMultimap) {
            return MultimapSubject.this.check().about(MultimapSubject.this.iterableEntries()).that(Preconditions.checkNotNull(MultimapSubject.this.actual).entries()).comparingElementsUsing(MultimapSubject.entryCorrespondence(this.correspondence)).containsExactlyElementsIn(expectedMultimap.entries());
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeastEntriesIn(Multimap<?, ? extends E> expectedMultimap) {
            return this.internalContainsAtLeastEntriesIn(expectedMultimap);
        }

        private <K, V extends E> Ordered internalContainsAtLeastEntriesIn(Multimap<K, V> expectedMultimap) {
            return MultimapSubject.this.check().about(MultimapSubject.this.iterableEntries()).that(Preconditions.checkNotNull(MultimapSubject.this.actual).entries()).comparingElementsUsing(MultimapSubject.entryCorrespondence(this.correspondence)).containsAtLeastElementsIn(expectedMultimap.entries());
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(Object k0, E v0, Object ... rest) {
            ListMultimap<Object, Object> expectedMultimap = MultimapSubject.accumulateMultimap(k0, v0, rest);
            return this.containsExactlyEntriesIn(expectedMultimap);
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly() {
            return MultimapSubject.this.containsExactly();
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeast(Object k0, E v0, Object ... rest) {
            ListMultimap<Object, Object> expectedMultimap = MultimapSubject.accumulateMultimap(k0, v0, rest);
            return this.containsAtLeastEntriesIn(expectedMultimap);
        }

        private Multimap<?, A> getCastActual() {
            return Preconditions.checkNotNull(MultimapSubject.this.actual);
        }
    }

    private static class IterableEntries
    extends IterableSubject {
        private final String stringRepresentation;

        IterableEntries(FailureMetadata metadata, MultimapSubject multimapSubject, Iterable<?> actual) {
            super(metadata, actual);
            this.stringRepresentation = String.valueOf(multimapSubject.actual);
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return this.stringRepresentation;
        }
    }
}

