/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;

public final class MultisetSubject
extends IterableSubject {
    private final Multiset<?> actual;

    MultisetSubject(FailureMetadata metadata, Multiset<?> multiset) {
        super(metadata, multiset);
        this.actual = multiset;
    }

    public final void hasCount(Object element, int expectedCount) {
        Preconditions.checkArgument(expectedCount >= 0, "expectedCount(%s) must be >= 0", expectedCount);
        int actualCount = Preconditions.checkNotNull(this.actual).count(element);
        this.check("count(%s)", element).that(actualCount).isEqualTo(expectedCount);
    }
}

