/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.targetprep.PreconditionPreparer;
import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.observatory.IDiscoverDependencies;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.AndroidJUnitTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@OptionClass(alias="apk-instrumentation-preparer")
public class ApkInstrumentationPreparer
extends PreconditionPreparer
implements IConfigurationReceiver,
IDiscoverDependencies {
    @Option(name="apk", description="Name of the apk to instrument", mandatory=true)
    protected String mApkFileName = null;
    @Option(name="package", description="Name of the package", mandatory=true)
    protected String mPackageName = null;
    @Option(name="when", description="When to instrument the apk", mandatory=true)
    protected When mWhen = null;
    @Option(name="throw-error", description="Whether to throw error for device test failure")
    protected boolean mThrowError = true;
    @Option(name="apk-instrumentation-filter", description="The include filters of the test name to run in the apk", requiredForRerun=true)
    private Set<String> mIncludeFilters = new HashSet<String>();
    private IConfiguration mConfiguration = null;

    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    @Override
    public void run(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mWhen == When.AFTER) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        try {
            if (this.instrument(testInfo)) {
                LogUtil.CLog.d((String)"Target preparation successful");
            } else if (this.mThrowError) {
                throw new TargetSetupError("Not all target preparation steps completed", device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
        }
        catch (FileNotFoundException e) {
            throw new TargetSetupError("Couldn't find apk to instrument", (Throwable)e, device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (e instanceof DeviceNotAvailableException) {
            return;
        }
        if (this.mWhen == When.BEFORE) {
            return;
        }
        try {
            this.instrument(testInfo);
        }
        catch (FileNotFoundException e1) {
            LogUtil.CLog.e((String)"Couldn't find apk to instrument");
            LogUtil.CLog.e((Throwable)e1);
        }
    }

    public Set<String> reportDependencies() {
        HashSet<String> deps = new HashSet<String>();
        deps.add(this.mApkFileName);
        return deps;
    }

    private boolean instrument(TestInformation testInfo) throws DeviceNotAvailableException, FileNotFoundException {
        CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(testInfo.getBuildInfo());
        File apkFile = buildHelper.getTestFile(this.mApkFileName);
        if (!apkFile.exists()) {
            throw new FileNotFoundException(String.format("%s not found", this.mApkFileName));
        }
        ITestDevice device = testInfo.getDevice();
        if (device.getAppPackageInfo(this.mPackageName) != null) {
            LogUtil.CLog.i((String)"Package %s already present on the device, uninstalling ...", (Object[])new Object[]{this.mPackageName});
            device.uninstallPackage(this.mPackageName);
        }
        testInfo.getDevice().waitForDeviceAvailable();
        LogUtil.CLog.i((String)"Instrumenting package: %s", (Object[])new Object[]{this.mPackageName});
        CollectingTestListener listener = new CollectingTestListener();
        AndroidJUnitTest instrTest = new AndroidJUnitTest();
        instrTest.setConfiguration(this.mConfiguration);
        instrTest.setDevice(device);
        instrTest.setInstallFile(apkFile);
        instrTest.setPackageName(this.mPackageName);
        instrTest.addAllIncludeFilters(this.mIncludeFilters);
        instrTest.setRerunMode(false);
        instrTest.setReRunUsingTestFile(false);
        instrTest.setIsolatedStorage(false);
        instrTest.run(testInfo, (ITestInvocationListener)listener);
        TestRunResult result = listener.getCurrentRunResults();
        for (Map.Entry results : result.getTestResults().entrySet()) {
            if (!TestResult.TestStatus.FAILURE.equals((Object)((TestResult)results.getValue()).getStatus())) continue;
            if (this.mThrowError) {
                LogUtil.CLog.e((String)"Target preparation step %s failed.\n%s", (Object[])new Object[]{results.getKey(), ((TestResult)results.getValue()).getStackTrace()});
                continue;
            }
            LogUtil.CLog.w((String)"Target preparation step %s failed.\n%s", (Object[])new Object[]{results.getKey(), ((TestResult)results.getValue()).getStackTrace()});
        }
        return !result.isRunFailure() && !result.hasFailedTests();
    }

    public static enum When {
        BEFORE,
        AFTER,
        BOTH;

    }
}

