/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.util.CollectorUtil;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ReportLogCollector
extends BaseTargetPreparer {
    @Option(name="src-dir", description="The directory to copy to the results dir")
    private String mSrcDir;
    @Option(name="dest-dir", description="The directory under the result to store the files")
    private String mDestDir;
    @Option(name="temp-dir", description="The temp directory containing host-side report logs")
    private String mTempReportFolder;
    @Option(name="device-dir", description="Create unique directory for each device")
    private boolean mDeviceDir;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        this.prepareReportLogContainers(testInfo.getBuildInfo());
    }

    private void prepareReportLogContainers(IBuildInfo buildInfo) {
        CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(buildInfo);
        try {
            File resultDir = buildHelper.getResultDir();
            if (this.mDestDir != null) {
                resultDir = new File(resultDir, this.mDestDir);
            }
            resultDir.mkdirs();
            if (!resultDir.isDirectory()) {
                LogUtil.CLog.e((String)"%s is not a directory", (Object[])new Object[]{resultDir.getAbsolutePath()});
                return;
            }
        }
        catch (FileNotFoundException fnfe) {
            LogUtil.CLog.e((Throwable)fnfe);
        }
    }

    public void tearDown(TestInformation testInfo, Throwable e) {
        if (e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.e((String)"Invocation finished with DeviceNotAvailable, skipping collecting logs.");
            return;
        }
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        if (device.getIDevice() instanceof StubDevice) {
            LogUtil.CLog.d((String)"Skipping ReportLogCollector, it requires a device.");
            return;
        }
        CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(buildInfo);
        try {
            File hostReportDir;
            File resultDir = buildHelper.getResultDir();
            if (this.mDestDir != null) {
                resultDir = new File(resultDir, this.mDestDir);
            }
            resultDir.mkdirs();
            if (!resultDir.isDirectory()) {
                LogUtil.CLog.e((String)"%s is not a directory", (Object[])new Object[]{resultDir.getAbsolutePath()});
                return;
            }
            String tmpDirName = this.mTempReportFolder;
            if (this.mDeviceDir) {
                tmpDirName = tmpDirName.replaceAll("/$", "");
                tmpDirName = tmpDirName + "-" + device.getSerialNumber();
            }
            if (!(hostReportDir = FileUtil.createNamedTempDir((String)tmpDirName)).isDirectory()) {
                LogUtil.CLog.e((String)"%s is not a directory", (Object[])new Object[]{hostReportDir.getAbsolutePath()});
                return;
            }
            device.pullDir(this.mSrcDir, hostReportDir);
            CollectorUtil.reformatRepeatedStreams(hostReportDir);
            CollectorUtil.pullFromHost(hostReportDir, resultDir);
        }
        catch (DeviceNotAvailableException | IOException exception) {
            LogUtil.CLog.e((Throwable)exception);
        }
    }
}

