/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.compatibility.common.tradefed.testtype.BusinessLogicHostTestBase;
import com.android.compatibility.common.util.BusinessLogicExecutor;
import com.android.compatibility.common.util.BusinessLogicHostExecutor;
import com.android.tradefed.log.LogUtil;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;

public abstract class ExtraBusinessLogicHostTestBase
extends BusinessLogicHostTestBase {
    protected boolean mDependentOnBusinessLogic = true;

    public abstract List<String> getExtraBusinessLogics();

    @Override
    @Before
    public void handleBusinessLogic() {
        this.loadBusinessLogic();
        if (this.mDependentOnBusinessLogic) {
            Assert.assertTrue((String)String.format("Test \"%s\" is unable to execute as it depends on the missing remote configuration.", this.mTestCase.getMethodName()), (boolean)this.mCanReadBusinessLogic);
        } else if (!this.mCanReadBusinessLogic) {
            LogUtil.CLog.i((String)"Skipping Business Logic for %s", (Object[])new Object[]{this.mTestCase.getMethodName()});
            return;
        }
        BusinessLogicHostExecutor executor = new BusinessLogicHostExecutor(this.getDevice(), this.getBuild(), (Object)this, this.mBusinessLogic.getRedactionRegexes());
        for (String extraBusinessLogic : this.getExtraBusinessLogics()) {
            if (!this.mBusinessLogic.hasLogicFor(extraBusinessLogic)) {
                throw new RuntimeException(String.format("can't find extra business logic for %s.", extraBusinessLogic));
            }
            this.mBusinessLogic.applyLogicFor(extraBusinessLogic, (BusinessLogicExecutor)executor);
        }
        this.executeBusinessLogic();
    }
}

