/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype.retry;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.testtype.suite.CompatibilityTestSuite;
import com.android.compatibility.common.tradefed.util.RetryFilterHelper;
import com.android.compatibility.common.tradefed.util.RetryType;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.ISystemStatusCheckerReceiver;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.util.MultiMap;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Deprecated
@OptionClass(alias="compatibility")
public class RetryFactoryTest
implements IRemoteTest,
IDeviceTest,
IBuildReceiver,
ISystemStatusCheckerReceiver,
IInvocationContextReceiver,
IShardableTest,
IConfigurationReceiver {
    public static final String RETRY_OPTION = "retry";
    public static final String RETRY_TYPE_OPTION = "retry-type";
    @Option(name="retry", shortName=114, description="retry a previous session's failed and not executed tests.", mandatory=true)
    private Integer mRetrySessionId = null;
    @Option(name="subplan", description="the subplan to run", importance=Option.Importance.IF_UNSET)
    protected String mSubPlan;
    @Option(name="include-filter", description="the include module filters to apply.", importance=Option.Importance.ALWAYS)
    protected Set<String> mIncludeFilters = new HashSet<String>();
    @Option(name="exclude-filter", description="the exclude module filters to apply.", importance=Option.Importance.ALWAYS)
    protected Set<String> mExcludeFilters = new HashSet<String>();
    @Option(name="abi", shortName=97, description="the abi to test.", importance=Option.Importance.IF_UNSET)
    protected String mAbiName = null;
    @Option(name="primary-abi-only", description="Whether to run tests with only the device primary abi. This will override the --abi option.")
    protected boolean mPrimaryAbiRun = false;
    @Option(name="module", shortName=109, description="the test module to run.", importance=Option.Importance.IF_UNSET)
    protected String mModuleName = null;
    @Option(name="test", shortName=116, description="the test run.", importance=Option.Importance.IF_UNSET)
    protected String mTestName = null;
    @Option(name="module-arg", description="the arguments to pass to a module. The expected format is\"<module-name>:<arg-name>:[<arg-key>:=]<arg-value>\"", importance=Option.Importance.ALWAYS)
    private List<String> mModuleArgs = new ArrayList<String>();
    @Option(name="test-arg", description="the arguments to pass to a test. The expected format is \"<test-class>:<arg-name>:[<arg-key>:=]<arg-value>\"", importance=Option.Importance.ALWAYS)
    private List<String> mTestArgs = new ArrayList<String>();
    @Option(name="retry-type", description="used with retry, retry tests of a certain status. Possible values include \"failed\" and \"not_executed\".", importance=Option.Importance.IF_UNSET)
    protected RetryType mRetryType = null;
    @Option(name="config-patterns", description="The pattern(s) of the configurations that should be loaded from a directory. If none is explicitly specified, .*.xml and .*.config will be used. Can be repeated.")
    private List<String> mConfigPatterns = new ArrayList<String>();
    @Option(name="module-metadata-include-filter", description="Include modules for execution based on matching of metadata fields: for any of the specified filter name and value, if a module has a metadata field with the same name and value, it will be included. When both module inclusion and exclusion rules are applied, inclusion rules will be evaluated first. Using this together with test filter inclusion rules may result in no tests to execute if the rules don't overlap.")
    private MultiMap<String, String> mModuleMetadataIncludeFilter = new MultiMap();
    @Option(name="module-metadata-exclude-filter", description="Exclude modules for execution based on matching of metadata fields: for any of the specified filter name and value, if a module has a metadata field with the same name and value, it will be excluded. When both module inclusion and exclusion rules are applied, inclusion rules will be evaluated first.")
    private MultiMap<String, String> mModuleMetadataExcludeFilter = new MultiMap();
    private List<ISystemStatusChecker> mStatusCheckers;
    private IBuildInfo mBuildInfo;
    private ITestDevice mDevice;
    private IInvocationContext mContext;
    private IConfiguration mMainConfiguration;

    public void setSystemStatusChecker(List<ISystemStatusChecker> systemCheckers) {
        this.mStatusCheckers = systemCheckers;
    }

    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setInvocationContext(IInvocationContext invocationContext) {
        this.mContext = invocationContext;
    }

    public void setConfiguration(IConfiguration configuration) {
        this.mMainConfiguration = configuration;
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        CompatibilityTestSuite test = this.loadSuite();
        test.run(testInfo, listener);
    }

    public Collection<IRemoteTest> split(int shardCountHint) {
        try {
            CompatibilityTestSuite test = this.loadSuite();
            return test.split(shardCountHint);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e((String)"Failed to shard the retry run.");
            LogUtil.CLog.e((Throwable)e);
            return null;
        }
    }

    private CompatibilityTestSuite loadSuite() throws DeviceNotAvailableException {
        CompatibilityTestSuite test = this.createTest();
        CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(this.mBuildInfo);
        RetryFilterHelper helper = this.createFilterHelper(buildHelper);
        helper.validateBuildFingerprint(this.mDevice);
        helper.setBuildInfoRetryCommand(this.mBuildInfo);
        helper.setCommandLineOptionsFor((Object)test);
        helper.setCommandLineOptionsFor(this);
        helper.populateRetryFilters();
        try {
            OptionSetter setter = new OptionSetter(new Object[]{test});
            for (String moduleArg : this.mModuleArgs) {
                setter.setOptionValue("compatibility:module-arg", moduleArg);
            }
            for (String testArg : this.mTestArgs) {
                setter.setOptionValue("compatibility:test-arg", testArg);
            }
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        test.setIncludeFilter(helper.getIncludeFilters());
        test.setExcludeFilter(helper.getExcludeFilters());
        test.setDevice(this.mDevice);
        test.setBuild(this.mBuildInfo);
        test.setAbiName(this.mAbiName);
        test.setPrimaryAbiRun(this.mPrimaryAbiRun);
        test.setSystemStatusChecker(this.mStatusCheckers);
        test.setInvocationContext(this.mContext);
        test.setConfiguration(this.mMainConfiguration);
        test.addConfigPatterns(this.mConfigPatterns);
        test.addModuleMetadataIncludeFilters(this.mModuleMetadataIncludeFilter);
        test.addModuleMetadataExcludeFilters(this.mModuleMetadataExcludeFilter);
        test.resetRetryId();
        helper.tearDown();
        return test;
    }

    protected RetryFilterHelper createFilterHelper(CompatibilityBuildHelper buildHelper) {
        return new RetryFilterHelper(buildHelper, this.mRetrySessionId, this.mSubPlan, this.mIncludeFilters, this.mExcludeFilters, this.mAbiName, this.mModuleName, this.mTestName, this.mRetryType);
    }

    @VisibleForTesting
    CompatibilityTestSuite createTest() {
        return new CompatibilityTestSuite();
    }

    protected Integer getRetrySessionId() {
        return this.mRetrySessionId;
    }
}

