/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.IItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CompactMemInfoItem
implements IItem {
    public static final String PID_JSON_KEY = "pid";
    public static final String NAME_JSON_KEY = "name";
    public static final String PSS_JSON_KEY = "pss";
    public static final String SWAP_JSON_KEY = "swap";
    public static final String TYPE_JSON_KEY = "type";
    public static final String ACTIVITIES_JSON_KEY = "activities";
    public static final String PROCESSES_JSON_KEY = "processes";
    public static final String LOST_RAM_JSON_KEY = "lostRam";
    public static final String TOTAL_ZRAM_JSON_KEY = "totalZram";
    public static final String FREE_SWAP_ZRAM_JSON_KEY = "freeSwapZram";
    public static final String FREE_RAM_JSON_KEY = "freeRam";
    public static final String TUNING_LEVEL_JSON_KEY = "tuningLevel";
    private static final String NAME_ATTR_KEY = "name";
    private static final String PSS_ATTR_KEY = "pss";
    private static final String SWAP_ATTR_KEY = "swap";
    private static final String TYPE_ATTR_KEY = "type";
    private static final String ACTIVITIES_ATTR_KEY = "activities";
    private Map<Integer, Map<String, Object>> mPids = new HashMap<Integer, Map<String, Object>>();
    private long mFreeRam;
    private long mFreeSwapZram;
    private long mLostRam;
    private long mTotalZram;
    private long mTuningLevel;

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("Compact meminfo items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        JSONArray processes = new JSONArray();
        for (int pid : this.getPids()) {
            JSONObject proc = new JSONObject();
            try {
                proc.put(PID_JSON_KEY, pid);
                proc.put("name", (Object)this.getName(pid));
                proc.put("pss", this.getPss(pid));
                proc.put("swap", this.getSwap(pid));
                proc.put("type", (Object)this.getType(pid));
                proc.put("activities", this.hasActivities(pid));
                processes.put((Object)proc);
            }
            catch (JSONException jSONException) {}
        }
        try {
            object.put(PROCESSES_JSON_KEY, (Object)processes);
            object.put(LOST_RAM_JSON_KEY, this.getLostRam());
            object.put(TOTAL_ZRAM_JSON_KEY, this.getTotalZram());
            object.put(FREE_SWAP_ZRAM_JSON_KEY, this.getFreeSwapZram());
            object.put(FREE_RAM_JSON_KEY, this.getFreeRam());
            object.put(TUNING_LEVEL_JSON_KEY, this.getTuningLevel());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object;
    }

    public Set<Integer> getPids() {
        return this.mPids.keySet();
    }

    private Map<String, Object> get(int pid) {
        return this.mPids.get(pid);
    }

    public void addPid(int pid, String name, String type, long pss, long swap, boolean activities) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", name);
        attributes.put("type", type);
        attributes.put("pss", pss);
        attributes.put("swap", swap);
        attributes.put("activities", activities);
        this.mPids.put(pid, attributes);
    }

    public String getName(int pid) {
        return (String)this.get(pid).get("name");
    }

    public long getPss(int pid) {
        return (Long)this.get(pid).get("pss");
    }

    public long getSwap(int pid) {
        return (Long)this.get(pid).get("swap");
    }

    public String getType(int pid) {
        return (String)this.get(pid).get("type");
    }

    public boolean hasActivities(int pid) {
        return (Boolean)this.get(pid).get("activities");
    }

    public void setLostRam(long lostRam) {
        this.mLostRam = lostRam;
    }

    public long getLostRam() {
        return this.mLostRam;
    }

    public void setFreeRam(long freeRam) {
        this.mFreeRam = freeRam;
    }

    public long getFreeRam() {
        return this.mFreeRam;
    }

    public void setTotalZram(long totalZram) {
        this.mTotalZram = totalZram;
    }

    public long getTotalZram() {
        return this.mTotalZram;
    }

    public void setFreeSwapZram(long freeSwapZram) {
        this.mFreeSwapZram = freeSwapZram;
    }

    public long getFreeSwapZram() {
        return this.mFreeSwapZram;
    }

    public void setTuningLevel(long tuningLevel) {
        this.mTuningLevel = tuningLevel;
    }

    public long getTuningLevel() {
        return this.mTuningLevel;
    }
}

