/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.IItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GfxInfoItem
implements IItem {
    public static final String PROCESSES_KEY = "processes";
    public static final String PID_KEY = "pid";
    public static final String NAME_KEY = "name";
    public static final String TOTAL_FRAMES_KEY = "total_frames";
    public static final String JANKY_FRAMES_KEY = "janky_frames";
    public static final String PERCENTILE_90_KEY = "percentile_90";
    public static final String PERCENTILE_95_KEY = "percentile_95";
    public static final String PERCENTILE_99_KEY = "percentile_99";
    private Map<Integer, Row> mRows = new HashMap<Integer, Row>();

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("GfxInfo items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        JSONArray processes = new JSONArray();
        for (int pid : this.getPids()) {
            JSONObject proc = new JSONObject();
            try {
                proc.put(PID_KEY, pid);
                proc.put(NAME_KEY, (Object)this.getName(pid));
                proc.put(TOTAL_FRAMES_KEY, this.getTotalFrames(pid));
                proc.put(PERCENTILE_90_KEY, this.getPrecentile90(pid));
                proc.put(PERCENTILE_95_KEY, this.getPrecentile95(pid));
                proc.put(PERCENTILE_99_KEY, this.getPrecentile99(pid));
                processes.put((Object)proc);
            }
            catch (JSONException jSONException) {}
        }
        try {
            object.put(PROCESSES_KEY, (Object)processes);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object;
    }

    public Set<Integer> getPids() {
        return this.mRows.keySet();
    }

    public void addRow(int pid, String name, long totalFrames, long jankyFrames, int percentile90, int percentile95, int percentile99) {
        Row row = new Row();
        row.name = name;
        row.totalFrames = totalFrames;
        row.jankyFrames = jankyFrames;
        row.percentile90 = percentile90;
        row.percentile95 = percentile95;
        row.percentile99 = percentile99;
        this.mRows.put(pid, row);
    }

    public String getName(int pid) {
        return this.mRows.get((Object)Integer.valueOf((int)pid)).name;
    }

    public long getTotalFrames(int pid) {
        return this.mRows.get((Object)Integer.valueOf((int)pid)).totalFrames;
    }

    public long getJankyFrames(int pid) {
        return this.mRows.get((Object)Integer.valueOf((int)pid)).jankyFrames;
    }

    public int getPrecentile90(int pid) {
        return this.mRows.get((Object)Integer.valueOf((int)pid)).percentile90;
    }

    public int getPrecentile95(int pid) {
        return this.mRows.get((Object)Integer.valueOf((int)pid)).percentile95;
    }

    public int getPrecentile99(int pid) {
        return this.mRows.get((Object)Integer.valueOf((int)pid)).percentile99;
    }

    private static class Row {
        public String name;
        public long totalFrames;
        public long jankyFrames;
        public int percentile90;
        public int percentile95;
        public int percentile99;

        private Row() {
        }
    }
}

