/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.GenericItem;
import com.android.loganalysis.item.LowMemoryKillerItem;
import com.android.loganalysis.item.MiscKernelLogItem;
import com.android.loganalysis.item.PageAllocationFailureItem;
import com.android.loganalysis.item.SELinuxItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KernelLogItem
extends GenericItem {
    public static final String START_TIME = "START_TIME";
    public static final String STOP_TIME = "STOP_TIME";
    public static final String EVENTS = "EVENTS";
    private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("START_TIME", "STOP_TIME", "EVENTS"));

    public KernelLogItem() {
        super(ATTRIBUTES);
        this.setAttribute(START_TIME, 0.0);
        this.setAttribute(STOP_TIME, 0.0);
        this.setAttribute(EVENTS, new ItemList());
    }

    public Double getStartTime() {
        return (Double)this.getAttribute(START_TIME);
    }

    public void setStartTime(Double time) {
        this.setAttribute(START_TIME, time);
    }

    public Double getStopTime() {
        return (Double)this.getAttribute(STOP_TIME);
    }

    public void setStopTime(Double time) {
        this.setAttribute(STOP_TIME, time);
    }

    public List<MiscKernelLogItem> getEvents() {
        return (ItemList)this.getAttribute(EVENTS);
    }

    public void addEvent(MiscKernelLogItem event) {
        if ("KERNEL_RESET".equals(event.getCategory()) && !this.getMiscEvents("KERNEL_RESET").isEmpty()) {
            return;
        }
        ((ItemList)this.getAttribute(EVENTS)).add(event);
    }

    public List<MiscKernelLogItem> getMiscEvents(String category) {
        LinkedList<MiscKernelLogItem> items = new LinkedList<MiscKernelLogItem>();
        for (MiscKernelLogItem item : this.getEvents()) {
            if (!item.getCategory().equals(category)) continue;
            items.add(item);
        }
        return items;
    }

    public List<SELinuxItem> getSELinuxEvents() {
        LinkedList<SELinuxItem> items = new LinkedList<SELinuxItem>();
        for (MiscKernelLogItem item : this.getEvents()) {
            if (!(item instanceof SELinuxItem)) continue;
            items.add((SELinuxItem)item);
        }
        return items;
    }

    public List<LowMemoryKillerItem> getLowMemoryKillerEvents() {
        LinkedList<LowMemoryKillerItem> items = new LinkedList<LowMemoryKillerItem>();
        for (MiscKernelLogItem item : this.getEvents()) {
            if (!(item instanceof LowMemoryKillerItem)) continue;
            items.add((LowMemoryKillerItem)item);
        }
        return items;
    }

    public List<PageAllocationFailureItem> getPageAllocationFailureEvents() {
        LinkedList<PageAllocationFailureItem> items = new LinkedList<PageAllocationFailureItem>();
        for (MiscKernelLogItem item : this.getEvents()) {
            if (!(item instanceof PageAllocationFailureItem)) continue;
            items.add((PageAllocationFailureItem)item);
        }
        return items;
    }

    @Override
    public JSONObject toJson() {
        JSONObject output = super.toJson();
        JSONArray events = new JSONArray();
        for (MiscKernelLogItem event : this.getEvents()) {
            events.put((Object)event.toJson());
        }
        try {
            output.put(EVENTS, (Object)events);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return output;
    }

    private class ItemList
    extends LinkedList<MiscKernelLogItem> {
        private ItemList() {
        }
    }
}

