/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.IItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QtaguidItem
implements IItem {
    public static final String USERS_KEY = "users";
    public static final String UID_KEY = "uid";
    public static final String RX_BYTES_KEY = "rx_bytes";
    public static final String TX_BYTES_KEY = "tx_bytes";
    private Map<Integer, Row> mRows = new HashMap<Integer, Row>();

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("Qtaguid items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        JSONArray users = new JSONArray();
        for (int uid : this.getUids()) {
            try {
                JSONObject user = new JSONObject();
                user.put(UID_KEY, uid);
                user.put(RX_BYTES_KEY, this.getRxBytes(uid));
                user.put(TX_BYTES_KEY, this.getTxBytes(uid));
                users.put((Object)user);
            }
            catch (JSONException jSONException) {}
        }
        try {
            object.put(USERS_KEY, (Object)users);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object;
    }

    public Set<Integer> getUids() {
        return this.mRows.keySet();
    }

    public void addRow(int uid, int rxBytes, int txBytes) {
        Row row = new Row();
        row.rxBytes = rxBytes;
        row.txBytes = txBytes;
        this.mRows.put(uid, row);
    }

    public void updateRow(int uid, int rxBytes, int txBytes) {
        if (!this.mRows.containsKey(uid)) {
            throw new IllegalArgumentException("Given UID " + uid + " is not added to QtaguidItem");
        }
        Row row = this.mRows.get(uid);
        row.rxBytes += rxBytes;
        row.txBytes += txBytes;
    }

    public boolean contains(int uid) {
        return this.mRows.containsKey(uid);
    }

    public int getRxBytes(int uid) {
        return this.mRows.get((Object)Integer.valueOf((int)uid)).rxBytes;
    }

    public int getTxBytes(int uid) {
        return this.mRows.get((Object)Integer.valueOf((int)uid)).txBytes;
    }

    private static class Row {
        public int rxBytes = 0;
        public int txBytes = 0;

        private Row() {
        }
    }
}

