/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.AnrItem;
import com.android.loganalysis.item.MiscLogcatItem;
import com.android.loganalysis.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AnrParser
implements IParser {
    public static final Pattern START = Pattern.compile("^ANR (?:\\(application not responding\\) )?in (?:process: )?(\\S+).*$");
    private static final Pattern PID = Pattern.compile("^PID: (\\d+)$");
    private static final Pattern REASON = Pattern.compile("^Reason: (.*)$");
    private static final Pattern LOAD = Pattern.compile("^Load: (\\d+\\.\\d+) / (\\d+\\.\\d+) / (\\d+\\.\\d+)$");
    private static final Pattern TOTAL = Pattern.compile("^(\\d+(\\.\\d+)?)% TOTAL: .*$");
    private static final Pattern USER = Pattern.compile("^.* (\\d+(\\.\\d+)?)% user.*$");
    private static final Pattern KERNEL = Pattern.compile("^.* (\\d+(\\.\\d+)?)% kernel.*$");
    private static final Pattern IOWAIT = Pattern.compile("^.* (\\d+(\\.\\d+)?)% iowait.*$");

    @Override
    public AnrItem parse(List<String> lines) {
        MiscLogcatItem anr = null;
        StringBuilder stack = new StringBuilder();
        boolean matchedTotal = false;
        for (String line : lines) {
            Matcher m = START.matcher(line);
            if (m.matches()) {
                anr = new AnrItem();
                anr.setApp(m.group(1));
            }
            if (anr == null) continue;
            m = PID.matcher(line);
            if (m.matches()) {
                anr.setPid(Integer.valueOf(m.group(1)));
            }
            if ((m = REASON.matcher(line)).matches()) {
                ((AnrItem)anr).setReason(m.group(1));
            }
            if ((m = LOAD.matcher(line)).matches()) {
                ((AnrItem)anr).setLoad(AnrItem.LoadCategory.LOAD_1, Double.parseDouble(m.group(1)));
                ((AnrItem)anr).setLoad(AnrItem.LoadCategory.LOAD_5, Double.parseDouble(m.group(2)));
                ((AnrItem)anr).setLoad(AnrItem.LoadCategory.LOAD_15, Double.parseDouble(m.group(3)));
            }
            m = TOTAL.matcher(line);
            if (!matchedTotal && m.matches()) {
                matchedTotal = true;
                ((AnrItem)anr).setCpuUsage(AnrItem.CpuUsageCategory.TOTAL, Double.parseDouble(m.group(1)));
                m = USER.matcher(line);
                Double usage = m.matches() ? Double.parseDouble(m.group(1)) : 0.0;
                ((AnrItem)anr).setCpuUsage(AnrItem.CpuUsageCategory.USER, usage);
                m = KERNEL.matcher(line);
                usage = m.matches() ? Double.parseDouble(m.group(1)) : 0.0;
                ((AnrItem)anr).setCpuUsage(AnrItem.CpuUsageCategory.KERNEL, usage);
                m = IOWAIT.matcher(line);
                usage = m.matches() ? Double.parseDouble(m.group(1)) : 0.0;
                ((AnrItem)anr).setCpuUsage(AnrItem.CpuUsageCategory.IOWAIT, usage);
            }
            stack.append(line);
            stack.append("\n");
        }
        if (anr != null) {
            anr.setStack(stack.toString().trim());
        }
        return anr;
    }
}

