/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.rule;

import com.android.loganalysis.item.BugreportItem;
import com.android.loganalysis.item.DumpsysWifiStatsItem;
import com.android.loganalysis.rule.AbstractPowerRule;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class WifiStatsRule
extends AbstractPowerRule {
    private static final String WIFI_STATS = "WIFI_STATS";
    private static final int WIFI_DISCONNECT_THRESHOLD = 1;
    private static final int WIFI_ASSOCIATION_THRESHOLD = 1;
    private static final long WIFI_SCAN_INTERVAL_THRESHOLD_MS = 285000L;
    private long mFrequentWifiScansIntervalSecs = 0L;
    private int mNumFrequentWifiDisconnects = 0;
    private int mNumFrequentWifiAssociations = 0;
    private BugreportItem mBugreportItem = null;

    public WifiStatsRule(BugreportItem bugreportItem) {
        super(bugreportItem);
        this.mBugreportItem = bugreportItem;
    }

    @Override
    public void applyRule() {
        long observedWifiScanIntervalMs;
        if (this.mBugreportItem.getDumpsys() == null || this.getTimeOnBattery() <= 0L) {
            return;
        }
        DumpsysWifiStatsItem dumpsysWifiStatsItem = this.mBugreportItem.getDumpsys().getWifiStats();
        if (dumpsysWifiStatsItem == null) {
            return;
        }
        if (dumpsysWifiStatsItem.getNumWifiScans() > 0 && (observedWifiScanIntervalMs = this.getTimeOnBattery() / (long)dumpsysWifiStatsItem.getNumWifiScans()) < 285000L) {
            this.mFrequentWifiScansIntervalSecs = TimeUnit.MILLISECONDS.toSeconds(observedWifiScanIntervalMs);
        }
        if (dumpsysWifiStatsItem.getNumWifiDisconnects() >= 1) {
            this.mNumFrequentWifiDisconnects = dumpsysWifiStatsItem.getNumWifiDisconnects();
        }
        if (dumpsysWifiStatsItem.getNumWifiAssociations() > 1) {
            this.mNumFrequentWifiAssociations = dumpsysWifiStatsItem.getNumWifiAssociations();
        }
    }

    @Override
    public JSONObject getAnalysis() {
        JSONObject wifiStatsAnalysis = new JSONObject();
        StringBuilder analysis = new StringBuilder();
        if (this.mFrequentWifiScansIntervalSecs == 0L) {
            analysis.append("No apps requested for frequent wifi scans. ");
        } else {
            analysis.append(String.format("Wifi scans happened every %d seconds. ", this.mFrequentWifiScansIntervalSecs));
        }
        if (this.mNumFrequentWifiDisconnects == 0) {
            analysis.append("No frequent wifi disconnects were observed. ");
        } else {
            analysis.append(String.format("Wifi got disconnected %d times. ", this.mNumFrequentWifiDisconnects));
        }
        if (this.mNumFrequentWifiAssociations == 0) {
            analysis.append("No frequent wifi associations were observed. ");
        } else {
            analysis.append(String.format("Wifi got associated with AP %d times. ", this.mNumFrequentWifiAssociations));
        }
        try {
            wifiStatsAnalysis.put(WIFI_STATS, (Object)analysis.toString().trim());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return wifiStatsAnalysis;
    }
}

