/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.BusinessLogicExecutor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.AssumptionViolatedException;

public class BusinessLogic {
    public static final String DEVICE_FILE = "/sdcard/bl";
    protected Map<String, List<BusinessLogicRulesList>> mRules;
    public boolean mConditionalTestsEnabled;
    private AuthenticationStatusEnum mAuthenticationStatus = AuthenticationStatusEnum.UNKNOWN;
    protected Date mTimestamp;
    protected List<String> mRedactionRegexes = new ArrayList<String>();

    public boolean hasLogicFor(String testName) {
        List<BusinessLogicRulesList> rulesLists = this.mRules.get(testName);
        return rulesLists != null && !rulesLists.isEmpty();
    }

    private boolean hasLogicsFor(String testName) {
        List<BusinessLogicRulesList> rulesLists = this.mRules.get(testName);
        return rulesLists != null && rulesLists.size() > 1;
    }

    public void applyLogicFor(String testName, BusinessLogicExecutor executor) {
        if (!this.hasLogicFor(testName)) {
            return;
        }
        if (this.hasLogicsFor(testName)) {
            this.applyLogicsFor(testName, executor);
            return;
        }
        BusinessLogicRulesList rulesList = this.mRules.get(testName).get(0);
        rulesList.invokeRules(executor);
    }

    private void applyLogicsFor(String testName, BusinessLogicExecutor executor) {
        HashMap<String, RuntimeException> failedMap = new HashMap<String, RuntimeException>();
        HashMap<String, RuntimeException> skippedMap = new HashMap<String, RuntimeException>();
        List<BusinessLogicRulesList> rulesLists = this.mRules.get(testName);
        for (int index = 0; index < rulesLists.size(); ++index) {
            BusinessLogicRulesList rulesList = rulesLists.get(index);
            String description = this.cleanDescription(rulesList.getDescription(), index);
            try {
                rulesList.invokeRules(executor);
                continue;
            }
            catch (RuntimeException re) {
                if (AssumptionViolatedException.class.isInstance(re)) {
                    skippedMap.put(description, re);
                    executor.logInfo("Test %s (%s) skipped for reason: %s", testName, description, re.getMessage());
                    continue;
                }
                failedMap.put(description, re);
            }
        }
        if (skippedMap.size() == rulesLists.size()) {
            BusinessLogic.throwAggregatedException(skippedMap, false);
        } else if (failedMap.size() > 0) {
            BusinessLogic.throwAggregatedException(failedMap, true);
        }
    }

    private static void throwAggregatedException(Map<String, RuntimeException> exceptions, boolean failed) {
        Set<String> keySet = exceptions.keySet();
        Object[] descriptions = keySet.toArray(new String[keySet.size()]);
        StringBuilder msg = new StringBuilder("");
        msg.append(String.format("Test %s for cases: ", failed ? "failed" : "skipped"));
        msg.append(Arrays.toString(descriptions));
        msg.append("\nReasons include:");
        for (Object description : descriptions) {
            RuntimeException re = exceptions.get(description);
            msg.append(String.format("\nMessage [%s]: %s", description, re.getMessage()));
            if (!failed) continue;
            StringWriter sw = new StringWriter();
            re.printStackTrace(new PrintWriter(sw));
            msg.append(String.format("\nStack Trace: %s", sw.toString()));
        }
        if (failed) {
            throw new RuntimeException(msg.toString());
        }
        throw new AssumptionViolatedException(msg.toString());
    }

    private String cleanDescription(String description, int index) {
        return description == null || description.length() == 0 ? Integer.toString(index) : description;
    }

    public void setAuthenticationStatus(String authenticationStatus) {
        try {
            this.mAuthenticationStatus = Enum.valueOf(AuthenticationStatusEnum.class, authenticationStatus);
        }
        catch (IllegalArgumentException e) {
            this.mAuthenticationStatus = AuthenticationStatusEnum.UNKNOWN;
        }
    }

    public boolean isAuthorized() {
        return AuthenticationStatusEnum.AUTHORIZED.equals((Object)this.mAuthenticationStatus);
    }

    public Date getTimestamp() {
        return this.mTimestamp;
    }

    public List<String> getRedactionRegexes() {
        return new ArrayList<String>(this.mRedactionRegexes);
    }

    public String getAuthenticationStatusMessage() {
        switch (this.mAuthenticationStatus) {
            case AUTHORIZED: {
                return "Authorized";
            }
            case NOT_AUTHENTICATED: {
                return "authorization failed, please ensure the service account key is properly installed.";
            }
            case NOT_AUTHORIZED: {
                return "service account is not authorized to access information for this device. Please verify device properties are set correctly and account permissions are configured to the Business Logic Api.";
            }
            case NO_DEVICE_INFO: {
                return "unable to read device info files. Retry without --skip-device-info flag.";
            }
        }
        return "something went wrong, please try again.";
    }

    protected static enum AuthenticationStatusEnum {
        UNKNOWN,
        NOT_AUTHENTICATED,
        NOT_AUTHORIZED,
        AUTHORIZED,
        NO_DEVICE_INFO;

    }

    protected static class BusinessLogicRulesList {
        protected List<BusinessLogicRule> mRulesList;
        protected String mDescription;

        public BusinessLogicRulesList(List<BusinessLogicRule> rulesList) {
            this.mRulesList = rulesList;
        }

        public BusinessLogicRulesList(List<BusinessLogicRule> rulesList, String description) {
            this.mRulesList = rulesList;
            this.mDescription = description;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public List<BusinessLogicRule> getRules() {
            return this.mRulesList;
        }

        public void invokeRules(BusinessLogicExecutor executor) {
            for (BusinessLogicRule rule : this.mRulesList) {
                if (!rule.invokeConditions(executor)) continue;
                rule.invokeActions(executor);
            }
        }
    }

    protected static class BusinessLogicRuleAction {
        protected String mMethodName;
        protected List<String> mMethodArgs;

        public BusinessLogicRuleAction(String methodName, List<String> methodArgs) {
            this.mMethodName = methodName;
            this.mMethodArgs = methodArgs;
        }

        public void invoke(BusinessLogicExecutor executor) {
            executor.executeAction(this.mMethodName, this.mMethodArgs.toArray(new String[this.mMethodArgs.size()]));
        }
    }

    protected static class BusinessLogicRuleCondition {
        protected String mMethodName;
        protected List<String> mMethodArgs;
        protected boolean mNegated;

        public BusinessLogicRuleCondition(String methodName, List<String> methodArgs, boolean negated) {
            this.mMethodName = methodName;
            this.mMethodArgs = methodArgs;
            this.mNegated = negated;
        }

        public boolean invoke(BusinessLogicExecutor executor) {
            return this.mNegated != executor.executeCondition(this.mMethodName, this.mMethodArgs.toArray(new String[this.mMethodArgs.size()]));
        }
    }

    protected static class BusinessLogicRule {
        protected List<BusinessLogicRuleCondition> mConditions;
        protected List<BusinessLogicRuleAction> mActions;

        public BusinessLogicRule(List<BusinessLogicRuleCondition> conditions, List<BusinessLogicRuleAction> actions) {
            this.mConditions = conditions;
            this.mActions = actions;
        }

        public boolean invokeConditions(BusinessLogicExecutor executor) {
            for (BusinessLogicRuleCondition condition : this.mConditions) {
                if (condition.invoke(executor)) continue;
                return false;
            }
            return true;
        }

        public void invokeActions(BusinessLogicExecutor executor) {
            for (BusinessLogicRuleAction action : this.mActions) {
                action.invoke(executor);
            }
        }
    }
}

