/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.BusinessLogicExecutor;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class BusinessLogicHostExecutor
extends BusinessLogicExecutor {
    private ITestDevice mDevice;
    private IBuildInfo mBuild;
    private Object mTestObj;

    public BusinessLogicHostExecutor(ITestDevice device, IBuildInfo build, Object testObj, List<String> redactionRegexes) {
        this.mDevice = device;
        this.mBuild = build;
        this.mTestObj = testObj;
        this.mRedactionRegexes = redactionRegexes;
    }

    @Override
    protected Object getTestObject() {
        return this.mTestObj;
    }

    @Override
    @Deprecated
    public void logInfo(String format, Object ... args) {
        LogUtil.CLog.i((String)format, (Object[])args);
    }

    @Override
    @Deprecated
    public void logDebug(String format, Object ... args) {
        LogUtil.CLog.d((String)format, (Object[])args);
    }

    @Override
    protected String formatExecutionString(String method, String ... args) {
        return String.format("%s(%s)", method, String.join((CharSequence)", ", this.formatArgs(args)));
    }

    @Override
    protected BusinessLogicExecutor.ResolvedMethod getResolvedMethod(Class cls, String methodName, String ... args) throws ClassNotFoundException {
        List<Method> nameMatches = this.getMethodsWithName(cls, methodName);
        for (Method m : nameMatches) {
            Class<?>[] paramTypes;
            BusinessLogicExecutor.ResolvedMethod rm = new BusinessLogicExecutor.ResolvedMethod(m);
            int paramTypesMatched = 0;
            int argsUsed = 0;
            for (Class<?> paramType : paramTypes = m.getParameterTypes()) {
                if (argsUsed == args.length && paramType.equals(String.class)) break;
                if (paramType.equals(String.class)) {
                    rm.addArg(args[argsUsed++]);
                } else if (ITestDevice.class.isAssignableFrom(paramType)) {
                    rm.addArg(this.mDevice);
                } else if (IBuildInfo.class.isAssignableFrom(paramType)) {
                    rm.addArg(this.mBuild);
                } else {
                    if (!paramType.equals(Class.forName("[Ljava.lang.String;"))) break;
                    rm.addArg(Arrays.copyOfRange(args, argsUsed, args.length));
                    argsUsed += args.length - argsUsed;
                }
                ++paramTypesMatched;
            }
            if (paramTypesMatched != paramTypes.length || argsUsed != args.length) continue;
            return rm;
        }
        throw new RuntimeException(String.format("BusinessLogic: Failed to invoke action method %s with args: %s", methodName, Arrays.toString(args)));
    }
}

