/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashUtils {
    public static final BigInteger MIN_CRASH_ADDR = new BigInteger("8000", 16);
    public static final Pattern sEndofCrashPattern = Pattern.compile("DEBUG\\s+?:\\s+?backtrace:");
    public static final String DEVICE_PATH = "/data/local/tmp/CrashParserResults/";
    public static final String LOCK_FILENAME = "lockFile.loc";
    public static final String UPLOAD_REQUEST = "Please upload a result file to stagefright";
    public static final Pattern sUploadRequestPattern = Pattern.compile("Please upload a result file to stagefright");
    public static final String NEW_TEST_ALERT = "New test starting with name: ";
    public static final Pattern sNewTestPattern = Pattern.compile("New test starting with name: (\\w+?)\\(.*?\\)");
    public static final String SIGNAL = "signal";
    public static final String ABORT_MESSAGE = "abortmessage";
    public static final String NAME = "name";
    public static final String PROCESS = "process";
    public static final String PID = "pid";
    public static final String TID = "tid";
    public static final String FAULT_ADDRESS = "faultaddress";
    public static final String FILENAME = "filename";
    public static final String METHOD = "method";
    public static final String BACKTRACE = "backtrace";
    private static final Pattern sCrashBlobPattern = Pattern.compile("DEBUG\\s+?:( [*]{3})+?.*?DEBUG\\s+?:\\s+?backtrace:", 32);
    private static final Pattern sPidtidNamePattern = Pattern.compile("pid: (\\d+?), tid: (\\d+?), name: ([^\\s]+?\\s+?)*?>>> (.*?) <<<");
    private static final Pattern sFaultLinePattern = Pattern.compile("\\w+? \\d+? \\((.*?)\\), code -*?\\d+? \\(.*?\\), fault addr (?:0x(\\p{XDigit}+)|-+)");
    private static Pattern sAbortMessagePattern = Pattern.compile("(?i)Abort message: (.*)");
    private static Pattern sBacktraceNotePattern = Pattern.compile("[0-9\\-\\s:.]+[A-Z] DEBUG\\s+:\\s+NOTE: .*");
    private static Pattern sBacktraceFrameWithBuildIdPattern = Pattern.compile("[0-9\\-\\s:.]+[A-Z] DEBUG\\s+:\\s+#[0-9]+ pc [0-9a-fA-F]+  (?<filename>[^\\s]+)(\\s+\\((?<method>.*)\\))?\\s+\\(BuildId: .*\\)");
    private static Pattern sBacktraceFrameWithoutBuildIdPattern = Pattern.compile("[0-9\\-\\s:.]+[A-Z] DEBUG\\s+:\\s+#[0-9]+ pc [0-9a-fA-F]+  (?<filename>[^\\s]+)(\\s+\\((?<method>.*)\\))?");
    public static final String SIGSEGV = "SIGSEGV";
    public static final String SIGBUS = "SIGBUS";
    public static final String SIGABRT = "SIGABRT";

    public static String getProcessFileName(JSONObject crash) throws JSONException {
        return new File(crash.getString(PROCESS)).getName();
    }

    public static boolean securityCrashDetected(JSONArray crashes, Config config) {
        return CrashUtils.matchSecurityCrashes(crashes, config).length() > 0;
    }

    public static BigInteger getBigInteger(JSONObject source, String name) throws JSONException {
        if (source.isNull(name)) {
            return null;
        }
        String intString = source.getString(name);
        BigInteger value = null;
        try {
            value = new BigInteger(intString, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public static JSONArray matchSecurityCrashes(JSONArray crashes, Config config) {
        JSONArray securityCrashes = new JSONArray();
        for (int i = 0; i < crashes.length(); ++i) {
            try {
                List<Config.BacktraceFilterPattern> backtraceExcludes;
                BigInteger faultAddress;
                String crashSignal;
                JSONObject crash = crashes.getJSONObject(i);
                if (!CrashUtils.matchesAny(CrashUtils.getProcessFileName(crash), config.processPatterns) || !config.signals.contains(crashSignal = crash.getString(SIGNAL))) continue;
                if (crash.has(ABORT_MESSAGE)) {
                    String crashAbortMessage = crash.getString(ABORT_MESSAGE);
                    if (!config.abortMessageIncludes.isEmpty() && !config.abortMessageIncludes.stream().filter(p -> p.matcher(crashAbortMessage).find()).findFirst().isPresent() || config.abortMessageExcludes.stream().filter(p -> p.matcher(crashAbortMessage).find()).findFirst().isPresent()) continue;
                }
                if (config.checkMinAddress && (faultAddress = CrashUtils.getBigInteger(crash, FAULT_ADDRESS)) != null && faultAddress.compareTo(config.minCrashAddress) < 0) continue;
                JSONArray backtrace = crash.getJSONArray(BACKTRACE);
                List<Config.BacktraceFilterPattern> backtraceIncludes = config.getBacktraceIncludes();
                if (!backtraceIncludes.isEmpty() && !IntStream.range(0, backtrace.length()).mapToObj(j -> backtrace.optJSONObject(j)).flatMap(frame -> backtraceIncludes.stream().map(p -> p.match((JSONObject)frame))).anyMatch(matched -> matched) || !(backtraceExcludes = config.getBacktraceExcludes()).isEmpty() && IntStream.range(0, backtrace.length()).mapToObj(j -> backtrace.optJSONObject(j)).flatMap(frame -> backtraceExcludes.stream().map(p -> p.match((JSONObject)frame))).anyMatch(matched -> matched)) continue;
                securityCrashes.put((Object)crash);
                continue;
            }
            catch (NullPointerException | JSONException throwable) {
                // empty catch block
            }
        }
        return securityCrashes;
    }

    private static boolean matchesAny(String input, Collection<Pattern> patterns) {
        for (Pattern p : patterns) {
            if (!p.matcher(input).matches()) continue;
            return true;
        }
        return false;
    }

    public static JSONArray addAllCrashes(String input, JSONArray crashes) {
        Matcher crashBlobFinder = sCrashBlobPattern.matcher(input);
        while (crashBlobFinder.find()) {
            Matcher abortMessageMatcher;
            Matcher faultLineMatcher;
            String crashStr = crashBlobFinder.group(0);
            int tid = 0;
            int pid = 0;
            BigInteger faultAddress = null;
            String name = null;
            String process = null;
            String signal = null;
            String abortMessage = null;
            ArrayList<BacktraceFrameInfo> backtraceFrames = new ArrayList<BacktraceFrameInfo>();
            Matcher pidtidNameMatcher = sPidtidNamePattern.matcher(crashStr);
            if (pidtidNameMatcher.find()) {
                try {
                    pid = Integer.parseInt(pidtidNameMatcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    tid = Integer.parseInt(pidtidNameMatcher.group(2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                name = pidtidNameMatcher.group(3).trim();
                process = pidtidNameMatcher.group(4).trim();
            }
            if ((faultLineMatcher = sFaultLinePattern.matcher(crashStr)).find()) {
                signal = faultLineMatcher.group(1);
                String faultAddrMatch = faultLineMatcher.group(2);
                if (faultAddrMatch != null) {
                    try {
                        faultAddress = new BigInteger(faultAddrMatch, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if ((abortMessageMatcher = sAbortMessagePattern.matcher(crashStr)).find()) {
                abortMessage = abortMessageMatcher.group(1);
            }
            int currentIndex = crashBlobFinder.end();
            while (true) {
                int secondEndline;
                int firstEndline = input.indexOf(10, currentIndex);
                currentIndex = secondEndline = input.indexOf(10, firstEndline + 1);
                if (firstEndline == -1 || secondEndline == -1) break;
                String nextLine = input.substring(firstEndline + 1, secondEndline);
                Matcher backtraceNoteMatcher = sBacktraceNotePattern.matcher(nextLine);
                if (backtraceNoteMatcher.matches()) continue;
                Matcher backtraceFrameWithBuildIdMatcher = sBacktraceFrameWithBuildIdPattern.matcher(nextLine);
                Matcher backtraceFrameWithoutBuildIdMatcher = sBacktraceFrameWithoutBuildIdPattern.matcher(nextLine);
                Matcher backtraceFrameMatcher = null;
                if (backtraceFrameWithBuildIdMatcher.matches()) {
                    backtraceFrameMatcher = backtraceFrameWithBuildIdMatcher;
                } else {
                    if (!backtraceFrameWithoutBuildIdMatcher.matches()) break;
                    backtraceFrameMatcher = backtraceFrameWithoutBuildIdMatcher;
                }
                backtraceFrames.add(new BacktraceFrameInfo(backtraceFrameMatcher.group(FILENAME), backtraceFrameMatcher.group(METHOD)));
            }
            try {
                JSONObject crash = new JSONObject();
                crash.put(PID, pid);
                crash.put(TID, tid);
                crash.put(NAME, (Object)name);
                crash.put(PROCESS, (Object)process);
                crash.put(FAULT_ADDRESS, faultAddress == null ? null : faultAddress.toString(16));
                crash.put(SIGNAL, (Object)signal);
                crash.put(ABORT_MESSAGE, (Object)abortMessage);
                JSONArray backtrace = new JSONArray();
                for (BacktraceFrameInfo frame : backtraceFrames) {
                    backtrace.put((Object)new JSONObject().put(FILENAME, (Object)frame.getFilename()).put(METHOD, (Object)frame.getMethod()));
                }
                crash.put(BACKTRACE, (Object)backtrace);
                crashes.put((Object)crash);
            }
            catch (JSONException jSONException) {}
        }
        return crashes;
    }

    private static List<Pattern> toPatterns(String ... patternStrings) {
        return Stream.of(patternStrings).map(Pattern::compile).collect(Collectors.toList());
    }

    public static class Config {
        private boolean checkMinAddress = true;
        private BigInteger minCrashAddress = MIN_CRASH_ADDR;
        private List<String> signals;
        private List<Pattern> processPatterns;
        private List<Pattern> abortMessageIncludes;
        private List<Pattern> abortMessageExcludes;
        private List<BacktraceFilterPattern> backtraceIncludes;
        private List<BacktraceFilterPattern> backtraceExcludes;

        public Config() {
            this.setSignals(CrashUtils.SIGSEGV, CrashUtils.SIGBUS);
            this.abortMessageIncludes = new ArrayList<Pattern>();
            this.setAbortMessageExcludes("CHECK_", "CANNOT LINK EXECUTABLE");
            this.processPatterns = new ArrayList<Pattern>();
            this.backtraceIncludes = new ArrayList<BacktraceFilterPattern>();
            this.backtraceExcludes = new ArrayList<BacktraceFilterPattern>();
        }

        @CanIgnoreReturnValue
        public Config setMinAddress(BigInteger minCrashAddress) {
            this.minCrashAddress = minCrashAddress;
            return this;
        }

        @CanIgnoreReturnValue
        public Config checkMinAddress(boolean checkMinAddress) {
            this.checkMinAddress = checkMinAddress;
            return this;
        }

        @CanIgnoreReturnValue
        public Config setSignals(String ... signals) {
            this.signals = new ArrayList<String>(Arrays.asList(signals));
            return this;
        }

        @CanIgnoreReturnValue
        public Config appendSignals(String ... signals) {
            Collections.addAll(this.signals, signals);
            return this;
        }

        @CanIgnoreReturnValue
        public Config setAbortMessageIncludes(String ... abortMessages) {
            this.abortMessageIncludes = new ArrayList<Pattern>(CrashUtils.toPatterns(abortMessages));
            return this;
        }

        @CanIgnoreReturnValue
        public Config setAbortMessageIncludes(Pattern ... abortMessages) {
            this.abortMessageIncludes = new ArrayList<Pattern>(Arrays.asList(abortMessages));
            return this;
        }

        @CanIgnoreReturnValue
        public Config appendAbortMessageIncludes(String ... abortMessages) {
            this.abortMessageIncludes.addAll(CrashUtils.toPatterns(abortMessages));
            return this;
        }

        @CanIgnoreReturnValue
        public Config appendAbortMessageIncludes(Pattern ... abortMessages) {
            Collections.addAll(this.abortMessageIncludes, abortMessages);
            return this;
        }

        @CanIgnoreReturnValue
        public Config setAbortMessageExcludes(String ... abortMessages) {
            this.abortMessageExcludes = new ArrayList<Pattern>(CrashUtils.toPatterns(abortMessages));
            return this;
        }

        @CanIgnoreReturnValue
        public Config setAbortMessageExcludes(Pattern ... abortMessages) {
            this.abortMessageExcludes = new ArrayList<Pattern>(Arrays.asList(abortMessages));
            return this;
        }

        @CanIgnoreReturnValue
        public Config appendAbortMessageExcludes(String ... abortMessages) {
            this.abortMessageExcludes.addAll(CrashUtils.toPatterns(abortMessages));
            return this;
        }

        @CanIgnoreReturnValue
        public Config appendAbortMessageExcludes(Pattern ... abortMessages) {
            Collections.addAll(this.abortMessageExcludes, abortMessages);
            return this;
        }

        @CanIgnoreReturnValue
        public Config setProcessPatterns(String ... processPatternStrings) {
            this.processPatterns = new ArrayList<Pattern>(CrashUtils.toPatterns(processPatternStrings));
            return this;
        }

        @CanIgnoreReturnValue
        public Config setProcessPatterns(Pattern ... processPatterns) {
            this.processPatterns = new ArrayList<Pattern>(Arrays.asList(processPatterns));
            return this;
        }

        public List<Pattern> getProcessPatterns() {
            return Collections.unmodifiableList(this.processPatterns);
        }

        @CanIgnoreReturnValue
        public Config appendProcessPatterns(String ... processPatternStrings) {
            this.processPatterns.addAll(CrashUtils.toPatterns(processPatternStrings));
            return this;
        }

        @CanIgnoreReturnValue
        public Config appendProcessPatterns(Pattern ... processPatterns) {
            Collections.addAll(this.processPatterns, processPatterns);
            return this;
        }

        @CanIgnoreReturnValue
        public Config setBacktraceIncludes(BacktraceFilterPattern ... patterns) {
            this.backtraceIncludes = new ArrayList<BacktraceFilterPattern>(Arrays.asList(patterns));
            return this;
        }

        public List<BacktraceFilterPattern> getBacktraceIncludes() {
            return Collections.unmodifiableList(this.backtraceIncludes);
        }

        @CanIgnoreReturnValue
        public Config appendBacktraceIncludes(BacktraceFilterPattern ... patterns) {
            Collections.addAll(this.backtraceIncludes, patterns);
            return this;
        }

        @CanIgnoreReturnValue
        public Config setBacktraceExcludes(BacktraceFilterPattern ... patterns) {
            this.backtraceExcludes = new ArrayList<BacktraceFilterPattern>(Arrays.asList(patterns));
            return this;
        }

        public List<BacktraceFilterPattern> getBacktraceExcludes() {
            return Collections.unmodifiableList(this.backtraceExcludes);
        }

        @CanIgnoreReturnValue
        public Config appendBacktraceExcludes(BacktraceFilterPattern ... patterns) {
            Collections.addAll(this.backtraceExcludes, patterns);
            return this;
        }

        public static class BacktraceFilterPattern {
            private final Pattern filenamePattern;
            private final Pattern methodPattern;

            public BacktraceFilterPattern(String filenamePattern, String methodPattern) {
                this.filenamePattern = filenamePattern == null ? null : Pattern.compile(filenamePattern);
                this.methodPattern = methodPattern == null ? null : Pattern.compile(methodPattern);
            }

            public boolean match(JSONObject frame) {
                if (frame == null) {
                    return false;
                }
                String filename = frame.optString(CrashUtils.FILENAME);
                String method = frame.optString(CrashUtils.METHOD);
                boolean filenameMatches = this.filenamePattern == null || filename != null && this.filenamePattern.matcher(filename).find();
                boolean methodMatches = this.methodPattern == null || method != null && this.methodPattern.matcher(method).find();
                return filenameMatches && methodMatches;
            }
        }
    }

    public static class BacktraceFrameInfo {
        private final String filename;
        private final String method;

        public BacktraceFrameInfo(String filename, String method) {
            this.filename = filename;
            this.method = method;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

