/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.xmlpull.v1.XmlSerializer;

public class TestResultHistory
implements Serializable {
    private static final long serialVersionUID = 10L;
    private static final String ENCODING = "UTF-8";
    private static final String TYPE = "org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer";
    private static final String SUB_TEST_ATTR = "subtest";
    private static final String RUN_HISTORY_TAG = "RunHistory";
    private static final String RUN_TAG = "Run";
    private static final String START_TIME_ATTR = "start";
    private static final String END_TIME_ATTR = "end";
    private static final String IS_AUTOMATED_ATTR = "isAutomated";
    private final String mTestName;
    private final Set<ExecutionRecord> mExecutionRecords;

    public TestResultHistory(String testName, Set<ExecutionRecord> executionRecords) {
        this.mTestName = testName;
        this.mExecutionRecords = executionRecords;
    }

    public String getTestName() {
        return this.mTestName;
    }

    public Set<ExecutionRecord> getExecutionRecords() {
        return this.mExecutionRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestResultHistory that = (TestResultHistory)o;
        return Objects.equals(this.mTestName, that.mTestName) && Objects.equals(this.mExecutionRecords, that.mExecutionRecords);
    }

    public int hashCode() {
        return Objects.hash(this.mTestName, this.mExecutionRecords);
    }

    public static void serialize(XmlSerializer serializer, TestResultHistory resultHistory, String testName) throws IOException {
        if (resultHistory == null) {
            throw new IllegalArgumentException("Test result history was null");
        }
        serializer.startTag(null, RUN_HISTORY_TAG);
        String name = TestResultHistory.getSubTestName(testName, resultHistory.getTestName());
        if (!name.isEmpty() && !name.equalsIgnoreCase(testName)) {
            serializer.attribute(null, SUB_TEST_ATTR, name);
        }
        for (ExecutionRecord execRecord : resultHistory.getExecutionRecords()) {
            serializer.startTag(null, RUN_TAG);
            serializer.attribute(null, START_TIME_ATTR, String.valueOf(execRecord.getStartTime()));
            serializer.attribute(null, END_TIME_ATTR, String.valueOf(execRecord.getEndTime()));
            serializer.attribute(null, IS_AUTOMATED_ATTR, String.valueOf(execRecord.getIsAutomated()));
            serializer.endTag(null, RUN_TAG);
        }
        serializer.endTag(null, RUN_HISTORY_TAG);
    }

    protected static String getSubTestName(String testName, String fullTestName) {
        testName = testName.replace("[", "\\[").replace("]", "\\]");
        String subTestName = fullTestName.replaceFirst(testName + ":", "");
        return subTestName;
    }

    public static class ExecutionRecord
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final long startTime;
        private final long endTime;
        private final boolean isAutomated;

        public ExecutionRecord(long startTime, long endTime, boolean isAutomated) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.isAutomated = isAutomated;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public boolean getIsAutomated() {
            return this.isAutomated;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionRecord that = (ExecutionRecord)o;
            return this.startTime == that.startTime && this.endTime == that.endTime && this.isAutomated == that.isAutomated;
        }

        public int hashCode() {
            return Objects.hash(this.startTime, this.endTime, this.isAutomated);
        }
    }
}

