/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.TargetSetupError;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class UrlReplacement {
    private static final String NS = null;
    private static final String DYNAMIC_CONFIG_URL_TAG = "dynamicConfigUrl";
    private static final String URL_REPLACEMENT_TAG = "urlReplacement";
    private static final String ENTRY_TAG = "entry";
    private static final String REPLACEMENT_TAG = "replacement";
    private static final String URL_ATTR = "url";
    private static final String URL_REPLACEMENT_FILENAME = "UrlReplacement.xml";
    private static final String URL_REPLACEMENT_PATH_ENV = "URL_REPLACEMENT_PATH";
    private static String dynamicConfigServerUrl = null;
    private static Map<String, String> urlReplacementMap = new HashMap<String, String>();
    @VisibleForTesting
    static Boolean initialized = false;

    public static void init() throws TargetSetupError {
        UrlReplacement.init(UrlReplacement.getUrlReplacementConfigFile());
    }

    public static String getDynamicConfigServerUrl() {
        return dynamicConfigServerUrl;
    }

    public static Map<String, String> getUrlReplacementMap() {
        return new HashMap<String, String>(urlReplacementMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void init(File urlReplacementConfigFile) throws TargetSetupError {
        if (initialized.booleanValue()) {
            return;
        }
        Class<UrlReplacement> clazz = UrlReplacement.class;
        synchronized (UrlReplacement.class) {
            if (initialized.booleanValue()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                if (urlReplacementConfigFile.exists()) {
                    FileInputStream inputStream = new FileInputStream(urlReplacementConfigFile);
                    XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
                    parser.setInput((Reader)new InputStreamReader(inputStream));
                    parser.nextTag();
                    parser.require(2, NS, URL_REPLACEMENT_TAG);
                    parser.nextTag();
                    parser.require(2, NS, DYNAMIC_CONFIG_URL_TAG);
                    dynamicConfigServerUrl = parser.nextText();
                    parser.require(3, NS, DYNAMIC_CONFIG_URL_TAG);
                    while (parser.nextTag() == 2) {
                        parser.require(2, NS, ENTRY_TAG);
                        String key = parser.getAttributeValue(NS, URL_ATTR);
                        parser.nextTag();
                        parser.require(2, NS, REPLACEMENT_TAG);
                        String value = parser.nextText();
                        parser.require(3, NS, REPLACEMENT_TAG);
                        parser.nextTag();
                        parser.require(3, NS, ENTRY_TAG);
                        if (key == null || value == null) continue;
                        urlReplacementMap.put(key, value);
                    }
                    parser.require(3, NS, URL_REPLACEMENT_TAG);
                } else {
                    LogUtil.CLog.i((String)"UrlReplacement file [%s] does not exist", (Object[])new Object[]{urlReplacementConfigFile.getAbsolutePath()});
                }
                initialized = true;
            }
            catch (IOException | XmlPullParserException e) {
                throw new TargetSetupError("Failed to parse URL replacement config", e, (DeviceDescriptor)null);
            }
            return;
        }
    }

    @VisibleForTesting
    static File getUrlReplacementConfigFile() throws TargetSetupError {
        String urlReplacementPathEnv;
        String toolDirectory;
        CodeSource codeSource = UrlReplacement.class.getProtectionDomain().getCodeSource();
        try {
            toolDirectory = new File(codeSource.getLocation().toURI()).getParent();
        }
        catch (URISyntaxException e) {
            throw new TargetSetupError("Failed to locate urlReplacement.xml file", (Throwable)e, (DeviceDescriptor)null);
        }
        File file = new File(toolDirectory + File.separator + URL_REPLACEMENT_FILENAME);
        if (!file.exists() && (urlReplacementPathEnv = System.getenv(URL_REPLACEMENT_PATH_ENV)) != null) {
            return new File(urlReplacementPathEnv);
        }
        return file;
    }

    private UrlReplacement() {
    }
}

