/*
 * Decompiled with CFR 0.152.
 */
package com.android.json.stream;

import com.android.json.stream.JsonScope;
import com.android.json.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;

public class NewlineDelimitedJsonWriter
extends JsonWriter {
    private static final String NEW_LINE = "\n";

    public NewlineDelimitedJsonWriter(Writer out) {
        super(out);
    }

    @Override
    public void setIndent(String indent) {
        super.setIndent(null);
    }

    public void newlineDelimited() throws IOException {
        this.mOut.write(NEW_LINE);
    }

    @Override
    public void close() throws IOException {
        this.mOut.close();
    }

    @Override
    protected void beforeValue(boolean root) throws IOException {
        switch (this.peek()) {
            case EMPTY_DOCUMENT: {
                if (root) break;
                throw new IllegalStateException("JSON must start with an array or an object.");
            }
            case EMPTY_ARRAY: {
                this.replaceTop(JsonScope.NONEMPTY_ARRAY);
                this.newline();
                break;
            }
            case NONEMPTY_ARRAY: {
                this.mOut.append(',');
                this.newline();
                break;
            }
            case DANGLING_NAME: {
                this.mOut.append(this.mSeparator);
                this.replaceTop(JsonScope.NONEMPTY_OBJECT);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem: " + this.mStack);
            }
        }
    }
}

