/*
 * Decompiled with CFR 0.152.
 */
package com.android.catbox.targetpreparer;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.TestAppInstallSetup;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@OptionClass(alias="chrome-md-passenger-load")
public class ChromeMdPassengerLoadPreparer
extends BaseTargetPreparer {
    private static final String INSTR_SUCCESS = "OK (1 test)";
    @Option(name="skip-display-id", description="Display id to skip passenger load for")
    private List<Integer> mSkipDisplayIds = new ArrayList<Integer>();
    @Option(name="url", description="Url to open in Chrome browser", mandatory=true)
    private String mUrl;
    @Option(name="package", description="Chrome package")
    private String mPackage = "com.android.chrome";
    @Option(name="activity", description="Chrome activity")
    private String mActivity = "com.google.android.apps.chrome.Main";
    @Option(name="test-app-file-name", description="the name of an apk file to be installed in the user profiles.")
    private List<String> mTestFiles = new ArrayList<String>();
    Map<Integer, Integer> mDisplayToCreatedUsers = new HashMap<Integer, Integer>();
    private final ArrayList<TestAppInstallSetup> mInstallPreparers = new ArrayList();

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        int userId;
        ITestDevice device = testInfo.getDevice();
        Set displayIds = device.listDisplayIdsForStartingVisibleBackgroundUsers();
        for (Integer displayId : displayIds) {
            if (this.mSkipDisplayIds.contains(displayId)) {
                LogUtil.CLog.d((String)"Skipping load on display %d", (Object[])new Object[]{displayId});
                continue;
            }
            userId = this.createUser(device, displayId);
            this.mDisplayToCreatedUsers.put(displayId, userId);
        }
        if (this.mDisplayToCreatedUsers.size() == 0) {
            LogUtil.CLog.w((String)"Won't create any passenger load. No display ids matched.");
            throw new TargetSetupError(String.format("Available displays on the device %s. Skipped displays %s", displayIds, this.mSkipDisplayIds), device.getDeviceDescriptor());
        }
        this.installApks(testInfo);
        for (Integer displayId : this.mDisplayToCreatedUsers.keySet()) {
            userId = this.mDisplayToCreatedUsers.get(displayId);
            this.dismissInitialDialog(device, userId);
            this.simulatePassengerLoad(device, userId);
        }
    }

    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        for (TestAppInstallSetup installPreparer : this.mInstallPreparers) {
            installPreparer.tearDown(testInfo, e);
        }
        Iterator<Object> iterator = this.mDisplayToCreatedUsers.values().iterator();
        while (iterator.hasNext()) {
            int userId = (Integer)iterator.next();
            device.removeUser(userId);
        }
    }

    private int createUser(ITestDevice device, int displayId) throws TargetSetupError, DeviceNotAvailableException {
        int userId = device.createUser(String.format("user-display-%d", displayId));
        LogUtil.CLog.d((String)String.format("Created user with id %d for display %d", userId, displayId));
        if (!device.startVisibleBackgroundUser(userId, displayId, true)) {
            throw new TargetSetupError(String.format("Device failed to switch to user %d", userId), device.getDeviceDescriptor());
        }
        LogUtil.CLog.d((String)String.format("Started background user %d for display %d", userId, displayId));
        return userId;
    }

    private void installApks(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        for (int userId : this.mDisplayToCreatedUsers.values()) {
            TestAppInstallSetup installPreparer = new TestAppInstallSetup();
            LogUtil.CLog.d((String)String.format("Installing the following test APKs in user %d: \n%s", userId, this.mTestFiles));
            installPreparer.setUserId(userId);
            installPreparer.setShouldGrantPermission(true);
            for (String file : this.mTestFiles) {
                installPreparer.addTestFileName(file);
            }
            installPreparer.addInstallArg("-r");
            installPreparer.addInstallArg("-d");
            installPreparer.setUp(testInfo);
            this.mInstallPreparers.add(installPreparer);
        }
    }

    private void simulatePassengerLoad(ITestDevice device, int userId) throws TargetSetupError, DeviceNotAvailableException {
        LogUtil.CLog.d((String)String.format("Launching Chrome for User %d with url %s", userId, this.mUrl));
        String launchChromeActivityWithUrlCommand = String.format("am start -n %s/%s --user %d -a android.intent.action.VIEW -d %s", this.mPackage, this.mActivity, userId, this.mUrl);
        CommandResult result = device.executeShellV2Command(launchChromeActivityWithUrlCommand);
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            throw new TargetSetupError(String.format("Chrome activity failed to launch for user %d", userId), device.getDeviceDescriptor());
        }
    }

    private void dismissInitialDialog(ITestDevice device, int userId) throws DeviceNotAvailableException, TargetSetupError {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        String dismissCommand = String.format("am instrument -w --user %d -e class android.platform.tests.ChromeDismissDialogsTest android.platform.tests/androidx.test.runner.AndroidJUnitRunner", userId);
        device.executeShellV2Command(dismissCommand, (OutputStream)output);
        if (!((Object)output).toString().contains(INSTR_SUCCESS)) {
            throw new TargetSetupError(String.format("Failed dismissal.\nCommand output: %s", output), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
    }
}

