/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.util.HostInfoStore;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@OptionClass(alias="incremental-deqp-preparer")
public class IncrementalDeqpPreparer
extends BaseTargetPreparer {
    @Option(name="base-build", description="Absolute file path to a target file of the base build. Required for incremental dEQP.")
    private File mBaseBuild = null;
    @Option(name="current-build", description="Absolute file path to a target file of the current build. Required for incremental dEQP.")
    private File mCurrentBuild = null;
    @Option(name="extra-dependency", description="Absolute file path to a text file that includes extra dEQP test dependencies. Optional for incremental dEQP.")
    private File mExtraDependency = null;
    @Option(name="fallback-strategy", description="The fallback strategy to apply if the incremental dEQP qualification testing for the builds fails.")
    private FallbackStrategy mFallbackStrategy = FallbackStrategy.ABORT_IF_ANY_EXCEPTION;
    private static final String MODULE_NAME = "CtsDeqpTestCases";
    private static final String DEVICE_DEQP_DIR = "/data/local/tmp";
    private static final String[] TEST_LIST = new String[]{"vk-32", "vk-64", "gles3-32", "gles3-64"};
    private static final String BASE_BUILD_FINGERPRINT_ATTRIBUTE = "base_build_fingerprint";
    private static final String CURRENT_BUILD_FINGERPRINT_ATTRIBUTE = "current_build_fingerprint";
    private static final String MODULE_ATTRIBUTE = "module";
    private static final String MODULE_NAME_ATTRIBUTE = "module_name";
    private static final String DEPENDENCY_ATTRIBUTE = "deps";
    private static final String EXTRA_DEPENDENCY_ATTRIBUTE = "extra_deps";
    private static final String DEPENDENCY_CHANGES_ATTRIBUTE = "deps_changes";
    private static final String DEPENDENCY_NAME_ATTRIBUTE = "dep_name";
    private static final String DEPENDENCY_DETAIL_ATTRIBUTE = "detail";
    private static final String DEPENDENCY_BASE_BUILD_HASH_ATTRIBUTE = "base_build_hash";
    private static final String DEPENDENCY_CURRENT_BUILD_HASH_ATTRIBUTE = "current_build_hash";
    private static final String NULL_BUILD_HASH = "0";
    private static final String DEQP_BINARY_FILE_NAME_32 = "deqp-binary32";
    private static final String DEPENDENCY_DETAIL_MISSING_IN_CURRENT = "MISSING_IN_CURRENT_BUILD";
    private static final String DEPENDENCY_DETAIL_MISSING_IN_BASE = "MISSING_IN_BASE_BUILD";
    private static final String DEPENDENCY_DETAIL_MISSING_IN_BASE_AND_CURRENT = "MISSING_IN_BASE_AND_CURRENT_BUILDS";
    private static final String DEPENDENCY_DETAIL_DIFFERENT_HASH = "BASE_AND_CURRENT_BUILD_DIFFERENT_HASH";
    private static final Pattern EXCLUDE_DEQP_PATTERN = Pattern.compile("(^/data/|^/apex/|^\\[vdso\\]|^/dmabuf|^/kgsl-3d0|^/mali csf)");
    public static final String INCREMENTAL_DEQP_ATTRIBUTE_NAME = "incremental-deqp";
    public static final String REPORT_NAME = "IncrementalCtsDeviceInfo.deviceinfo.json";

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        block2: {
            try {
                ITestDevice device = testInfo.getDevice();
                CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(testInfo.getBuildInfo());
                IInvocationContext context = testInfo.getContext();
                this.runIncrementalDeqp(context, device, buildHelper);
            }
            catch (Exception e) {
                if (this.mFallbackStrategy != FallbackStrategy.ABORT_IF_ANY_EXCEPTION) break block2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runIncrementalDeqp(IInvocationContext context, ITestDevice device, CompatibilityBuildHelper buildHelper) throws TargetSetupError, DeviceNotAvailableException {
        Class<IncrementalDeqpPreparer> clazz = IncrementalDeqpPreparer.class;
        synchronized (IncrementalDeqpPreparer.class) {
            File jsonFile;
            try {
                File deviceInfoDir = new File(buildHelper.getResultDir(), "device-info-files");
                jsonFile = new File(deviceInfoDir, REPORT_NAME);
                if (jsonFile.exists()) {
                    LogUtil.CLog.i((String)"Another shard has already checked dEQP dependencies.");
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
            }
            catch (FileNotFoundException e) {
                throw new TargetSetupError("Fail to read invocation result directory.", device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            Set<String> simpleperfDependencies = this.getDeqpDependencies(device);
            Set<String> extraDependencies = this.parseExtraDependency(device);
            HashSet<String> dependencies = new HashSet<String>(simpleperfDependencies);
            dependencies.addAll(extraDependencies);
            try (HostInfoStore store = new HostInfoStore(jsonFile);){
                store.open();
                store.addResult(BASE_BUILD_FINGERPRINT_ATTRIBUTE, this.getBuildFingerPrint(this.mBaseBuild, device));
                store.addResult(CURRENT_BUILD_FINGERPRINT_ATTRIBUTE, this.getBuildFingerPrint(this.mCurrentBuild, device));
                store.startArray(MODULE_ATTRIBUTE);
                store.startGroup();
                store.addResult(MODULE_NAME_ATTRIBUTE, MODULE_NAME);
                store.addListResult(DEPENDENCY_ATTRIBUTE, simpleperfDependencies.stream().sorted().collect(Collectors.toList()));
                store.addListResult(EXTRA_DEPENDENCY_ATTRIBUTE, extraDependencies.stream().sorted().collect(Collectors.toList()));
                store.startArray(DEPENDENCY_CHANGES_ATTRIBUTE);
                boolean noChange = true;
                Map<String, String> currentBuildHashMap = this.getTargetFileHash(dependencies, this.mCurrentBuild);
                Map<String, String> baseBuildHashMap = this.getTargetFileHash(dependencies, this.mBaseBuild);
                for (String dependency : dependencies) {
                    if (!baseBuildHashMap.containsKey(dependency) && currentBuildHashMap.containsKey(dependency)) {
                        noChange = false;
                        store.startGroup();
                        store.addResult(DEPENDENCY_NAME_ATTRIBUTE, dependency);
                        store.addResult(DEPENDENCY_DETAIL_ATTRIBUTE, DEPENDENCY_DETAIL_MISSING_IN_BASE);
                        store.addResult(DEPENDENCY_BASE_BUILD_HASH_ATTRIBUTE, NULL_BUILD_HASH);
                        store.addResult(DEPENDENCY_CURRENT_BUILD_HASH_ATTRIBUTE, currentBuildHashMap.get(dependency));
                        store.endGroup();
                        continue;
                    }
                    if (!currentBuildHashMap.containsKey(dependency) && baseBuildHashMap.containsKey(dependency)) {
                        noChange = false;
                        store.startGroup();
                        store.addResult(DEPENDENCY_NAME_ATTRIBUTE, dependency);
                        store.addResult(DEPENDENCY_DETAIL_ATTRIBUTE, DEPENDENCY_DETAIL_MISSING_IN_CURRENT);
                        store.addResult(DEPENDENCY_BASE_BUILD_HASH_ATTRIBUTE, baseBuildHashMap.get(dependency));
                        store.addResult(DEPENDENCY_CURRENT_BUILD_HASH_ATTRIBUTE, NULL_BUILD_HASH);
                        store.endGroup();
                        continue;
                    }
                    if (!currentBuildHashMap.containsKey(dependency) && !baseBuildHashMap.containsKey(dependency)) {
                        noChange = false;
                        store.startGroup();
                        store.addResult(DEPENDENCY_NAME_ATTRIBUTE, dependency);
                        store.addResult(DEPENDENCY_DETAIL_ATTRIBUTE, DEPENDENCY_DETAIL_MISSING_IN_BASE_AND_CURRENT);
                        store.addResult(DEPENDENCY_BASE_BUILD_HASH_ATTRIBUTE, NULL_BUILD_HASH);
                        store.addResult(DEPENDENCY_CURRENT_BUILD_HASH_ATTRIBUTE, NULL_BUILD_HASH);
                        store.endGroup();
                        continue;
                    }
                    if (currentBuildHashMap.get(dependency).equals(baseBuildHashMap.get(dependency))) continue;
                    noChange = false;
                    store.startGroup();
                    store.addResult(DEPENDENCY_NAME_ATTRIBUTE, dependency);
                    store.addResult(DEPENDENCY_DETAIL_ATTRIBUTE, DEPENDENCY_DETAIL_DIFFERENT_HASH);
                    store.addResult(DEPENDENCY_BASE_BUILD_HASH_ATTRIBUTE, baseBuildHashMap.get(dependency));
                    store.addResult(DEPENDENCY_CURRENT_BUILD_HASH_ATTRIBUTE, currentBuildHashMap.get(dependency));
                    store.endGroup();
                }
                store.endArray();
                if (noChange) {
                    for (IBuildInfo bi : context.getBuildInfos()) {
                        bi.addBuildAttribute(INCREMENTAL_DEQP_ATTRIBUTE_NAME, "");
                    }
                }
                store.endGroup();
                store.endArray();
            }
            catch (IOException e) {
                throw new TargetSetupError("Failed to compare the builds", (Throwable)e, device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            catch (Exception e) {
                throw new TargetSetupError("Failed to write incremental dEQP report", (Throwable)e, device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            finally {
                if (jsonFile.exists() && jsonFile.length() == 0L) {
                    FileUtil.deleteFile((File)jsonFile);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private Set<String> parseExtraDependency(ITestDevice device) throws TargetSetupError {
        HashSet<String> result = new HashSet<String>();
        if (this.mExtraDependency == null) {
            return result;
        }
        try {
            for (String line : Files.readAllLines(this.mExtraDependency.toPath())) {
                result.add(line.trim());
            }
        }
        catch (IOException e) {
            throw new TargetSetupError("Failed to parse extra dependencies file.", (Throwable)e, device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
        }
        return result;
    }

    private Set<String> getDeqpDependencies(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        HashSet<String> result = new HashSet<String>();
        for (String testName : TEST_LIST) {
            String perfFile = "/data/local/tmp/" + testName + ".data";
            String binaryFile = "/data/local/tmp/" + this.getBinaryFileName(testName);
            String testFile = "/data/local/tmp/" + this.getTestFileName(testName);
            String logFile = "/data/local/tmp/" + testName + ".qpa";
            String command = String.format("cd %s && simpleperf record -o %s %s --deqp-caselist-file=%s --deqp-log-images=disable --deqp-log-shader-sources=disable --deqp-log-filename=%s --deqp-surface-type=fbo --deqp-surface-width=2048 --deqp-surface-height=2048", DEVICE_DEQP_DIR, perfFile, binaryFile, testFile, logFile);
            device.executeShellCommand(command);
            String testFileContent = device.pullFileContents(testFile);
            if (testFileContent == null || testFileContent.isEmpty()) {
                throw new TargetSetupError(String.format("Fail to read test file: %s", testFile), device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            String logContent = device.pullFileContents(logFile);
            if (logContent == null || logContent.isEmpty()) {
                throw new TargetSetupError(String.format("Fail to read simpleperf log file: %s", logFile), device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            if (!this.checkTestLog(testFileContent, logContent)) {
                throw new TargetSetupError("dEQP binary tests are not executed. This may caused by test crash.", device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            String dumpFile = "/data/local/tmp/" + testName + "-perf-dump.txt";
            String dumpCommand = String.format("simpleperf dump %s > %s", perfFile, dumpFile);
            device.executeShellCommand(dumpCommand);
            String dumpContent = device.pullFileContents(dumpFile);
            result.addAll(this.parseDump(dumpContent));
        }
        return result;
    }

    protected Map<String, String> getTargetFileHash(Set<String> fileNames, File targetFile) throws IOException, TargetSetupError {
        ZipFile zipFile = new ZipFile(targetFile);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String file : fileNames) {
            String[] arr = file.split("/", 3);
            if (arr.length < 3) {
                throw new TargetSetupError(String.format("Fail to generate zip file entry for dependency: %s. A valid dependency should be a file path located at a sub directory.", file), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
            }
            String formattedName = arr[1].toUpperCase() + "/" + arr[2];
            ZipEntry entry = zipFile.getEntry(formattedName);
            if (entry == null) {
                LogUtil.CLog.i((String)"Fail to find the file: %s in target files: %s", (Object[])new Object[]{formattedName, targetFile.getName()});
                continue;
            }
            InputStream is = zipFile.getInputStream(entry);
            String md5 = StreamUtil.calculateMd5((InputStream)is);
            hashMap.put(file, md5);
        }
        return hashMap;
    }

    protected Set<String> parseDump(String dumpContent) {
        boolean binaryExecuted = false;
        boolean correctMmap = false;
        HashSet<String> result = new HashSet<String>();
        for (String line : dumpContent.split("\n")) {
            String dependency;
            if (!binaryExecuted) {
                Pattern pattern = Pattern.compile(" comm .*deqp-binary");
                if (!pattern.matcher(line).find()) continue;
                binaryExecuted = true;
                continue;
            }
            if (!line.startsWith(" ")) {
                boolean bl = correctMmap = line.startsWith("record mmap") && !line.contains("misc 1");
            }
            if (!line.contains("filename") || !correctMmap || EXCLUDE_DEQP_PATTERN.matcher(dependency = line.substring(line.indexOf("filename") + 9).trim()).find()) continue;
            result.add(dependency);
        }
        return result;
    }

    protected boolean checkTestLog(String testListContent, String logContent) {
        int testCount = testListContent.split("\n").length;
        int executedTestCount = 0;
        for (String line : logContent.split("\n")) {
            if (!line.contains("StatusCode=")) continue;
            ++executedTestCount;
        }
        return executedTestCount == testCount;
    }

    protected String getTestFileName(String testName) {
        if (testName.startsWith("vk")) {
            return "vk-incremental-deqp.txt";
        }
        return "gles3-incremental-deqp.txt";
    }

    protected String getBinaryFileName(String testName) {
        if (testName.endsWith("32")) {
            return DEQP_BINARY_FILE_NAME_32;
        }
        return "deqp-binary64";
    }

    protected String getBuildFingerPrint(File targetFile, ITestDevice device) throws TargetSetupError {
        String fingerprint;
        try {
            ZipFile zipFile = new ZipFile(targetFile);
            ZipEntry entry = zipFile.getEntry("SYSTEM/build.prop");
            InputStream is = zipFile.getInputStream(entry);
            Properties prop = new Properties();
            prop.load(is);
            fingerprint = prop.getProperty("ro.system.build.fingerprint");
        }
        catch (IOException e) {
            throw new TargetSetupError(String.format("Fail to get fingerprint from: %s", targetFile.getName()), (Throwable)e, device.getDeviceDescriptor(), (ErrorIdentifier)TestErrorIdentifier.TEST_ABORTED);
        }
        return fingerprint;
    }

    private static enum FallbackStrategy {
        RUN_FULL_DEQP,
        ABORT_IF_ANY_EXCEPTION;

    }
}

