/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.BusinessLogicExecutor;
import com.android.compatibility.common.util.BusinessLogicHostExecutor;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.ITestDevice;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.easymock.EasyMock;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BusinessLogicHostExecutorTest {
    private static final String THIS_CLASS = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest";
    private static final String METHOD_1 = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest.method1";
    private static final String METHOD_2 = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest.method2";
    private static final String METHOD_3 = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest.method3";
    private static final String METHOD_4 = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest.method4";
    private static final String METHOD_5 = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest.method5";
    private static final String METHOD_6 = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest.method6";
    private static final String METHOD_7 = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest.method7";
    private static final String METHOD_8 = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest.method8";
    private static final String METHOD_9 = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest.method9";
    private static final String METHOD_10 = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest.method10";
    private static final String FAKE_METHOD = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest.methodDoesntExist";
    private static final String ARG_STRING_1 = "arg1";
    private static final String ARG_STRING_2 = "arg2";
    private static final String OTHER_METHOD_1 = "com.android.compatibility.common.util.BusinessLogicHostExecutorTest$OtherClass.method1";
    private String mInvoked = null;
    private Object[] mArgsUsed = null;
    private IBuildInfo mMockBuild;
    private ITestDevice mMockDevice;
    private BusinessLogicExecutor mExecutor;

    @Before
    public void setUp() {
        this.mMockBuild = (IBuildInfo)EasyMock.createMock(IBuildInfo.class);
        this.mMockDevice = (ITestDevice)EasyMock.createMock(ITestDevice.class);
        this.mExecutor = new BusinessLogicHostExecutor(this.mMockDevice, this.mMockBuild, (Object)this, new ArrayList());
        this.mInvoked = null;
        this.mArgsUsed = null;
        OtherClass.otherInvoked = null;
    }

    @Test
    public void testInvokeMethodInThisClass() throws Exception {
        this.mExecutor.invokeMethod(METHOD_1, new String[0]);
        Assert.assertEquals((String)"Failed to invoke method in this class", (String)this.mInvoked, (String)METHOD_1);
    }

    @Test
    public void testInvokeMethodInOtherClass() throws Exception {
        this.mExecutor.invokeMethod(OTHER_METHOD_1, new String[0]);
        Assert.assertEquals((String)"Failed to invoke method in other class", (String)OtherClass.otherInvoked, (String)OTHER_METHOD_1);
    }

    @Test
    public void testInvokeMethodWithStringArgs() throws Exception {
        this.mExecutor.invokeMethod(METHOD_2, new String[]{ARG_STRING_1, ARG_STRING_2});
        Assert.assertEquals((String)"Failed to invoke method in this class", (String)this.mInvoked, (String)METHOD_2);
        Assert.assertEquals((String)"Failed to set first argument", (Object)this.mArgsUsed[0], (Object)ARG_STRING_1);
        Assert.assertEquals((String)"Failed to set second argument", (Object)this.mArgsUsed[1], (Object)ARG_STRING_2);
    }

    @Test
    public void testInvokeMethodWithStringAndDeviceArgs() throws Exception {
        this.mExecutor.invokeMethod(METHOD_3, new String[]{ARG_STRING_1});
        Assert.assertEquals((String)"Failed to invoke method in this class", (String)this.mInvoked, (String)METHOD_3);
        Assert.assertEquals((String)"Failed to set first argument", (Object)this.mArgsUsed[0], (Object)ARG_STRING_1);
        Assert.assertEquals((String)"Failed to set second argument", (Object)this.mArgsUsed[1], (Object)this.mMockDevice);
    }

    @Test
    public void testInvokeMethodWithDeviceAndStringArgs() throws Exception {
        this.mExecutor.invokeMethod(METHOD_4, new String[]{ARG_STRING_1});
        Assert.assertEquals((String)"Failed to invoke method in this class", (String)this.mInvoked, (String)METHOD_4);
        Assert.assertEquals((String)"Failed to set first argument", (Object)this.mArgsUsed[0], (Object)this.mMockDevice);
        Assert.assertEquals((String)"Failed to set second argument", (Object)this.mArgsUsed[1], (Object)ARG_STRING_1);
    }

    @Test
    public void testInvokeMethodWithStringArrayArg() throws Exception {
        this.mExecutor.invokeMethod(METHOD_5, new String[]{ARG_STRING_1, ARG_STRING_2});
        Assert.assertEquals((String)"Failed to invoke method in this class", (String)this.mInvoked, (String)METHOD_5);
        Assert.assertEquals((String)"Failed to set first argument", (Object)this.mArgsUsed[0], (Object)ARG_STRING_1);
        Assert.assertEquals((String)"Failed to set second argument", (Object)this.mArgsUsed[1], (Object)ARG_STRING_2);
    }

    @Test
    public void testInvokeMethodWithEmptyStringArrayArg() throws Exception {
        this.mExecutor.invokeMethod(METHOD_5, new String[0]);
        Assert.assertEquals((String)"Failed to invoke method in this class", (String)this.mInvoked, (String)METHOD_5);
        Assert.assertEquals((String)"Incorrectly set args", (int)this.mArgsUsed.length, (int)0);
    }

    @Test
    public void testInvokeMethodWithStringAndStringArrayArgs() throws Exception {
        this.mExecutor.invokeMethod(METHOD_6, new String[]{ARG_STRING_1, ARG_STRING_2});
        Assert.assertEquals((String)"Failed to invoke method in this class", (String)this.mInvoked, (String)METHOD_6);
        Assert.assertEquals((String)"Failed to set first argument", (Object)this.mArgsUsed[0], (Object)ARG_STRING_1);
        Assert.assertEquals((String)"Failed to set second argument", (Object)this.mArgsUsed[1], (Object)ARG_STRING_2);
    }

    @Test
    public void testInvokeMethodWithAllArgTypes() throws Exception {
        this.mExecutor.invokeMethod(METHOD_7, new String[]{ARG_STRING_1, ARG_STRING_2});
        Assert.assertEquals((String)"Failed to invoke method in this class", (String)this.mInvoked, (String)METHOD_7);
        Assert.assertEquals((String)"Failed to set first argument", (Object)this.mArgsUsed[0], (Object)ARG_STRING_1);
        Assert.assertEquals((String)"Failed to set second argument", (Object)this.mArgsUsed[1], (Object)this.mMockBuild);
        Assert.assertEquals((String)"Failed to set second argument", (Object)this.mArgsUsed[2], (Object)this.mMockDevice);
        Assert.assertEquals((String)"Failed to set third argument", (Object)this.mArgsUsed[3], (Object)ARG_STRING_2);
    }

    @Test
    public void testInvokeOverloadedMethodOneArg() throws Exception {
        this.mExecutor.invokeMethod(METHOD_1, new String[]{ARG_STRING_1});
        Assert.assertEquals((String)"Failed to invoke method in this class", (String)this.mInvoked, (String)METHOD_1);
        Assert.assertEquals((String)"Set wrong number of arguments", (int)this.mArgsUsed.length, (int)1);
        Assert.assertEquals((String)"Failed to set first argument", (Object)this.mArgsUsed[0], (Object)ARG_STRING_1);
    }

    @Test
    public void testInvokeOverloadedMethodTwoArgs() throws Exception {
        this.mExecutor.invokeMethod(METHOD_1, new String[]{ARG_STRING_1, ARG_STRING_2});
        Assert.assertEquals((String)"Failed to invoke method in this class", (String)this.mInvoked, (String)METHOD_1);
        Assert.assertEquals((String)"Set wrong number of arguments", (int)this.mArgsUsed.length, (int)2);
        Assert.assertEquals((String)"Failed to set first argument", (Object)this.mArgsUsed[0], (Object)ARG_STRING_1);
        Assert.assertEquals((String)"Failed to set second argument", (Object)this.mArgsUsed[1], (Object)ARG_STRING_2);
    }

    @Test(expected=RuntimeException.class)
    public void testInvokeNonExistentMethod() throws Exception {
        this.mExecutor.invokeMethod(FAKE_METHOD, new String[]{ARG_STRING_1, ARG_STRING_2});
    }

    @Test(expected=RuntimeException.class)
    public void testInvokeMethodTooManyArgs() throws Exception {
        this.mExecutor.invokeMethod(METHOD_3, new String[]{ARG_STRING_1, ARG_STRING_2});
    }

    @Test(expected=RuntimeException.class)
    public void testInvokeMethodTooFewArgs() throws Exception {
        this.mExecutor.invokeMethod(METHOD_2, new String[]{ARG_STRING_1});
    }

    @Test(expected=RuntimeException.class)
    public void testInvokeMethodIncompatibleArgs() throws Exception {
        this.mExecutor.invokeMethod(METHOD_8, new String[]{ARG_STRING_1});
    }

    @Test
    public void testExecuteConditionCheckReturnValue() throws Exception {
        Assert.assertTrue((String)"Wrong return value", (boolean)this.mExecutor.executeCondition(METHOD_2, new String[]{ARG_STRING_1, ARG_STRING_1}));
        Assert.assertFalse((String)"Wrong return value", (boolean)this.mExecutor.executeCondition(METHOD_2, new String[]{ARG_STRING_1, ARG_STRING_2}));
    }

    @Test(expected=RuntimeException.class)
    public void testExecuteInvalidCondition() throws Exception {
        this.mExecutor.executeCondition(METHOD_1, new String[0]);
    }

    @Test
    public void testExecuteAction() throws Exception {
        this.mExecutor.executeAction(METHOD_2, new String[]{ARG_STRING_1, ARG_STRING_2});
        Assert.assertEquals((String)"Failed to invoke method in this class", (String)this.mInvoked, (String)METHOD_2);
        Assert.assertEquals((String)"Failed to set first argument", (Object)this.mArgsUsed[0], (Object)ARG_STRING_1);
        Assert.assertEquals((String)"Failed to set second argument", (Object)this.mArgsUsed[1], (Object)ARG_STRING_2);
    }

    @Test(expected=RuntimeException.class)
    public void testExecuteActionThrowException() throws Exception {
        this.mExecutor.executeAction(METHOD_9, new String[0]);
    }

    @Test
    public void testExecuteActionViolateAssumption() throws Exception {
        try {
            this.mExecutor.executeAction(METHOD_10, new String[0]);
            Assert.fail((String)"Expected assumption failure");
        }
        catch (AssumptionViolatedException assumptionViolatedException) {
            // empty catch block
        }
    }

    public void method1() {
        this.mInvoked = METHOD_1;
    }

    public void method1(String arg1) {
        this.mInvoked = METHOD_1;
        this.mArgsUsed = new Object[]{arg1};
    }

    public void method1(String arg1, String arg2) {
        this.mInvoked = METHOD_1;
        this.mArgsUsed = new Object[]{arg1, arg2};
    }

    public boolean method2(String arg1, String arg2) {
        this.mInvoked = METHOD_2;
        this.mArgsUsed = new Object[]{arg1, arg2};
        return arg1.equals(arg2);
    }

    public void method3(String arg1, ITestDevice arg2) {
        this.mInvoked = METHOD_3;
        this.mArgsUsed = new Object[]{arg1, arg2};
    }

    public void method4(ITestDevice arg1, String arg2) {
        this.mInvoked = METHOD_4;
        this.mArgsUsed = new Object[]{arg1, arg2};
    }

    public void method5(String ... args) {
        this.mInvoked = METHOD_5;
        this.mArgsUsed = args;
    }

    public void method6(String arg1, String ... moreArgs) {
        this.mInvoked = METHOD_6;
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(arg1);
        allArgs.addAll(Arrays.asList(moreArgs));
        this.mArgsUsed = allArgs.toArray(new String[0]);
    }

    public void method7(String arg1, IBuildInfo arg2, ITestDevice arg3, String ... moreArgs) {
        this.mInvoked = METHOD_7;
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(arg1);
        allArgs.add((String)arg2);
        allArgs.add((String)arg3);
        allArgs.addAll(Arrays.asList(moreArgs));
        this.mArgsUsed = allArgs.toArray(new Object[0]);
    }

    public void method8(String arg1, Integer arg2) {
    }

    @Ignore
    public void method9() throws AssertionFailedError {
        Assert.assertTrue((boolean)false);
    }

    public void method10() throws AssumptionViolatedException {
        Assume.assumeTrue((boolean)false);
    }

    public static class OtherClass {
        public static String otherInvoked = null;

        public void method1() {
            otherInvoked = BusinessLogicHostExecutorTest.OTHER_METHOD_1;
        }
    }
}

