/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ModuleResult;
import com.android.compatibility.common.util.TestStatus;
import com.android.tradefed.util.AbiUtils;
import junit.framework.TestCase;

public class ModuleResultTest
extends TestCase {
    private static final String NAME = "ModuleName";
    private static final String NAME_2 = "ModuleName2";
    private static final String ABI = "mips64";
    private static final String ID = AbiUtils.createId((String)"mips64", (String)"ModuleName");
    private static final String ID_2 = AbiUtils.createId((String)"mips64", (String)"ModuleName2");
    private static final String CLASS = "android.test.FoorBar";
    private static final String CLASS_2 = "android.test.FoorBar2";
    private static final String METHOD_1 = "testBlah1";
    private static final String METHOD_2 = "testBlah2";
    private static final String METHOD_3 = "testBlah3";
    private static final String STACK_TRACE = "Something small is not alright\n at four.big.insects.Marley.sing(Marley.java:10)";
    private ModuleResult mResult;

    public void setUp() throws Exception {
        this.mResult = new ModuleResult(ID);
    }

    public void tearDown() throws Exception {
        this.mResult = null;
    }

    public void testAccessors() throws Exception {
        ModuleResultTest.assertEquals((String)"Incorrect module ID", (String)ID, (String)this.mResult.getId());
        ModuleResultTest.assertEquals((String)"Incorrect module ABI", (String)ABI, (String)this.mResult.getAbi());
        ModuleResultTest.assertEquals((String)"Incorrect module name", (String)NAME, (String)this.mResult.getName());
    }

    public void testResultCreation() throws Exception {
        ICaseResult caseResult = this.mResult.getOrCreateResult(CLASS);
        ModuleResultTest.assertEquals((String)"Expected one result", (int)1, (int)this.mResult.getResults().size());
        ModuleResultTest.assertTrue((String)"Expected test result", (boolean)this.mResult.getResults().contains(caseResult));
        ICaseResult caseResult2 = this.mResult.getOrCreateResult(CLASS);
        ModuleResultTest.assertEquals((String)"Expected the same result", (Object)caseResult, (Object)caseResult2);
        ModuleResultTest.assertEquals((String)"Expected one result", (int)1, (int)this.mResult.getResults().size());
    }

    public void testCountResults() throws Exception {
        ICaseResult testCase = this.mResult.getOrCreateResult(CLASS);
        testCase.getOrCreateResult(METHOD_1).failed(STACK_TRACE);
        testCase.getOrCreateResult(METHOD_2).failed(STACK_TRACE);
        testCase.getOrCreateResult(METHOD_3).passed(null);
        ModuleResultTest.assertEquals((String)"Expected two failures", (int)2, (int)this.mResult.countResults(TestStatus.FAIL));
        ModuleResultTest.assertEquals((String)"Expected one pass", (int)1, (int)this.mResult.countResults(TestStatus.PASS));
    }

    public void testMergeModule() throws Exception {
        ICaseResult caseResult = this.mResult.getOrCreateResult(CLASS);
        caseResult.getOrCreateResult(METHOD_1).failed(STACK_TRACE);
        caseResult.getOrCreateResult(METHOD_3).passed(null);
        ICaseResult caseResult2 = this.mResult.getOrCreateResult(CLASS_2);
        caseResult2.getOrCreateResult(METHOD_1).failed(STACK_TRACE);
        caseResult2.getOrCreateResult(METHOD_3).passed(null);
        ModuleResultTest.assertEquals((String)"Expected two results", (int)2, (int)this.mResult.getResults().size());
        ModuleResultTest.assertTrue((String)"Expected test result", (boolean)this.mResult.getResults().contains(caseResult));
        ModuleResultTest.assertTrue((String)"Expected test result", (boolean)this.mResult.getResults().contains(caseResult2));
        ModuleResult otherResult = new ModuleResult(ID);
        ICaseResult otherCaseResult = otherResult.getOrCreateResult(CLASS);
        otherCaseResult.getOrCreateResult(METHOD_1).passed(null);
        otherCaseResult.getOrCreateResult(METHOD_2).passed(null);
        otherCaseResult.getOrCreateResult(METHOD_3).passed(null);
        otherResult.setDone(true);
        this.mResult.mergeFrom((IModuleResult)otherResult);
        ModuleResultTest.assertEquals((String)"Expected two results", (int)2, (int)this.mResult.getResults().size());
        ModuleResultTest.assertTrue((String)"Expected test result", (boolean)this.mResult.getResults().contains(caseResult));
        ModuleResultTest.assertTrue((String)"Expected test result", (boolean)this.mResult.getResults().contains(caseResult2));
        ModuleResultTest.assertTrue((boolean)this.mResult.isDone());
    }

    public void testSetDone() {
        ModuleResultTest.assertFalse((boolean)this.mResult.isDone());
        this.mResult.setDone(true);
        ModuleResultTest.assertTrue((boolean)this.mResult.isDone());
    }

    public void testMergeModule_mismatchedModuleId() throws Exception {
        ModuleResult otherResult = new ModuleResult(ID_2);
        try {
            this.mResult.mergeFrom((IModuleResult)otherResult);
            ModuleResultTest.fail((String)"Expected IlleglArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

