/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.PollingCheck;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PollingCheckTest {
    private PollingCheck.PollingCheckClock testClock;

    @Before
    public void setUp() {
        this.testClock = new TestClock();
    }

    @Test
    public void testCheckSuccess() throws Exception {
        Assert.assertTrue((String)"check failed", (boolean)PollingCheck.check((PollingCheck.PollingCheckClock)this.testClock, (long)10L, (long)100L, () -> true));
    }

    @Test
    public void testCheckEventualSuccess() throws Exception {
        int[] i = new int[]{0};
        Assert.assertTrue((String)"check failed", (boolean)PollingCheck.check((PollingCheck.PollingCheckClock)this.testClock, (long)10L, (long)1000L, () -> {
            i[0] = i[0] + 1;
            return i[0] == 3;
        }));
        Assert.assertEquals((String)"Condition expected to be checked three times", (long)3L, (long)i[0]);
        Assert.assertEquals((String)"Time advanced unexpectedly", (long)20L, (long)this.testClock.currentTimeMillis());
    }

    @Test
    public void testCheckTimeout() throws Exception {
        int[] i = new int[]{0};
        Assert.assertFalse((String)"Expected failure due to timeout", (boolean)PollingCheck.check((PollingCheck.PollingCheckClock)this.testClock, (long)10L, (long)50L, () -> {
            int n = i[0];
            i[0] = n + 1;
            return n == 9;
        }));
    }

    @Test
    public void testCheckFailure() throws Exception {
        Assert.assertFalse((String)"Expected failure due to condition not being true", (boolean)PollingCheck.check((PollingCheck.PollingCheckClock)this.testClock, (long)10L, (long)100L, () -> false));
    }

    @Test
    public void testCheckChecksConditionAtLeastOnce() throws Exception {
        boolean[] conditionChecked = new boolean[]{false};
        PollingCheck.check((PollingCheck.PollingCheckClock)this.testClock, (long)10L, (long)0L, () -> {
            conditionChecked[0] = true;
            return true;
        });
        Assert.assertTrue((String)"Expected condition to be checked", (boolean)conditionChecked[0]);
    }

    @Test
    public void testLongConditionCheck() throws Exception {
        PollingCheck.check((PollingCheck.PollingCheckClock)this.testClock, (long)10L, (long)500L, () -> {
            this.testClock.sleep(5L);
            return this.testClock.currentTimeMillis() >= 50L;
        });
        Assert.assertEquals((long)50L, (long)this.testClock.currentTimeMillis());
    }

    @Test
    public void testCheckMessage() throws Exception {
        try {
            PollingCheck.check((PollingCheck.PollingCheckClock)this.testClock, (String)"Expected message", (long)10L, (long)0L, () -> false);
        }
        catch (AssertionError e) {
            Assert.assertEquals((Object)"Expected message", (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void testWaitForTimeout() throws Exception {
        try {
            PollingCheck.waitFor((PollingCheck.PollingCheckClock)this.testClock, (long)10L, (long)500L, () -> false);
        }
        catch (AssertionError e) {
            Assert.assertEquals((Object)"Unexpected timeout waiting for condition", (Object)((Throwable)((Object)e)).getMessage());
        }
        Assert.assertEquals((long)500L, (long)this.testClock.currentTimeMillis());
    }

    @Test
    public void testWaitForSuccess() throws Exception {
        PollingCheck.waitFor((PollingCheck.PollingCheckClock)this.testClock, (long)10L, (long)500L, () -> this.testClock.currentTimeMillis() >= 200L);
        Assert.assertEquals((long)200L, (long)this.testClock.currentTimeMillis());
    }

    private final class TestClock
    implements PollingCheck.PollingCheckClock {
        private long currentTime = 0L;

        private TestClock() {
        }

        public long currentTimeMillis() {
            return this.currentTime;
        }

        public void sleep(long millis) {
            this.currentTime += millis;
        }
    }
}

