/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.instantiator.sun;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.objenesis.ObjenesisException;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.instantiator.annotations.Instantiator;
import org.objenesis.instantiator.annotations.Typology;

@Instantiator(value=Typology.STANDARD)
public class UnsafeFactoryInstantiator<T>
implements ObjectInstantiator<T> {
    private static Object unsafe;
    private static Method allocateInstance;
    private final Class<T> type;

    public UnsafeFactoryInstantiator(Class<T> type) {
        if (unsafe == null) {
            Field f;
            Class<?> unsafeClass;
            try {
                unsafeClass = Class.forName("sun.misc.Unsafe");
            }
            catch (ClassNotFoundException e) {
                throw new ObjenesisException(e);
            }
            try {
                f = unsafeClass.getDeclaredField("theUnsafe");
            }
            catch (NoSuchFieldException e) {
                throw new ObjenesisException(e);
            }
            f.setAccessible(true);
            try {
                unsafe = f.get(null);
            }
            catch (IllegalAccessException e) {
                throw new ObjenesisException(e);
            }
            try {
                allocateInstance = unsafeClass.getMethod("allocateInstance", Class.class);
            }
            catch (NoSuchMethodException e) {
                throw new ObjenesisException(e);
            }
        }
        this.type = type;
    }

    @Override
    public T newInstance() {
        try {
            return this.type.cast(allocateInstance.invoke(unsafe, this.type));
        }
        catch (InvocationTargetException e) {
            throw new ObjenesisException(e.getCause());
        }
        catch (Exception e) {
            throw new ObjenesisException(e);
        }
    }
}

