/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.build;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.build.CompatibilityBuildProvider;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import junit.framework.TestCase;

public class CompatibilityBuildHelperTest
extends TestCase {
    private static final String ROOT_PROPERTY = "TESTS_ROOT";
    private static final String BUILD_NUMBER = "2";
    private static final String SUITE_NAME = "TESTS";
    private static final String SUITE_FULL_NAME = "Compatibility Tests";
    private static final String SUITE_VERSION = "1";
    private static final String SUITE_PLAN = "cts";
    private static final String DYNAMIC_CONFIG_URL = "";
    private static final String ROOT_DIR_NAME = "root";
    private static final String BASE_DIR_NAME = "android-tests";
    private static final String TESTCASES = "testcases";
    private static final String COMMAND_LINE_ARGS = "cts -m CtsModuleTestCases";
    private static final String BUSINESS_LOGIC_HOST_FILE = "BUSINESS_LOGIC_HOST_FILE";
    private File mRoot = null;
    private File mBase = null;
    private File mTests = null;
    private IBuildInfo mBuild;
    private CompatibilityBuildHelper mHelper;

    public void setUp() throws Exception {
        this.mRoot = FileUtil.createTempDir((String)ROOT_DIR_NAME);
        CompatibilityBuildHelperTest.setProperty(this.mRoot.getAbsolutePath());
        CompatibilityBuildProvider provider = new CompatibilityBuildProvider(){

            protected String getSuiteInfoName() {
                return CompatibilityBuildHelperTest.SUITE_NAME;
            }

            protected String getSuiteInfoBuildNumber() {
                return CompatibilityBuildHelperTest.BUILD_NUMBER;
            }

            protected String getSuiteInfoFullname() {
                return CompatibilityBuildHelperTest.SUITE_FULL_NAME;
            }

            protected String getSuiteInfoVersion() {
                return CompatibilityBuildHelperTest.SUITE_VERSION;
            }
        };
        OptionSetter setter = new OptionSetter(new Object[]{provider});
        setter.setOptionValue("plan", SUITE_PLAN);
        setter.setOptionValue("dynamic-config-url", DYNAMIC_CONFIG_URL);
        this.mBuild = provider.getBuild();
        this.mHelper = new CompatibilityBuildHelper(this.mBuild);
    }

    public void tearDown() throws Exception {
        CompatibilityBuildHelperTest.setProperty(null);
        FileUtil.recursiveDelete((File)this.mRoot);
        this.mRoot = null;
        this.mBase = null;
        this.mTests = null;
    }

    private void createDirStructure() {
        this.mBase = new File(this.mRoot, BASE_DIR_NAME);
        this.mBase.mkdirs();
        this.mTests = new File(this.mBase, TESTCASES);
        this.mTests.mkdirs();
    }

    public void testSuiteInfoLoad() throws Exception {
        CompatibilityBuildHelperTest.setProperty(this.mRoot.getAbsolutePath());
        CompatibilityBuildHelperTest.assertEquals((String)"Incorrect suite build number", (String)BUILD_NUMBER, (String)this.mHelper.getSuiteBuild());
        CompatibilityBuildHelperTest.assertEquals((String)"Incorrect suite name", (String)SUITE_NAME, (String)this.mHelper.getSuiteName());
        CompatibilityBuildHelperTest.assertEquals((String)"Incorrect suite full name", (String)SUITE_FULL_NAME, (String)this.mHelper.getSuiteFullName());
        CompatibilityBuildHelperTest.assertEquals((String)"Incorrect suite version", (String)SUITE_VERSION, (String)this.mHelper.getSuiteVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProperty() throws Exception {
        CompatibilityBuildHelperTest.setProperty(null);
        CompatibilityBuildProvider provider = new CompatibilityBuildProvider(){

            protected String getSuiteInfoName() {
                return CompatibilityBuildHelperTest.SUITE_NAME;
            }
        };
        IBuildInfo info = null;
        File rootDir = null;
        try {
            OptionSetter setter = new OptionSetter(new Object[]{provider});
            setter.setOptionValue("plan", SUITE_PLAN);
            setter.setOptionValue("dynamic-config-url", DYNAMIC_CONFIG_URL);
            info = provider.getBuild();
            rootDir = new CompatibilityBuildHelper(info).getRootDir();
            CompatibilityBuildHelperTest.assertNotNull(info.getBuildAttributes().get("ROOT_DIR"));
        }
        catch (Throwable throwable) {
            provider.cleanUp(info);
            throw throwable;
        }
        provider.cleanUp(info);
        CompatibilityBuildHelperTest.setProperty(this.mRoot.getAbsolutePath());
        CompatibilityBuildHelper helper = new CompatibilityBuildHelper(provider.getBuild());
        CompatibilityBuildHelperTest.assertFalse((boolean)helper.getRootDir().equals(rootDir));
    }

    public void testValidation() throws Exception {
        CompatibilityBuildHelperTest.setProperty(this.mRoot.getAbsolutePath());
        try {
            this.mHelper.getDir();
            CompatibilityBuildHelperTest.fail((String)"Build helper validation succeeded on an invalid installation");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.createDirStructure();
        try {
            this.mHelper.getTestsDir();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            CompatibilityBuildHelperTest.fail((String)"Build helper validation failed on a valid installation");
        }
    }

    public void testDirs() throws Exception {
        CompatibilityBuildHelperTest.setProperty(this.mRoot.getAbsolutePath());
        this.createDirStructure();
        CompatibilityBuildHelperTest.assertNotNull((Object)this.mRoot);
        CompatibilityBuildHelperTest.assertNotNull((Object)this.mBuild);
        CompatibilityBuildHelperTest.assertNotNull((Object)this.mHelper.getRootDir());
        CompatibilityBuildHelperTest.assertEquals((String)"Incorrect root dir", (String)this.mRoot.getAbsolutePath(), (String)this.mHelper.getRootDir().getAbsolutePath());
        CompatibilityBuildHelperTest.assertEquals((String)"Incorrect base dir", (String)this.mBase.getAbsolutePath(), (String)this.mHelper.getDir().getAbsolutePath());
        CompatibilityBuildHelperTest.assertEquals((String)"Incorrect logs dir", (String)new File(this.mBase, "logs").getAbsolutePath(), (String)this.mHelper.getLogsDir().getAbsolutePath());
        CompatibilityBuildHelperTest.assertEquals((String)"Incorrect tests dir", (String)this.mTests.getAbsolutePath(), (String)this.mHelper.getTestsDir().getAbsolutePath());
        CompatibilityBuildHelperTest.assertEquals((String)"Incorrect results dir", (String)new File(this.mBase, "results").getAbsolutePath(), (String)this.mHelper.getResultsDir().getAbsolutePath());
    }

    public void testGetCommandLineArgs() {
        CompatibilityBuildHelperTest.assertNull((Object)this.mHelper.getCommandLineArgs());
        this.mBuild.addBuildAttribute("command_line_args", COMMAND_LINE_ARGS);
        CompatibilityBuildHelperTest.assertEquals((String)COMMAND_LINE_ARGS, (String)this.mHelper.getCommandLineArgs());
        this.mBuild.addBuildAttribute("command_line_args", "cts --retry 0");
        this.mHelper.setRetryCommandLineArgs(COMMAND_LINE_ARGS);
        CompatibilityBuildHelperTest.assertEquals((String)COMMAND_LINE_ARGS, (String)this.mHelper.getCommandLineArgs());
    }

    public void testSetModuleIds() {
        this.mHelper.setModuleIds(new String[]{"module1", "module2"});
        CompatibilityBuildHelperTest.assertEquals((String)"module1,module2", (String)((String)this.mBuild.getBuildAttributes().get("MODULE_IDS")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddDynamicFiles() throws Exception {
        this.createDirStructure();
        File tmpDynamicFile = FileUtil.createTempFile((String)"cts-test-file", (String)".dynamic");
        FileUtil.writeToFile((String)"test string", (File)tmpDynamicFile);
        try {
            this.mHelper.addDynamicConfigFile("CtsModuleName", tmpDynamicFile);
            File currentDynamicFile = (File)this.mHelper.getDynamicConfigFiles().get("CtsModuleName");
            CompatibilityBuildHelperTest.assertNotNull((Object)currentDynamicFile);
            CompatibilityBuildHelperTest.assertEquals((Object)tmpDynamicFile, (Object)currentDynamicFile);
            IBuildInfo clone = this.mBuild.clone();
            try {
                this.mBuild.cleanUp();
                CompatibilityBuildHelperTest.assertFalse((boolean)currentDynamicFile.exists());
                CompatibilityBuildHelper helperShard = new CompatibilityBuildHelper(clone);
                File newDynamicFile = (File)helperShard.getDynamicConfigFiles().get("CtsModuleName");
                CompatibilityBuildHelperTest.assertNotNull((Object)newDynamicFile);
                CompatibilityBuildHelperTest.assertFalse((boolean)tmpDynamicFile.getAbsolutePath().equals(newDynamicFile.getAbsolutePath()));
                CompatibilityBuildHelperTest.assertEquals((String)"test string", (String)FileUtil.readStringFromFile((File)newDynamicFile));
            }
            finally {
                clone.cleanUp();
            }
        }
        finally {
            FileUtil.deleteFile((File)tmpDynamicFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBusinessLogicHostFile() throws Exception {
        File tmpBLFile = FileUtil.createTempFile((String)"businesslogic-test-file", (String)".bl");
        FileUtil.writeToFile((String)"test string", (File)tmpBLFile);
        try {
            this.mHelper.setBusinessLogicHostFile(tmpBLFile);
            File currentBLFile = this.mHelper.getBusinessLogicHostFile();
            CompatibilityBuildHelperTest.assertNotNull((Object)currentBLFile);
            CompatibilityBuildHelperTest.assertEquals((Object)tmpBLFile, (Object)currentBLFile);
            IBuildInfo clone = this.mBuild.clone();
            try {
                CompatibilityBuildHelper helperShard = new CompatibilityBuildHelper(clone);
                File newBLFile = helperShard.getBusinessLogicHostFile();
                CompatibilityBuildHelperTest.assertNotNull((Object)newBLFile);
                CompatibilityBuildHelperTest.assertEquals((String)"test string", (String)FileUtil.readStringFromFile((File)newBLFile));
            }
            finally {
                clone.cleanUp();
            }
        }
        finally {
            FileUtil.deleteFile((File)tmpBLFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBusinessLogicHostFileWithModuleId() throws Exception {
        File tmpBLFile = FileUtil.createTempFile((String)"businesslogic-test-file", (String)".bl");
        FileUtil.writeToFile((String)"test string", (File)tmpBLFile);
        try {
            String moduleId = "64MODULE1";
            this.mHelper.setBusinessLogicHostFile(tmpBLFile, moduleId);
            File currentBLFile = this.mHelper.getBusinessLogicHostFile(moduleId);
            CompatibilityBuildHelperTest.assertNotNull((Object)currentBLFile);
            CompatibilityBuildHelperTest.assertEquals((Object)tmpBLFile, (Object)currentBLFile);
            IBuildInfo clone = this.mBuild.clone();
            try {
                CompatibilityBuildHelper helperShard = new CompatibilityBuildHelper(clone);
                File newBLFile = helperShard.getBusinessLogicHostFile(moduleId);
                CompatibilityBuildHelperTest.assertNotNull((Object)newBLFile);
                CompatibilityBuildHelperTest.assertEquals((String)"test string", (String)FileUtil.readStringFromFile((File)newBLFile));
            }
            finally {
                clone.cleanUp();
            }
        }
        finally {
            FileUtil.deleteFile((File)tmpBLFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHasBusinessLogicHostFile() throws Exception {
        File tmpBLFile = FileUtil.createTempFile((String)"businesslogic-test-file", (String)".bl");
        try {
            this.mBuild.setFile(BUSINESS_LOGIC_HOST_FILE, tmpBLFile, tmpBLFile.getName());
            CompatibilityBuildHelperTest.assertTrue((boolean)this.mHelper.hasBusinessLogicHostFile());
            IBuildInfo clone = this.mBuild.clone();
            try {
                CompatibilityBuildHelper helperShard = new CompatibilityBuildHelper(clone);
                CompatibilityBuildHelperTest.assertTrue((boolean)helperShard.hasBusinessLogicHostFile());
            }
            finally {
                clone.cleanUp();
            }
        }
        finally {
            FileUtil.deleteFile((File)tmpBLFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHasBusinessLogicHostFileModuleId() throws Exception {
        File tmpBLFile = FileUtil.createTempFile((String)"businesslogic-test-file", (String)".bl");
        try {
            String moduleId = "64MODULE1";
            this.mBuild.setFile(BUSINESS_LOGIC_HOST_FILE + moduleId, tmpBLFile, tmpBLFile.getName());
            CompatibilityBuildHelperTest.assertTrue((boolean)this.mHelper.hasBusinessLogicHostFile(moduleId));
            IBuildInfo clone = this.mBuild.clone();
            try {
                CompatibilityBuildHelper helperShard = new CompatibilityBuildHelper(clone);
                CompatibilityBuildHelperTest.assertTrue((boolean)helperShard.hasBusinessLogicHostFile(moduleId));
            }
            finally {
                clone.cleanUp();
            }
        }
        finally {
            FileUtil.deleteFile((File)tmpBLFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBusinessLogicHostFile() throws Exception {
        File tmpBLFile = FileUtil.createTempFile((String)"businesslogic-test-file", (String)".bl");
        FileUtil.writeToFile((String)"test string", (File)tmpBLFile);
        try {
            this.mBuild.setFile(BUSINESS_LOGIC_HOST_FILE, tmpBLFile, tmpBLFile.getName());
            File currentBLFile = this.mHelper.getBusinessLogicHostFile();
            CompatibilityBuildHelperTest.assertNotNull((Object)currentBLFile);
            CompatibilityBuildHelperTest.assertEquals((Object)tmpBLFile, (Object)currentBLFile);
            IBuildInfo clone = this.mBuild.clone();
            try {
                CompatibilityBuildHelper helperShard = new CompatibilityBuildHelper(clone);
                File newBLFile = helperShard.getBusinessLogicHostFile();
                CompatibilityBuildHelperTest.assertNotNull((Object)newBLFile);
                CompatibilityBuildHelperTest.assertEquals((String)"test string", (String)FileUtil.readStringFromFile((File)newBLFile));
            }
            finally {
                clone.cleanUp();
            }
        }
        finally {
            FileUtil.deleteFile((File)tmpBLFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBusinessLogicHostFileWithModuleId() throws Exception {
        File tmpBLFile = FileUtil.createTempFile((String)"businesslogic-test-file", (String)".bl");
        FileUtil.writeToFile((String)"test string", (File)tmpBLFile);
        try {
            String moduleId = "64MODULE1";
            this.mBuild.setFile(BUSINESS_LOGIC_HOST_FILE + moduleId, tmpBLFile, tmpBLFile.getName());
            File currentBLFile = this.mHelper.getBusinessLogicHostFile(moduleId);
            CompatibilityBuildHelperTest.assertNotNull((Object)currentBLFile);
            CompatibilityBuildHelperTest.assertEquals((Object)tmpBLFile, (Object)currentBLFile);
            IBuildInfo clone = this.mBuild.clone();
            try {
                CompatibilityBuildHelper helperShard = new CompatibilityBuildHelper(clone);
                File newBLFile = helperShard.getBusinessLogicHostFile(moduleId);
                CompatibilityBuildHelperTest.assertNotNull((Object)newBLFile);
                CompatibilityBuildHelperTest.assertEquals((String)"test string", (String)FileUtil.readStringFromFile((File)newBLFile));
            }
            finally {
                clone.cleanUp();
            }
        }
        finally {
            FileUtil.deleteFile((File)tmpBLFile);
        }
    }

    public static void setProperty(String value) {
        if (value == null) {
            System.clearProperty(ROOT_PROPERTY);
        } else {
            System.setProperty(ROOT_PROPERTY, value);
        }
    }
}

