/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.presubmit;

import com.android.compatibility.common.tradefed.targetprep.FilePusher;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.PushFilePreparer;
import com.android.tradefed.targetprep.TestAppInstallSetup;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.util.AaptParser;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ApkPackageNameCheck {
    private static final Set<String> EXCEPTION_LIST = new HashSet<String>();

    @Test
    public void testApkPackageNames() throws Exception {
        String ctsRoot = System.getProperty("CTS_ROOT");
        File testcases = new File(ctsRoot, "/android-cts/testcases/");
        if (!testcases.exists()) {
            Assert.fail((String)String.format("%s does not exists", testcases));
            return;
        }
        File[] listConfig = testcases.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".config");
            }
        });
        Assert.assertTrue((listConfig.length > 0 ? 1 : 0) != 0);
        HashMap<String, String> packageNames = new HashMap<String, String>();
        for (File config : listConfig) {
            IConfiguration c = ConfigurationFactory.getInstance().createConfigurationFromArgs(new String[]{config.getAbsolutePath()});
            ArrayList apkNames = new ArrayList();
            ArrayList<String> packageListNames = new ArrayList<String>();
            for (ITargetPreparer prep : c.getTargetPreparers()) {
                String path;
                if (prep instanceof TestAppInstallSetup) {
                    apkNames.addAll(((TestAppInstallSetup)prep).getTestsFileName());
                }
                if (prep instanceof FilePusher && ((FilePusher)prep).shouldAppendBitness()) {
                    for (File f : ((PushFilePreparer)prep).getPushSpecs(null).values()) {
                        path = f.getPath();
                        if (new File(testcases, path + "32").exists() && new File(testcases, path + "64").exists() || !((FilePusher)prep).shouldAbortOnFailure()) continue;
                        Assert.fail((String)String.format("File %s[32/64] wasn't found in testcases/ while it's expected to be pushed as part of %s", path, config.getName()));
                    }
                    continue;
                }
                if (!(prep instanceof PushFilePreparer)) continue;
                for (File f : ((PushFilePreparer)prep).getPushSpecs(null).values()) {
                    path = f.getPath();
                    if (new File(testcases, path).exists() || !((PushFilePreparer)prep).shouldAbortOnFailure()) continue;
                    Assert.fail((String)String.format("File %s wasn't found in testcases/ while it's expected to be pushed as part of %s", path, config.getName()));
                }
            }
            for (File apk : apkNames) {
                String apkName = apk.getName();
                File apkFile = new File(testcases, apkName);
                if (!apkFile.exists()) {
                    Assert.fail((String)String.format("Module %s is trying to install %s which does not exists in testcases/", config.getName(), apkFile));
                }
                AaptParser res = AaptParser.parse((File)apkFile);
                Assert.assertNotNull((Object)res);
                String packageName = res.getPackageName();
                String put = packageNames.put(packageName, apkName);
                packageListNames.add(packageName);
                if (put == null || apkName.equals(put) || EXCEPTION_LIST.contains(packageName)) continue;
                Assert.fail((String)String.format("Module %s: Package name '%s' from apk '%s' was already added by previous apk '%s'.", config.getName(), packageName, apkName, put));
            }
            List tests = c.getTests();
            for (IRemoteTest test : tests) {
                InstrumentationTest instrumentationTest;
                if (!(test instanceof InstrumentationTest) || (instrumentationTest = (InstrumentationTest)test).getPackageName() == null || packageListNames.contains(instrumentationTest.getPackageName())) continue;
                throw new ConfigurationException(String.format("Module %s requests to run '%s' but it's not part of any apks.", config.getName(), instrumentationTest.getPackageName()));
            }
        }
    }

    static {
        EXCEPTION_LIST.add("android.app.cts");
        EXCEPTION_LIST.add("android.systemui.cts");
    }
}

