/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.presubmit;

import com.android.compatibility.common.tradefed.targetprep.ApkInstaller;
import com.android.compatibility.common.tradefed.targetprep.PreconditionPreparer;
import com.android.compatibility.common.tradefed.testtype.JarHostTest;
import com.android.tradefed.build.FolderBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.shard.token.TokenProperty;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.testtype.AndroidJUnitTest;
import com.android.tradefed.testtype.HostTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.suite.params.ModuleParameters;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CtsConfigLoadingTest {
    private static final String METADATA_COMPONENT = "component";
    private static final Set<String> KNOWN_COMPONENTS = new HashSet<String>(Arrays.asList("abuse", "art", "auth", "auto", "autofill", "backup", "bionic", "bluetooth", "camera", "contentcapture", "deviceinfo", "deqp", "devtools", "framework", "graphics", "hdmi", "inputmethod", "libcore", "location", "media", "metrics", "misc", "mocking", "networking", "neuralnetworks", "print", "renderscript", "security", "statsd", "systems", "sysui", "telecom", "tv", "uitoolkit", "vr", "webview", "wifi"));
    private static final Set<String> KNOWN_MISC_MODULES = new HashSet<String>(Arrays.asList("CtsSliceTestCases.config", "CtsSampleDeviceTestCases.config", "CtsUsbTests.config", "CtsGpuToolsHostTestCases.config", "CtsEdiHostTestCases.config", "CtsClassLoaderFactoryPathClassLoaderTestCases.config", "CtsSampleHostTestCases.config", "CtsHardwareTestCases.config", "CtsMonkeyTestCases.config", "CtsAndroidAppTestCases.config", "CtsClassLoaderFactoryInMemoryDexClassLoaderTestCases.config", "CtsAppComponentFactoryTestCases.config", "CtsSeccompHostTestCases.config"));
    private static final Set<String> SUPPORTED_CTS_TEST_TYPE = new HashSet<String>(Arrays.asList("com.android.compatibility.common.tradefed.testtype.JarHostTest", "com.android.compatibility.testtype.DalvikTest", "com.android.compatibility.testtype.LibcoreTest", "com.drawelements.deqp.runner.DeqpTestRunner", "com.android.tradefed.testtype.AndroidJUnitTest", "com.android.tradefed.testtype.HostTest", "com.android.tradefed.testtype.GTest"));
    private static final Set<String> ALLOWED_INSTRUMENTATION_RUNNER_NAME = new HashSet<String>();
    private static final Set<String> RUNNER_EXCEPTION;
    private static final Set<String> MANDATORY_PARAMETERS_FAMILY;
    private static final Set<String> WHITELIST_MODULE_PARAMETERS;

    @Test
    public void testConfigurationLoad() throws Exception {
        String ctsRoot = System.getProperty("CTS_ROOT");
        File testcases = new File(ctsRoot, "/android-cts/testcases/");
        if (!testcases.exists()) {
            Assert.fail((String)String.format("%s does not exists", testcases));
            return;
        }
        File[] listConfig = testcases.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".config");
            }
        });
        Assert.assertTrue((listConfig.length > 0 ? 1 : 0) != 0);
        FolderBuildInfo stubFolder = new FolderBuildInfo("-1", "-1");
        stubFolder.setRootDir(new File(ctsRoot));
        stubFolder.addBuildAttribute("SUITE_NAME", "CTS");
        stubFolder.addBuildAttribute("ROOT_DIR", ctsRoot);
        TestInformation stubTestInfo = TestInformation.newBuilder().build();
        stubTestInfo.executionFiles().put(ExecutionFiles.FilesKey.TESTS_DIRECTORY, new File(ctsRoot));
        ArrayList<String> missingMandatoryParameters = new ArrayList<String>();
        for (File config : listConfig) {
            boolean res;
            IConfiguration c = ConfigurationFactory.getInstance().createConfigurationFromArgs(new String[]{config.getAbsolutePath()});
            for (ITargetPreparer prep : c.getTargetPreparers()) {
                if (prep.getClass().isAssignableFrom(ApkInstaller.class)) {
                    throw new ConfigurationException(String.format("%s: Use com.android.tradefed.targetprep.suite.SuiteApkInstaller instead of com.android.compatibility.common.tradefed.targetprep.ApkInstaller, options will be the same.", config));
                }
                if (!prep.getClass().isAssignableFrom(PreconditionPreparer.class)) continue;
                throw new ConfigurationException(String.format("%s: includes a PreconditionPreparer (%s) which is not allowed in modules.", config.getName(), prep.getClass()));
            }
            for (IRemoteTest test : c.getTests()) {
                AndroidJUnitTest instru;
                if (!SUPPORTED_CTS_TEST_TYPE.contains(test.getClass().getCanonicalName())) {
                    throw new ConfigurationException(String.format("testtype %s is not officially supported by CTS. The supported ones are: %s", test.getClass().getCanonicalName(), SUPPORTED_CTS_TEST_TYPE));
                }
                if (test instanceof HostTest) {
                    HostTest hostTest = (HostTest)test;
                    hostTest.setBuild((IBuildInfo)stubFolder);
                    hostTest.setTestInformation(stubTestInfo);
                    int testCount = hostTest.countTestCases();
                    if (testCount == 0) {
                        throw new ConfigurationException(String.format("%s: %s reports 0 test cases.", config.getName(), test));
                    }
                }
                if (!(test instanceof ITestFilterReceiver)) {
                    throw new IllegalArgumentException(String.format("Test in module %s must implement ITestFilterReceiver.", config.getName()));
                }
                if (!(test instanceof AndroidJUnitTest) || (instru = (AndroidJUnitTest)test).getRunnerName() == null || ALLOWED_INSTRUMENTATION_RUNNER_NAME.contains(instru.getRunnerName()) || RUNNER_EXCEPTION.contains(instru.getRunnerName())) continue;
                throw new ConfigurationException(String.format("%s: uses '%s' instead of on of '%s' that are expected", config.getName(), instru.getRunnerName(), ALLOWED_INSTRUMENTATION_RUNNER_NAME));
            }
            ConfigurationDescriptor cd = c.getConfigurationDescription();
            Assert.assertNotNull((String)(config + ": configuration descriptor is null"), (Object)cd);
            List component = cd.getMetaData(METADATA_COMPONENT);
            Assert.assertNotNull((String)String.format("Missing module metadata field \"component\", please add the following line to your AndroidTest.xml:\n<option name=\"config-descriptor:metadata\" key=\"component\" value=\"...\" />\nwhere \"value\" must be one of: %s\nconfig: %s", KNOWN_COMPONENTS, config), (Object)component);
            Assert.assertEquals((String)String.format("Module config contains more than one \"component\" metadata field: %s\nconfig: %s", component, config), (long)1L, (long)component.size());
            String cmp = (String)component.get(0);
            Assert.assertTrue((String)String.format("Module config contains unknown \"component\" metadata field \"%s\", supported ones are: %s\nconfig: %s", cmp, KNOWN_COMPONENTS, config), (boolean)KNOWN_COMPONENTS.contains(cmp));
            if ("misc".equals(cmp)) {
                String configFileName = config.getName();
                Assert.assertTrue((String)String.format("Adding new module %s to \"misc\" component is restricted, please pick a component that your module fits in", configFileName), (boolean)KNOWN_MISC_MODULES.contains(configFileName));
            }
            if (!(res = this.checkModuleParameters(config.getName(), cd.getMetaData("parameter")))) {
                missingMandatoryParameters.add(config.getName());
            }
            this.checkTokens(config.getName(), cd.getMetaData("token"));
            Assert.assertTrue((String)String.format("Module config %s does not contains '<option name=\"test-suite-tag\" value=\"cts\" />'", config.getName()), (boolean)cd.getSuiteTags().contains("cts"));
            if (cd.isNotShardable()) {
                for (IRemoteTest test : c.getTests()) {
                    if (!test.getClass().isAssignableFrom(JarHostTest.class)) continue;
                    throw new ConfigurationException(String.format("config: %s. JarHostTest does not need the not-shardable option.", config.getName()));
                }
            }
            c.validateOptions();
        }
        missingMandatoryParameters.removeAll(WHITELIST_MODULE_PARAMETERS);
        if (!missingMandatoryParameters.isEmpty()) {
            String msg = String.format("The following %s modules are missing some of the mandatory parameters [instant_app, not_instant_app, multi_abi, not_multi_abi, secondary_user, not_secondary_user]: '%s'", missingMandatoryParameters.size(), missingMandatoryParameters);
            throw new ConfigurationException(msg);
        }
    }

    private boolean checkModuleParameters(String configName, List<String> parameters) throws ConfigurationException {
        if (parameters == null) {
            return false;
        }
        Map<String, Boolean> families = this.createFamilyCheckMap();
        for (String param : parameters) {
            try {
                ModuleParameters p = ModuleParameters.valueOf((String)param.toUpperCase());
                if (!families.containsKey(p.getFamily())) continue;
                families.put(p.getFamily(), true);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.format("Config: %s includes an unknown parameter '%s'.", configName, param));
            }
        }
        return !families.containsValue(false);
    }

    private void checkTokens(String configName, List<String> tokens) throws ConfigurationException {
        if (tokens == null) {
            return;
        }
        for (String token : tokens) {
            try {
                TokenProperty.valueOf((String)token.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.format("Config: %s includes an unknown token '%s'.", configName, token));
            }
        }
    }

    private Map<String, Boolean> createFamilyCheckMap() {
        HashMap<String, Boolean> families = new HashMap<String, Boolean>();
        for (String family : MANDATORY_PARAMETERS_FAMILY) {
            families.put(family, false);
        }
        return families;
    }

    static {
        ALLOWED_INSTRUMENTATION_RUNNER_NAME.add("android.support.test.runner.AndroidJUnitRunner");
        ALLOWED_INSTRUMENTATION_RUNNER_NAME.add("androidx.test.runner.AndroidJUnitRunner");
        RUNNER_EXCEPTION = new HashSet<String>();
        RUNNER_EXCEPTION.add("repackaged.android.test.InstrumentationTestRunner");
        RUNNER_EXCEPTION.add("android.uirendering.cts.runner.UiRenderingRunner");
        MANDATORY_PARAMETERS_FAMILY = new HashSet<String>();
        MANDATORY_PARAMETERS_FAMILY.add("instant_app_family");
        MANDATORY_PARAMETERS_FAMILY.add("multi_abi_family");
        MANDATORY_PARAMETERS_FAMILY.add("secondary_user_family");
        WHITELIST_MODULE_PARAMETERS = new HashSet<String>();
        WHITELIST_MODULE_PARAMETERS.add("CtsAccessibilityServiceTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsActivityManagerBackgroundActivityTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsAppOpsTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsCarrierApiTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsContentCaptureServiceTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsDeqpTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsHiddenApiKillswitchDebugClassTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsHiddenApiKillswitchWhitelistTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsHiddenApiKillswitchWildcardTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsLocationTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsLocation2TestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsMediaTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsMediaV2TestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsOpenGlPerfTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsOsTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsPermission2TestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsPermissionTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsProviderUiTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsRsBlasTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsSkQPTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsWrapNoWrapTestCases.config");
        WHITELIST_MODULE_PARAMETERS.add("CtsWrapWrapDebugMallocDebugTestCases.config");
    }
}

