/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.presubmit;

import com.android.tradefed.config.ConfigurationException;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DupFileTest {
    private static final String[] IGNORE_DIRS = new String[]{"android/", "javax/annotation/", "com/google/protobuf/", "kotlin/", "perfetto/protos/"};
    private static final Set<String> IGNORE_JARS = ImmutableSet.of((Object)"tradefed-no-fwk.jar", (Object)"tradefed-test-framework.jar");

    @Test
    public void testDupFilesExist() throws Exception {
        List<File> jars = this.getListOfBuiltJars();
        Map<String, List<String>> filesToJars = this.getMapOfFilesAndJars(jars);
        int dupedFiles = 0;
        StringBuilder dupedFilesSummary = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : filesToJars.entrySet()) {
            String file = entry.getKey();
            List<String> jarFiles = entry.getValue();
            if (jarFiles.size() == 1) continue;
            ++dupedFiles;
            dupedFilesSummary.append(file + ": " + jarFiles.toString() + "\n");
        }
        if (dupedFiles != 0) {
            Assert.fail((String)String.format("%d files are duplicated in different jars:\n%s", dupedFiles, dupedFilesSummary.toString()));
        }
    }

    private Map<String, List<String>> getMapOfFilesAndJars(List<File> jars) throws IOException {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (File jar : jars) {
            if (IGNORE_JARS.contains(jar.getName())) continue;
            JarFile jarFile = new JarFile(jar);
            List<String> jarFileList = this.getListOfFiles(jarFile);
            jarFile.close();
            for (String file : jarFileList) {
                if (!map.containsKey(file)) {
                    map.put(file, new LinkedList());
                }
                ((List)map.get(file)).add(jar.getName());
            }
        }
        return map;
    }

    private List<File> getListOfBuiltJars() throws ConfigurationException {
        String classpathStr = System.getProperty("java.class.path");
        if (classpathStr == null) {
            throw new ConfigurationException("Could not find the classpath property: java.class.path");
        }
        ArrayList<File> listOfJars = new ArrayList<File>();
        for (String jar : classpathStr.split(":")) {
            File jarFile = new File(jar);
            if (!jarFile.exists()) continue;
            listOfJars.add(jarFile);
        }
        return listOfJars;
    }

    private List<String> getListOfFiles(JarFile jar) {
        ArrayList<String> files = new ArrayList<String>();
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String filename = entry.getName();
            if (!this.checkThisFile(filename).booleanValue()) continue;
            files.add(filename);
        }
        return files;
    }

    private Boolean checkThisFile(String filename) {
        if (!filename.endsWith(".class")) {
            return false;
        }
        for (String skipDir : IGNORE_DIRS) {
            if (!filename.startsWith(skipDir)) continue;
            return false;
        }
        return true;
    }
}

